package org.gcube.portlets.user.homelibrary.jcr.data.application;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

import org.gcube.portlets.user.homelibrary.home.data.application.ApplicationDataType;
import org.gcube.portlets.user.homelibrary.home.data.application.ApplicationList;
import org.gcube.portlets.user.homelibrary.jcr.content.JCRRepository;

public class JCRAbstractApplicationList<E> extends AbstractApplicationData implements ApplicationList<E> {
	
	protected List<E> internalList = new LinkedList<E>();
	
	public JCRAbstractApplicationList(String applicationName, String name, JCRRepository contentManager) {
		super(applicationName, name,ApplicationDataType.LIST,contentManager);
	}
	
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean add(E o) {
		boolean result = internalList.add(o);
		dataUpdated();
		return result;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void add(int index, E element) {
		internalList.add(index, element);
		dataUpdated();
	}


	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean addAll(Collection<? extends E> c) {
		boolean result = internalList.addAll(c);
		dataUpdated();
		return result;
	}


	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean addAll(int index, Collection<? extends E> c) {
		boolean result = internalList.addAll(index, c);
		dataUpdated();
		return result;
	}
	
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public void clear() {
		internalList.clear();
		dataUpdated();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean contains(Object o) {
		return internalList.contains(o);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean containsAll(Collection<?> c) {
		return internalList.containsAll(c);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public E get(int index) {
		return internalList.get(index);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public int indexOf(Object o) {
		return internalList.indexOf(o);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean isEmpty() {
		return internalList.isEmpty();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public Iterator<E> iterator() {
		return internalList.iterator();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public int lastIndexOf(Object o) {
		return internalList.lastIndexOf(o);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public ListIterator<E> listIterator() {
		return internalList.listIterator();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public ListIterator<E> listIterator(int index) {
		return internalList.listIterator(index);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public E remove(int index) {
		E result = internalList.remove(index);
		dataUpdated();
		return result;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean remove(Object o) {
		boolean result = internalList.remove(o);
		dataUpdated();
		return result;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean removeAll(Collection<?> c) {
		boolean result = internalList.removeAll(c);
		dataUpdated();
		return result;
	}


	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean retainAll(Collection<?> c) {
		boolean result = internalList.retainAll(c);
		dataUpdated();
		return result;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public E set(int index, E element) {
		E result = internalList.set(index, element);
		dataUpdated();
		return result;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public int size() {
		return internalList.size();
	}


	/**
	 * {@inheritDoc}
	 */
	@Override
	public List<E> subList(int fromIndex, int toIndex) {
		return internalList.subList(fromIndex, toIndex);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public Object[] toArray() {
		return internalList.toArray();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public <T> T[] toArray(T[] a) {
		return internalList.toArray(a);
	}
	

}
