package org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.Validate;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.FolderItemType;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.Query;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.QueryType;
import org.gcube.portlets.user.homelibrary.jcr.workspace.JCRWorkspace;

public class JCRQuery extends JCRWorkspaceFolderItem implements Query {

	private static final String NT_CONTENT 	= "nthl:queryItemContent";
	
	private static final String QUERY 		= "hl:query";
	private static final String QUERY_TYPE 	= "hl:queryType";

	private final String query;
	private final QueryType queryType;
	
	public JCRQuery(JCRWorkspace workspace, Node node) throws RepositoryException, InternalErrorException {
		super(workspace,node);
		try {
			
			Node contentNode = node.getNode(CONTENT);
			this.query = contentNode.getProperty(QUERY).getString();
			this.queryType =  QueryType.valueOf(contentNode.getProperty(QUERY_TYPE).getString());
		} catch (RepositoryException e) {
			throw new InternalErrorException(e);
		}
	}
	
	public JCRQuery(JCRWorkspace workspace, Node node, String name, String description,
			String query, QueryType queryType) throws RepositoryException {
		super(workspace, node, name, description);
		
		Validate.notNull(query, "Query must be not null");
		Validate.notNull(queryType, "Query Type must be not null");
		
		this.query = query;
		this.queryType = queryType;
		
		node.setProperty(FOLDER_ITEM_TYPE, FolderItemType.QUERY.toString());
		Node contentNode = node.addNode(CONTENT, NT_CONTENT);
		contentNode.setProperty(QUERY, query);
		contentNode.setProperty(QUERY_TYPE, queryType.toString());
		
	}

	@Override
	public long getLength() throws InternalErrorException {
		return query.length();
	}

	@Override
	public String getQuery()   {
		return query;
	}

	@Override
	public QueryType getQueryType() {
		return queryType;
	}

	@Override
	public FolderItemType getFolderItemType() {
		return FolderItemType.QUERY;
	}

	@Override
	public void saveContent(Node node) throws RepositoryException {
		
	}

}
