/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.Validate;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.FolderItemType;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.Report;
import org.gcube.portlets.user.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.JCRFile;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.JCRWorkspaceFolderItem;

public class JCRReport
extends JCRWorkspaceFolderItem
implements Report {
    private static final String CREATED = "hl:created";
    private static final String LAST_EDIT = "hl:lastEdit";
    private static final String AUTHOR = "hl:author";
    private static final String LAST_EDIT_BY = "hl:lastEditBy";
    private static final String TEMPLATE_NAME = "hl:templateName";
    private static final String NUMBER_OF_SECTION = "hl:numberOfSection";
    private static final String STATUS = "hl:status";
    private static final String NT_CONTENT = "nthl:reportItemContent";
    private final Calendar created;
    private final Calendar lastEdit;
    private final String author;
    private final String lastEditBy;
    private final String templateName;
    private final int numberOfSections;
    private final String status;
    private final JCRFile file;

    public JCRReport(JCRWorkspace workspace, Node node) throws RepositoryException, InternalErrorException {
        super(workspace, node);
        Node nodeContent = node.getNode("jcr:content");
        this.created = nodeContent.getProperty(CREATED).getDate();
        this.lastEdit = nodeContent.getProperty(LAST_EDIT).getDate();
        this.author = nodeContent.getProperty(AUTHOR).getString();
        this.lastEditBy = nodeContent.getProperty(LAST_EDIT_BY).getString();
        this.templateName = nodeContent.getProperty(TEMPLATE_NAME).getString();
        this.numberOfSections = (int)nodeContent.getProperty(NUMBER_OF_SECTION).getLong();
        this.status = nodeContent.getProperty(STATUS).getString();
        this.file = new JCRFile(nodeContent);
    }

    public JCRReport(JCRWorkspace workspace, Node node, String name, String description, Calendar created, Calendar lastEdit, String author, String lastEditBy, String templateName, int numberOfSections, String status, InputStream reportData) throws RepositoryException {
        super(workspace, node, name, description);
        Validate.notNull((Object)created, (String)"Created must be not null");
        Validate.notNull((Object)lastEdit, (String)"LastEdit must be not null");
        Validate.notNull((Object)author, (String)"Author must be not null");
        Validate.notNull((Object)lastEditBy, (String)"LastEditBy must be not null");
        Validate.notNull((Object)templateName, (String)"TemplateName must be not null");
        Validate.notNull((Object)status, (String)"Status must be not null");
        Validate.notNull((Object)reportData, (String)"ReportData must be not null");
        this.created = created;
        this.lastEdit = lastEdit;
        this.author = author;
        this.lastEditBy = lastEditBy;
        this.templateName = templateName;
        this.numberOfSections = numberOfSections;
        this.status = status;
        node.setProperty("hl:workspaceItemType", FolderItemType.REPORT.toString());
        Node contentNode = node.addNode("jcr:content", NT_CONTENT);
        this.file = new JCRFile(contentNode, new BufferedInputStream(reportData));
        contentNode.setProperty(TEMPLATE_NAME, templateName);
        contentNode.setProperty(AUTHOR, author);
        contentNode.setProperty(CREATED, created);
        contentNode.setProperty(LAST_EDIT, lastEdit);
        contentNode.setProperty(LAST_EDIT_BY, lastEditBy);
        contentNode.setProperty(NUMBER_OF_SECTION, (long)numberOfSections);
        contentNode.setProperty(STATUS, status);
    }

    @Override
    public long getLength() throws InternalErrorException {
        return this.file.getLength();
    }

    public InputStream getData() throws InternalErrorException {
        return this.file.getData();
    }

    public Calendar getCreated() {
        return this.created;
    }

    public Calendar getLastEdit() {
        return this.lastEdit;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getLastEditBy() {
        return this.lastEditBy;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public int getNumberOfSections() {
        return this.numberOfSections;
    }

    public String getStatus() {
        return this.status;
    }

    @Override
    public FolderItemType getFolderItemType() {
        return FolderItemType.REPORT;
    }

    @Override
    public void saveContent(Node node) throws RepositoryException {
        this.file.save(node);
    }
}

