/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.unittest.workspace.test;

import java.io.IOException;
import java.util.List;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemAlreadyExistException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.WorkspaceFolderNotFoundException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.WrongDestinationException;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.PDFDocument;
import org.gcube.portlets.user.homelibrary.testdata.TestDataFactory;
import org.gcube.portlets.user.homelibrary.unittest.workspace.AbstractWorkspaceTest;
import org.gcube.portlets.user.homelibrary.unittest.workspace.UnitTestUtil;
import org.gcube.portlets.user.homelibrary.unittest.workspace.WorkspaceFactory;
import org.junit.Assert;
import org.junit.Test;

public class WorkspaceTestCopyMethods
extends AbstractWorkspaceTest {
    public WorkspaceTestCopyMethods(WorkspaceFactory factory) {
        super(factory);
    }

    @Test(expected=ItemAlreadyExistException.class)
    public final void testCopyStringStringAlreadyExistNameArgument() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, ItemNotFoundException, WrongDestinationException, WorkspaceFolderNotFoundException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        WorkspaceFolder folder = root.createFolder("TestFolder", "A test Folder");
        this.ownerWorkspace.copy(folder.getId(), root.getId());
    }

    @Test
    public final void testCopyStringStringFolderItem() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, ItemNotFoundException, WrongDestinationException, WorkspaceFolderNotFoundException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        WorkspaceFolder destination = root.createFolder("TestFolder11", "My Test Folder");
        WorkspaceItem item = (WorkspaceItem)TestDataFactory.getInstance().fillPDFDocuments(root, 1).get(0);
        WorkspaceItem copy = this.ownerWorkspace.copy(item.getId(), destination.getId());
        Assert.assertEquals((String)"Wrong name", (Object)item.getName(), (Object)copy.getName());
        WorkspaceItem findCopy = this.ownerWorkspace.getItem(copy.getId());
        Assert.assertNotNull((String)"Find copy null", (Object)findCopy);
        UnitTestUtil.testCopy(item, copy, true);
        UnitTestUtil.testRelationship(copy, (WorkspaceItem)destination);
    }

    @Test(expected=WrongDestinationException.class)
    public final void testCopyStringStringFolderItemWrongDestinationIdArgumentTypeFolderItem() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, ItemNotFoundException, WrongDestinationException, WorkspaceFolderNotFoundException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        List<PDFDocument> documents = TestDataFactory.getInstance().fillPDFDocuments(root, 2);
        WorkspaceItem item = (WorkspaceItem)documents.get(0);
        WorkspaceItem itemFolder = (WorkspaceItem)documents.get(1);
        this.ownerWorkspace.copy(item.getId(), itemFolder.getId());
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCopyStringStringNullDestinationIdArgument() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, ItemNotFoundException, WrongDestinationException, WorkspaceFolderNotFoundException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        WorkspaceFolder folder = root.createFolder("TestFolder12", "A test Folder");
        this.ownerWorkspace.copy(folder.getId(), null);
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCopyStringStringNullItemId() throws ItemNotFoundException, WrongDestinationException, InternalErrorException, ItemAlreadyExistException, InsufficientPrivilegesException, WorkspaceFolderNotFoundException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        this.ownerWorkspace.copy(null, root.getId());
    }

    @Test(expected=ItemAlreadyExistException.class)
    public final void testCopyStringStringStringAlreadyExistNameArgument() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, ItemNotFoundException, WrongDestinationException, WorkspaceFolderNotFoundException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        String expectedName = "TestFolder13";
        WorkspaceFolder folder = root.createFolder("TestFolder13", "A test Folder");
        this.ownerWorkspace.copy(folder.getId(), expectedName, root.getId());
    }

    @Test
    public final void testCopyStringStringStringFolderItem() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, ItemNotFoundException, WrongDestinationException, WorkspaceFolderNotFoundException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        TestDataFactory.getInstance().fillPDFDocuments(root, 1);
        WorkspaceItem item = (WorkspaceItem)root.getChildren().get(0);
        String expectedName = "TestFolderItemClone";
        WorkspaceItem copy = this.ownerWorkspace.copy(item.getId(), expectedName, root.getId());
        Assert.assertEquals((String)"Wrong name", (Object)expectedName, (Object)copy.getName());
        WorkspaceItem findCopy = this.ownerWorkspace.getItem(copy.getId());
        Assert.assertNotNull((String)"Find copy null", (Object)findCopy);
        UnitTestUtil.testCopy(item, copy, false);
        UnitTestUtil.testRelationship(copy, (WorkspaceItem)root);
    }

    @Test(expected=WrongDestinationException.class)
    public final void testCopyStringStringStringFolderItemWrongDestinationIdArgumentTypeFolderItem() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, ItemNotFoundException, WrongDestinationException, WorkspaceFolderNotFoundException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        String expectedName = "TestFolderItemCopy";
        TestDataFactory.getInstance().fillPDFDocuments(root, 2);
        WorkspaceItem item = (WorkspaceItem)root.getChildren().get(0);
        WorkspaceItem itemFolder = (WorkspaceItem)root.getChildren().get(1);
        this.ownerWorkspace.copy(item.getId(), expectedName, itemFolder.getId());
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCopyStringStringStringIllegalCharInCopyNameArgument() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, ItemNotFoundException, WrongDestinationException, WorkspaceFolderNotFoundException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        String expectedName = "Copy" + this.ownerWorkspace.getPathSeparator() + "TestFolder";
        WorkspaceFolder folder = root.createFolder("TestFolder14", "A test Folder");
        this.ownerWorkspace.copy(folder.getId(), expectedName, root.getId());
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCopyStringStringStringNullCopyName() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, ItemNotFoundException, WrongDestinationException, WorkspaceFolderNotFoundException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        String expectedName = null;
        WorkspaceFolder folder = root.createFolder("TestFolder15", "A test Folder");
        this.ownerWorkspace.copy(folder.getId(), expectedName, root.getId());
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCopyStringStringStringNullDestinationIdArgument() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, ItemNotFoundException, WrongDestinationException, WorkspaceFolderNotFoundException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        String expectedName = "TestFolder";
        WorkspaceFolder folder = root.createFolder("TestFolder16", "A test Folder");
        this.ownerWorkspace.copy(folder.getId(), expectedName, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCopyStringStringStringNullItemId() throws ItemNotFoundException, WrongDestinationException, InternalErrorException, ItemAlreadyExistException, InsufficientPrivilegesException, WorkspaceFolderNotFoundException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        String expectedName = "TestFolderCopy";
        this.ownerWorkspace.copy(null, expectedName, root.getId());
    }

    @Test
    public final void testCopyStringStringStringFolder() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, ItemNotFoundException, WrongDestinationException, WorkspaceFolderNotFoundException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        WorkspaceFolder folder = root.createFolder("TestFolder17", "A test Folder");
        String expectedName = "TestFolderCopy";
        WorkspaceItem copy = this.ownerWorkspace.copy(folder.getId(), expectedName, root.getId());
        Assert.assertNotNull((String)"Copy null", (Object)copy);
        Assert.assertEquals((String)"Wrong name", (Object)expectedName, (Object)copy.getName());
        WorkspaceItem findCopy = this.ownerWorkspace.getItem(copy.getId());
        Assert.assertNotNull((Object)findCopy);
        UnitTestUtil.testCopy((WorkspaceItem)folder, copy, false);
        UnitTestUtil.testRelationship(copy, (WorkspaceItem)root);
    }

    @Test
    public final void testCopyStringStringStringFolderTree() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, ItemNotFoundException, WrongDestinationException, IOException, WorkspaceFolderNotFoundException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        WorkspaceFolder folder = UnitTestUtil.getFolderTree(root, "TestFolderTree2");
        String expectedName = "TestFolderCopy2";
        WorkspaceItem copy = this.ownerWorkspace.copy(folder.getId(), expectedName, root.getId());
        Assert.assertEquals((String)"Wrong name", (Object)expectedName, (Object)copy.getName());
        WorkspaceItem findClone = this.ownerWorkspace.getItem(copy.getId());
        Assert.assertNotNull((String)"Find copy null", (Object)findClone);
        UnitTestUtil.testTreeRelationship(copy, (WorkspaceItem)root);
        UnitTestUtil.testCopy((WorkspaceItem)folder, copy, false);
    }

    @Test(expected=WrongDestinationException.class)
    public final void testCopyStringStringStringFolderWrongDestinationIdArgumentTypeFolderItem() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, ItemNotFoundException, WrongDestinationException, WorkspaceFolderNotFoundException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        String expectedName = "TestFolder";
        WorkspaceFolder folder = root.createFolder("TestFolder18", "A test Folder");
        WorkspaceItem wrongDestination = (WorkspaceItem)TestDataFactory.getInstance().fillPDFDocuments(root, 1).get(0);
        this.ownerWorkspace.copy(folder.getId(), expectedName, wrongDestination.getId());
    }

    @Test(expected=WorkspaceFolderNotFoundException.class)
    public final void testCopyStringStringStringWrongDestinationIdArgument() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, ItemNotFoundException, WrongDestinationException, WorkspaceFolderNotFoundException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        String expectedName = "TestFolder";
        WorkspaceFolder folder = root.createFolder("TestFolder19", "A test Folder");
        this.ownerWorkspace.copy(folder.getId(), expectedName, "");
    }

    @Test(expected=ItemNotFoundException.class)
    public final void testCopyStringStringStringWrongItemId() throws ItemNotFoundException, WrongDestinationException, InternalErrorException, ItemAlreadyExistException, InsufficientPrivilegesException, WorkspaceFolderNotFoundException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        String expectedName = "TestFolderCopy";
        this.ownerWorkspace.copy("", expectedName, root.getId());
    }

    @Test
    public final void testCopyStringStringWorkspace() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, ItemNotFoundException, WrongDestinationException, WorkspaceFolderNotFoundException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        WorkspaceFolder destinationFolder = root.createFolder("TestDestinationFolder", "A test Folder");
        WorkspaceFolder folder = root.createFolder("TestFolder20", "A test Folder");
        WorkspaceItem copy = this.ownerWorkspace.copy(folder.getId(), destinationFolder.getId());
        Assert.assertNotNull((String)"Copy null", (Object)copy);
        Assert.assertEquals((String)"Wrong name", (Object)folder.getName(), (Object)copy.getName());
        WorkspaceItem findCopy = this.ownerWorkspace.getItem(copy.getId());
        Assert.assertNotNull((Object)findCopy);
        UnitTestUtil.testCopy((WorkspaceItem)folder, copy, true);
        UnitTestUtil.testRelationship(copy, (WorkspaceItem)destinationFolder);
    }

    @Test
    public final void testCopyStringStringFolderTree() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, ItemNotFoundException, WrongDestinationException, IOException, WorkspaceFolderNotFoundException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        WorkspaceFolder destinationFolder = root.createFolder("TestDestinationFolder1", "A test folder");
        WorkspaceFolder folder = UnitTestUtil.getFolderTree(root, "TestFolderTree3");
        WorkspaceItem copy = this.ownerWorkspace.copy(folder.getId(), destinationFolder.getId());
        Assert.assertEquals((String)"Wrong name", (Object)folder.getName(), (Object)copy.getName());
        WorkspaceItem findClone = this.ownerWorkspace.getItem(copy.getId());
        Assert.assertNotNull((String)"Find copy null", (Object)findClone);
        UnitTestUtil.testCopy((WorkspaceItem)folder, copy, true);
        UnitTestUtil.testTreeRelationship(copy, (WorkspaceItem)destinationFolder);
    }

    @Test(expected=WrongDestinationException.class)
    public final void testCopyStringStringFolderWrongDestinationIdArgumentTypeFolderItem() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, ItemNotFoundException, WrongDestinationException, WorkspaceFolderNotFoundException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        WorkspaceFolder folder = root.createFolder("TestFolder21", "A test Folder");
        WorkspaceItem item = (WorkspaceItem)TestDataFactory.getInstance().fillPDFDocuments(root, 1).get(0);
        this.ownerWorkspace.copy(folder.getId(), item.getId());
    }

    @Test(expected=WorkspaceFolderNotFoundException.class)
    public final void testCopyStringStringWrongDestinationIdArgument() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, ItemNotFoundException, WrongDestinationException, WorkspaceFolderNotFoundException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        WorkspaceFolder folder = root.createFolder("TestFolder22", "A test Folder");
        this.ownerWorkspace.copy(folder.getId(), "");
    }

    @Test(expected=ItemNotFoundException.class)
    public final void testCopyStringStringWrongItemId() throws ItemNotFoundException, WrongDestinationException, InternalErrorException, ItemAlreadyExistException, InsufficientPrivilegesException, WorkspaceFolderNotFoundException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        this.ownerWorkspace.copy("", root.getId());
    }
}

