package org.gcube.portlets.user.gisviewer.server;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;
import org.gcube.common.geoserverinterface.GeoCaller;
import org.gcube.common.geoserverinterface.GeoCaller.FILTER_TYPE;
import org.gcube.common.geoserverinterface.GeonetworkCommonResourceInterface.GeoserverMethodResearch;
import org.gcube.common.geoserverinterface.GeoserverCaller;
import org.gcube.common.geoserverinterface.bean.CoverageTypeRest;
import org.gcube.common.geoserverinterface.bean.CswLayersResult;
import org.gcube.common.geoserverinterface.bean.FeatureTypeRest;
import org.gcube.common.geoserverinterface.bean.GroupRest;
import org.gcube.common.geoserverinterface.bean.LayerCsw;
import org.gcube.common.geoserverinterface.bean.LayerRest;
import org.gcube.portlets.user.gisviewer.client.Constants;
import org.gcube.portlets.user.gisviewer.client.GisViewerService;
import org.gcube.portlets.user.gisviewer.client.commons.beans.DataResult;
import org.gcube.portlets.user.gisviewer.client.commons.beans.GisViewerBaseLayerInterface;
import org.gcube.portlets.user.gisviewer.client.commons.beans.LayerItem;
import org.gcube.portlets.user.gisviewer.client.commons.beans.LayerItemsResult;
import org.gcube.portlets.user.gisviewer.client.commons.beans.Property;
import org.gcube.portlets.user.gisviewer.client.commons.beans.TransectParameters;
import org.gcube.portlets.user.gisviewer.client.commons.beans.WfsTable;
import org.gcube.portlets.user.gisviewer.client.commons.beans.WmsRequest;
import org.gcube.portlets.user.gisviewer.client.commons.utils.URLMakers;
import org.gcube.portlets.user.gisviewer.server.datafeature.ClickDataParser;
import org.gcube.portlets.user.gisviewer.server.datafeature.FeatureParser;
import org.gcube.portlets.user.gisviewer.server.datafeature.FeatureTypeParser;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;

public abstract class GisViewerServiceImpl extends RemoteServiceServlet implements GisViewerService {

	private static final long serialVersionUID = -2481133840394575925L;
	
	private static Logger logger = Logger.getLogger(GisViewerServiceImpl.class);

	protected static final boolean BASE_LAYER = true;
	protected static final GeoserverMethodResearch researchMethod = GeoserverMethodResearch.MOSTUNLOAD;

//	protected GeoCaller geoCaller = null;
	private Map<String, GeoCaller> geoCallersMap = new HashMap<String, GeoCaller>();
	//private static Bounds defaultBounds = new Bounds(-180, -90, 180, 90);

	protected abstract GisViewerServiceParameters getParameters() throws Exception;
	
	protected abstract List<? extends GisViewerBaseLayerInterface> getBaseLayersToAddGisViewer()throws Exception;

	protected GeoCaller getGeoCaller() throws Exception {		
		GisViewerServiceParameters parameters = getParameters();
		String geoserverUrl = parameters.getGeoServerUrl();
		String geonetworkUrl = parameters.getGeoNetworkUrl();
		String gnUser = parameters.getGeoNetworkUser();
		String gnPwd = parameters.getGeoNetworkPwd();
		String gsUser = parameters.getGeoServerUser();
		String gsPwd = parameters.getGeoServerPwd();

		GeoCaller geoCaller = geoCallersMap.get(geonetworkUrl);
		
		if (geoCaller!=null) {
			System.out.println("-----------GEOCALLER FOUND IN MAP");
			return geoCaller;
		} else {		
			System.out.println("-----------GEOCALLER NOT FOUND IN MAP, ADDED...");
			try {
				geoCaller = new GeoCaller(geonetworkUrl, gnUser, gnPwd, geoserverUrl, gsUser, gsPwd, researchMethod);
				geoCallersMap.put(geonetworkUrl, geoCaller);
				return geoCaller;
			} catch (Exception e) {
				throw new Exception("Error initializing the GeoCaller", e);
			}
		}

	}


	public List<DataResult> getDataResult(List<String> urls) {
		List<DataResult> result = new ArrayList<DataResult>();

		for (String url : urls) {
			List<DataResult> oneGeoserverResult = ClickDataParser.getDataResult(url); // TODO adjust url adding wms
			result.addAll(oneGeoserverResult);
		}

		return result;
	}

	public LayerItemsResult getGroupsInfo(String groupName) {
		// search of geoserver that contains the group
		String gsUrl=null;
		try {
			GeoCaller geoCaller = getGeoCaller();
			gsUrl = geoCaller.getGeoServerForGroup(groupName);
			if (gsUrl==null)
				return null;

//			String gsGwcUrl = URLMakers.getGeoserverGwcUrl(gsUrl);
//			String gsWmsUrl = URLMakers.getGeoserverWmsUrl(gsUrl);

			//FIXME manage the exception
			GisViewerServiceParameters parameters = getParameters();
			String gsUser = parameters.getGeoServerUser();
			String gsPwd = parameters.getGeoServerPwd();

			// connecting to the geoserver found
			GeoserverCaller geoserverCaller = new GeoserverCaller(gsUrl, gsUser, gsPwd);

			GroupRest groupRest = geoserverCaller.getLayerGroup(groupName);

			return getLayersInfo(groupRest.getLayers());
			
		} catch (Exception e) {
			System.out.println("gisViewer EXCEPTION: Error in getGroupInfo. Message=\""+e.getMessage()+"\"");
			System.out.println("geoserver_url="+gsUrl);
			System.out.println("Stacktrace: "+e.getStackTrace());
			e.printStackTrace();
			return null;
		}
	}


	public LayerItemsResult getLayersInfo(List<String> layersName) {
		LayerItemsResult layerItemsResult = new LayerItemsResult();
		
		Map<String, GeoserverCaller> geoserverCallers = new HashMap<String, GeoserverCaller>(); 
		int countVisible=0, n=layersName.size();

		for (String layerName: layersName) {
			try {
				GeoCaller geoCaller = getGeoCaller();

				CswLayersResult cswLayerResult = geoCaller.getLayersFromCsw(null, 1, 10, false, true, FILTER_TYPE.ANY_TEXT, layerName);				
				if (cswLayerResult.getLayers().size()==0)
					layerItemsResult.addStatusMessage("- Layer \""+layerName+"\" not found.");
				else {
					LayerCsw layerCsw = null;
					for (LayerCsw l: cswLayerResult.getLayers()) {
						String[] split = l.getName().split(":");
						if (l.getName().contentEquals(layerName) || split.length>1 && layerName.contentEquals(split[1])) {
							layerCsw = l;						
							break;
						}
					}
					if (layerCsw==null)
						layerCsw = cswLayerResult.getLayers().get(0);
					String gsUrl = URLMakers.getGeoserverUrlFromWmsUrl(layerCsw.getGeoserverUrl());
//					String gsGwcUrl = URLMakers.getGeoserverGwcUrl(gsUrl);
					String gsWmsUrl = URLMakers.getGeoserverWmsUrl(gsUrl);

					GeoserverCaller geoserverCaller;
					if ((geoserverCaller = geoserverCallers.get(gsUrl))==null) {
						GisViewerServiceParameters parameters = getParameters();
						String gsUser = parameters.getGeoServerUser();
						String gsPwd = parameters.getGeoServerPwd();
						geoserverCaller = new GeoserverCaller(gsUrl, gsUser, gsPwd);
						geoserverCallers.put(gsUrl, geoserverCaller);
					}

					LayerItem layerItem = new LayerItem();
					layerItem.setName(layerName);
					layerItem.setTitle(layerCsw.getTitle());
					layerItem.setLayer(layerCsw.getName());
					layerItem.setVisible((countVisible++)>n-3);
					
//					layerItem.setUrl(gsGwcUrl);
					
					layerItem.setUrl(gsWmsUrl);
					
					layerItem.setGeoserverUrl(gsUrl);
					layerItem.setGeoserverWmsUrl(gsWmsUrl);

					LayerRest layerRest = geoserverCaller.getLayer(layerName);

					// set the dataStore
					layerItem.setDataStore(layerRest.getDatastore());

					layerItem.setDefaultStyle(layerRest.getDefaultStyle());
					layerItem.setStyle(layerRest.getDefaultStyle());

					layerItem.setBuffer(2);
					if (layerRest.getType().contentEquals("RASTER")) {

						CoverageTypeRest coverageTypeRest = geoserverCaller.getCoverageType(
								layerRest.getWorkspace(), 
								layerRest.getCoveragestore(), 
								layerName);

						layerItem.setMaxExtent(coverageTypeRest.getLatLonBoundingBox().getMinx(), 
								coverageTypeRest.getLatLonBoundingBox().getMiny(), 
								coverageTypeRest.getLatLonBoundingBox().getMaxx(),
								coverageTypeRest.getLatLonBoundingBox().getMaxy(),
								coverageTypeRest.getLatLonBoundingBox().getCrs());
						layerItem.setHasLegend(false);
						layerItem.setBaseLayer(BASE_LAYER);
						layerItem.setTrasparent(false);
						layerItem.setClickData(false);
					} else {
						FeatureTypeRest featureTypeRest = geoserverCaller.getFeatureType(layerRest.getWorkspace(), 
								layerRest.getDatastore(), 
								layerName);

						layerItem.setMaxExtent(featureTypeRest.getLatLonBoundingBox().getMinx(), 
								featureTypeRest.getLatLonBoundingBox().getMiny(), 
								featureTypeRest.getLatLonBoundingBox().getMaxx(),
								featureTypeRest.getLatLonBoundingBox().getMaxy(),
								featureTypeRest.getLatLonBoundingBox().getCrs());

						layerItem.setBaseLayer(false);
						layerItem.setClickData(true);
						layerItem.setStyles(layerRest.getStyles());
						layerItem.setHasLegend(true);

						layerItem.setTrasparent(true);
					}

					// set layer properties info
					List<Property> properties = FeatureTypeParser.getProperties(gsUrl, layerItem.getLayer());
					layerItem.setProperties(properties);

					// set opacity
					setDefaultOpacity(layerItem);

					layerItemsResult.addLayerItem(layerItem);
					
				}
			} catch (Exception e) {
				e.printStackTrace();
				layerItemsResult.addStatusMessage("- Layer \""+layerName+"\" not found.");
			}
		}
		
		boolean isBaseLayer = false;
		for (LayerItem l: layerItemsResult.getLayerItems()) {
			if (!isBaseLayer) isBaseLayer = l.isBaseLayer();
		}
		if (!isBaseLayer && layerItemsResult.getLayerItemsSize() > 0) {
			layerItemsResult.getLayerItems().get(0).setBaseLayer(BASE_LAYER);
		}

		return layerItemsResult;
	}
	
	/* (non-Javadoc)
	 * @see org.gcube.portlets.user.gisviewer.client.GisViewerService#getBaseLayersToGisViewer()
	 */
	@Override
	public List<? extends GisViewerBaseLayerInterface> getBaseLayersToGisViewer() {
		
		try {
			return getBaseLayersToAddGisViewer();
			
		} catch (Exception e) {
			e.printStackTrace();
			
			return new DefaultGisViewerServiceImpl().getBaseLayersToGisViewer();
		}
		
	}

	/* (non-Javadoc)
	 * @see org.gcube.portlets.user.gisviewer.client.GisViewerService#getLayersInfoByLayerItems(java.util.List)
	 */
	@Override
	public LayerItemsResult getLayersInfoByLayerItems(List<LayerItem> layerItems) {
		LayerItemsResult layerItemsResult = new LayerItemsResult();

		int countVisible=0;
		for (LayerItem layerItem: layerItems) {
			try {
				putLayerInfoInLayerItem(layerItem);
				layerItem.setVisible((countVisible++)<2);
				layerItemsResult.addLayerItem(layerItem);
				setDefaultOpacity(layerItem);				
			} catch (Exception e) {
				e.printStackTrace();
				layerItemsResult.addStatusMessage("- Layer \""+layerItem.getName()+"\" not found.");
			}
		}

		// set eventually base layer
		boolean isBaseLayer = false;
		for (LayerItem l: layerItemsResult.getLayerItems())
			if (!isBaseLayer) isBaseLayer = l.isBaseLayer();

		if (!isBaseLayer && layerItemsResult.getLayerItemsSize() > 0) {
			layerItemsResult.getLayerItems().get(0).setBaseLayer(BASE_LAYER);
		}

		return layerItemsResult;
	}


	/**
	 * @param layerItem
	 */
	private void putLayerInfoInLayerItem(LayerItem layerItem) throws Exception {
		String gsUrl = layerItem.getGeoserverUrl();
		String layerName = layerItem.getName();

		if (gsUrl==null)
			throw new Exception();
		
		GeoserverCaller geoserverCaller;
		GisViewerServiceParameters parameters = getParameters();
		String gsUser = parameters.getGeoServerUser();
		String gsPwd = parameters.getGeoServerPwd();

		geoserverCaller = new GeoserverCaller(gsUrl, gsUser, gsPwd);

//		String gsGwcUrl = URLMakers.getGeoserverGwcUrl(gsUrl);
		
		String gsWmsUrl = URLMakers.getGeoserverWmsUrl(gsUrl);
		
//		layerItem.setUrl(gsGwcUrl);
		
		layerItem.setUrl(gsWmsUrl);
		
		layerItem.setGeoserverWmsUrl(gsWmsUrl);

		LayerRest layerRest = geoserverCaller.getLayer(layerName);

		// set the dataStore
		layerItem.setDataStore(layerRest.getDatastore());

		layerItem.setDefaultStyle(layerRest.getDefaultStyle());
		layerItem.setStyle(layerRest.getDefaultStyle());

		layerItem.setBuffer(2);
//			layerItem.setLayer(ServerGeoExtCostants.workSpace+":" + layerName);
		if (layerRest.getType().contentEquals("RASTER")) {
			CoverageTypeRest coverageTypeRest = geoserverCaller.getCoverageType(
					layerRest.getWorkspace(), 
					layerRest.getCoveragestore(), 
					layerName);

			layerItem.setMaxExtent(coverageTypeRest.getLatLonBoundingBox().getMinx(), 
					coverageTypeRest.getLatLonBoundingBox().getMiny(), 
					coverageTypeRest.getLatLonBoundingBox().getMaxx(),
					coverageTypeRest.getLatLonBoundingBox().getMaxy(),
					coverageTypeRest.getLatLonBoundingBox().getCrs());
			layerItem.setHasLegend(false);
			layerItem.setBaseLayer(BASE_LAYER);
			layerItem.setTrasparent(false);
			layerItem.setClickData(false);
		} else {
			FeatureTypeRest featureTypeRest = geoserverCaller.getFeatureType(layerRest.getWorkspace(), 
					layerRest.getDatastore(), 
					layerName);

			layerItem.setMaxExtent(featureTypeRest.getLatLonBoundingBox().getMinx(), 
					featureTypeRest.getLatLonBoundingBox().getMiny(), 
					featureTypeRest.getLatLonBoundingBox().getMaxx(),
					featureTypeRest.getLatLonBoundingBox().getMaxy(),
					featureTypeRest.getLatLonBoundingBox().getCrs());

			layerItem.setBaseLayer(false);
			layerItem.setClickData(true);
			layerItem.setStyles(layerRest.getStyles());
			layerItem.setHasLegend(true);

			layerItem.setTrasparent(true);
		}
		
		// set layer properties info
		List<Property> properties = FeatureTypeParser.getProperties(gsUrl, layerItem.getLayer());
		layerItem.setProperties(properties);
	}

	/**
	 * @param layerName
	 * @param geoserverCallers 
	 * @return
	 */
	private LayerItem getLayerInfoByLayerName(String layerName, Map<String, GeoserverCaller> geoserverCallers) throws Exception {
		GeoCaller geoCaller = getGeoCaller();

		CswLayersResult cswLayerResult = geoCaller.getLayersFromCsw(null, 1, 1, false, true, FILTER_TYPE.ANY_TEXT, layerName);				
		if (cswLayerResult.getLayers().size()==0)
			throw new Exception("CswLayerResult is empty.");
		else {
			LayerCsw layerCsw = cswLayerResult.getLayers().get(0);
			String gsUrl = URLMakers.getGeoserverUrlFromWmsUrl(layerCsw.getGeoserverUrl());
//			String gsGwcUrl = URLMakers.getGeoserverGwcUrl(gsUrl);
			String gsWmsUrl = URLMakers.getGeoserverWmsUrl(gsUrl);

			GeoserverCaller geoserverCaller;
			if ((geoserverCaller = geoserverCallers.get(gsUrl))==null) {
				GisViewerServiceParameters parameters = getParameters();
				String gsUser = parameters.getGeoServerUser();
				String gsPwd = parameters.getGeoServerPwd();
				geoserverCaller = new GeoserverCaller(gsUrl, gsUser, gsPwd);
				geoserverCallers.put(gsUrl, geoserverCaller);
			}

			LayerItem layerItem = new LayerItem();
			layerItem.setName(layerName);
			layerItem.setTitle(layerCsw.getTitle());
			layerItem.setLayer(layerCsw.getName());
//			layerItem.setUrl(gsGwcUrl);
			layerItem.setUrl(gsWmsUrl);
			layerItem.setGeoserverUrl(gsUrl);
			layerItem.setGeoserverWmsUrl(gsWmsUrl);

			LayerRest layerRest = geoserverCaller.getLayer(layerName);

			// set the dataStore
			layerItem.setDataStore(layerRest.getDatastore());

			layerItem.setDefaultStyle(layerRest.getDefaultStyle());
			layerItem.setStyle(layerRest.getDefaultStyle());

			layerItem.setBuffer(2);
			if (layerRest.getType().contentEquals("RASTER")) {

				CoverageTypeRest coverageTypeRest = geoserverCaller.getCoverageType(
						layerRest.getWorkspace(), 
						layerRest.getCoveragestore(), 
						layerName);

				layerItem.setMaxExtent(coverageTypeRest.getLatLonBoundingBox().getMinx(), 
						coverageTypeRest.getLatLonBoundingBox().getMiny(), 
						coverageTypeRest.getLatLonBoundingBox().getMaxx(),
						coverageTypeRest.getLatLonBoundingBox().getMaxy(),
						coverageTypeRest.getLatLonBoundingBox().getCrs());
				layerItem.setHasLegend(false);
				layerItem.setBaseLayer(BASE_LAYER);
				layerItem.setTrasparent(false);
				layerItem.setClickData(false);
			} else {
				FeatureTypeRest featureTypeRest = geoserverCaller.getFeatureType(layerRest.getWorkspace(), 
						layerRest.getDatastore(), 
						layerName);

				layerItem.setMaxExtent(featureTypeRest.getLatLonBoundingBox().getMinx(), 
						featureTypeRest.getLatLonBoundingBox().getMiny(), 
						featureTypeRest.getLatLonBoundingBox().getMaxx(),
						featureTypeRest.getLatLonBoundingBox().getMaxy(),
						featureTypeRest.getLatLonBoundingBox().getCrs());

				layerItem.setBaseLayer(false);
				layerItem.setClickData(true);
				layerItem.setStyles(layerRest.getStyles());
				layerItem.setHasLegend(true);

				layerItem.setTrasparent(true);
			}

			// set layer properties info
			List<Property> properties = FeatureTypeParser.getProperties(gsUrl, layerItem.getLayer());
			layerItem.setProperties(properties);

			setDefaultOpacity(layerItem);

			return layerItem;
		}
	}

	/**
	 * @param layerItem
	 */
	private void setDefaultOpacity(LayerItem layerItem) {
		if (layerItem.getOpacity()<0) {
//			boolean isBrightLayer=false;
//			for (String s : Constants.brightLayers)
//				if (s.equals(layerItem.getName()))
//					isBrightLayer=true;
//			
//			layerItem.setOpacity(isBrightLayer ? 1 : Constants.defaultOpacityLayers);
			layerItem.setOpacity(Constants.defaultOpacityLayers);
		}
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public TransectParameters getTransectParameters() {
		try {
			GisViewerServiceParameters prm = getParameters();
			TransectParameters tp = new TransectParameters(prm.getTransectUrl(), prm.getScope());
			logger.info("getTransectParameters returning: "+tp);
			return tp;
		} catch (Exception e) {
			logger.error("Error on getting transect parameters",e);
			return null;
		}
	}

	@Override
	public List<WfsTable> getDataResult(List<LayerItem> layerItems, String bbox) {
		List<WfsTable> result = FeatureParser.getDataResults(layerItems, bbox, Constants.MAX_WFS_FEATURES);
		return result;
	}
	
	@Override
	public List<WfsTable> getDataResult(List<LayerItem> layerItems, String bbox, int maxWFSFeature) {
		List<WfsTable> result = FeatureParser.getDataResults(layerItems, bbox, maxWFSFeature);
		return result;
	}
	
	
	@Override
	public List<Property> getListProperty(String geoserverUrl, LayerItem layer){
		return FeatureTypeParser.getProperties(geoserverUrl, layer.getLayer());
	}
	
	/**
	 * 
	 * @param request
	 * @return a WMS request
	 * @throws Exception 
	 */
	@Override
	public String parseWmsRequest(WmsRequest request) throws Exception{
		try {
			return MapGeneratorUtils.createWmsRequest(request);
		} catch (Exception e) {
			logger.error("Error on creating wms request",e);
			throw new Exception("Sorry, an error occurred when creating wms request, try again later");
		}
	}


}
