package org.gcube.portlets.user.gisviewerapp.client;

import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.RootPanel;

/**
 * Entry point classes define <code>onModuleLoad()</code>.
 */
public class GisViewerApp implements EntryPoint {

  public static final String GISVIEWERAPPDIV = "gisviewerapplication";

  private ApplicationController appController;
  /**
   * This is the entry point method.
   */
  public void onModuleLoad() {
	  
	  appController = new ApplicationController();
	  appController.go(RootPanel.get(GISVIEWERAPPDIV));
	  
	  Window.addResizeHandler(new ResizeHandler() {
          @Override
          public void onResize(ResizeEvent event) {
                  System.out.println("onWindowResized width: "+event.getWidth()+" height: "+event.getHeight());
                  updateSize();
          }
		 });
		 
	 updateSize();
	 
	 appController.getGisViewerPanel().showIntro();
  }
  
  /**
	 * Update window size
	 */
  public void updateSize(){
  	
	    RootPanel workspace = RootPanel.get(GISVIEWERAPPDIV);
	     
	    int topBorder = workspace.getAbsoluteTop();
	     
	    int leftBorder = workspace.getAbsoluteLeft();
	    
	    int footer = 2; //footer is bottombar + sponsor
	     
	    int rootHeight = (Window.getClientHeight() - topBorder - 4 - footer);// - ((footer == null)?0:(footer.getOffsetHeight()-15));
	    
//	    if (rootHeight < 550)
//	    	rootHeight = 550;
	     
	    int rootWidth = Window.getClientWidth() - 2* leftBorder; //- rightScrollBar;
	    
	    System.out.println("New workspace dimension Height: "+rootHeight+" Width: "+rootWidth);
	    
		appController.getMainPanel().setHeight(rootHeight);
	    appController.getMainPanel().setWidth(rootWidth);
	    appController.moveWMSBalloon();
  }
}
