/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.gcubelogin.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.liferay.portal.kernel.bean.BeanLocatorException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.common.portal.PortalContext;
import org.gcube.portal.custom.communitymanager.PortletsIdManager;
import org.gcube.portal.custom.communitymanager.SiteManagerUtil;
import org.gcube.portal.custom.communitymanager.components.GCUBELayoutTab;
import org.gcube.portal.custom.communitymanager.components.GCUBEPortlet;
import org.gcube.portal.custom.communitymanager.components.GCUBESiteLayout;
import org.gcube.portal.custom.communitymanager.impl.GCubeSiteManagerImpl;
import org.gcube.portal.custom.communitymanager.types.GCUBELayoutType;
import org.gcube.portlets.user.gcubelogin.client.stubs.NewLoginService;
import org.gcube.portlets.user.gcubelogin.server.LoginServiceUtil;
import org.gcube.portlets.user.gcubelogin.shared.CheckResult;
import org.gcube.portlets.user.gcubelogin.shared.ResearchEnvironment;
import org.gcube.portlets.user.gcubelogin.shared.SelectedTheme;
import org.gcube.portlets.user.gcubelogin.shared.UserBelonging;
import org.gcube.portlets.user.gcubelogin.shared.VO;
import org.gcube.portlets.user.gcubelogin.shared.VRE;
import org.gcube.vomanagement.usermanagement.impl.LiferayGroupManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayRoleManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayUserManager;
import org.gcube.vomanagement.usermanagement.model.GCubeGroup;
import org.gcube.vomanagement.usermanagement.model.GCubeUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginServiceImpl
extends RemoteServiceServlet
implements NewLoginService {
    public static final String CACHED_VOS = "CACHED_VOS";
    public String SELECTED_THEMEID = "";
    private VO rootVO = new VO();
    private static final Logger _log = LoggerFactory.getLogger(LoginServiceImpl.class);

    private ASLSession getASLSession() {
        String sessionID = this.getThreadLocalRequest().getSession().getId();
        String user = (String)this.getThreadLocalRequest().getSession().getAttribute("username");
        if (user == null) {
            _log.warn("USER IS NULL setting test.user");
            user = "test.user";
        } else {
            _log.info("LIFERAY PORTAL DETECTED user=" + user);
        }
        return SessionManager.getInstance().getASLSession(sessionID, user);
    }

    private boolean isWithinPortal() {
        try {
            UserLocalServiceUtil.getService();
            return true;
        }
        catch (BeanLocatorException ex) {
            _log.trace("Development Mode ON");
            return false;
        }
    }

    public ArrayList<VO> getInfrastructureVOs() {
        ASLSession session = this.getASLSession();
        _log.trace("getInfrastructureVOs method called");
        if (!this.isWithinPortal()) {
            return null;
        }
        try {
            User currUser = SiteManagerUtil.validateUser((String)this.getASLSession().getUsername());
            LiferayGroupManager gm = new LiferayGroupManager();
            GCubeGroup rootGroupVO = gm.getRootVO();
            try {
                _log.info("root: " + rootGroupVO.getGroupName());
            }
            catch (NullPointerException e) {
                _log.error("Cannot find root organziation, please check gcube-data.properties file in $CATALINA_HOME/conf folder, unless your installing the Bundle");
                return new ArrayList<VO>();
            }
            ArrayList<VO> infrastructureVOs = new ArrayList<VO>();
            this.rootVO = new VO();
            this.rootVO.setName(rootGroupVO.getGroupName());
            this.rootVO.setGroupName(gm.getInfrastructureScope(rootGroupVO.getGroupId()));
            this.rootVO.setRoot(true);
            String friendlyURL = rootGroupVO.getFriendlyURL();
            this.rootVO.setFriendlyURL("/group" + friendlyURL);
            long logoId = rootGroupVO.getLogoId();
            String logoURL = "/image/layout_set_logo?img_id=" + rootGroupVO.getLogoId();
            this.rootVO.setImageURL(logoURL);
            if (rootGroupVO.getDescription() != null) {
                this.rootVO.setDescription(rootGroupVO.getDescription());
            }
            if (this.hasRole(this.getVoAdminRoleName(), rootGroupVO.getGroupName(), currUser)) {
                this.rootVO.setUserBelonging(UserBelonging.BELONGING);
            } else {
                this.rootVO.setUserBelonging(UserBelonging.NOT_BELONGING);
            }
            _log.debug("rootVO = " + rootGroupVO.getGroupName() + " children? = " + rootGroupVO.getChildren().size());
            LiferayUserManager um = new LiferayUserManager();
            for (GCubeGroup vOrg : rootGroupVO.getChildren()) {
                _log.debug("FOUND VO: " + vOrg.getGroupName());
                VO voToAdd = new VO();
                voToAdd.setName(vOrg.getName());
                voToAdd.setGroupName(gm.getInfrastructureScope(vOrg.getGroupId()));
                voToAdd.setRoot(false);
                logoURL = "/image/layout_set_logo?img_id=" + vOrg.getLogoId();
                voToAdd.setImageURL(logoURL);
                for (VRE vre : vOrg.getChildren()) {
                    VRE vreToAdd = new VRE();
                    vreToAdd.setName(vre.getName());
                    vreToAdd.setGroupName(gm.getInfrastructureScope(vre.getGroupId()));
                    logoId = vre.getLogoId();
                    logoURL = "/image/layout_set_logo?img_id=" + logoId;
                    _log.debug("VRE logoURL=" + logoURL);
                    vreToAdd.setImageURL(logoURL);
                    String vreUrl = vre.getFriendlyURL();
                    vreToAdd.setFriendlyURL("/group" + vreUrl);
                    if (vre.getDescription() != null) {
                        vreToAdd.setDescription(vre.getDescription());
                    }
                    vreToAdd.setUserBelonging(UserBelonging.NOT_BELONGING);
                    List users = um.listUsersByGroup(vre.getGroupId());
                    for (GCubeUser gCubeUser : users) {
                        if (currUser.getScreenName().compareTo(gCubeUser.getUsername()) != 0) continue;
                        vreToAdd.setUserBelonging(UserBelonging.BELONGING);
                        break;
                    }
                    voToAdd.addVRE(vreToAdd);
                }
                String url = vOrg.getFriendlyURL();
                voToAdd.setFriendlyURL("/group" + url);
                if (vOrg.getDescription() != null) {
                    voToAdd.setDescription(vOrg.getDescription());
                }
                voToAdd.setUserBelonging(UserBelonging.NOT_BELONGING);
                List users = um.listUsersByGroup(vOrg.getGroupId());
                for (GCubeUser gCubeUser : users) {
                    if (currUser.getScreenName().compareTo(gCubeUser.getUsername()) != 0) continue;
                    voToAdd.setUserBelonging(UserBelonging.BELONGING);
                    break;
                }
                infrastructureVOs.add(voToAdd);
            }
            ArrayList<VO> toReturn = new ArrayList<VO>();
            for (VO vo : infrastructureVOs) {
                for (VRE vre : vo.getVres()) {
                    _log.debug("VRE FOUND.... " + vre.getName());
                }
                toReturn.add(vo);
            }
            Collections.sort(toReturn, Collections.reverseOrder());
            toReturn.add(0, this.rootVO);
            ArrayList<VO> toStoreInSession = toReturn;
            _log.debug("SETTING INFRASTRUCTURE VOS in ASLSession");
            this.getASLSession().setAttribute(CACHED_VOS, toStoreInSession);
            return toReturn;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<VO>();
        }
    }

    public void addMembershipRequest(String scope, String optionalMessage) {
        String username = this.getASLSession().getUsername();
        String gatewayName = "D4Science Gateway";
        if (this.getASLSession().getAttribute("GATEWAY_NAME") != null) {
            gatewayName = this.getASLSession().getAttribute("GATEWAY_NAME").toString();
        }
        LoginServiceUtil.addMembershipRequest((String)username, (VO)this.rootVO, (String)scope, (String)optionalMessage, (String)this.getPortalBasicUrl(), (String)gatewayName);
    }

    private long createRootVO(String rootVoName, String themeid) throws PortalException, SystemException {
        String username = this.getASLSession().getUsername();
        GCUBESiteLayout siteLayout = GCubeSiteManagerImpl.getBaseLayout((String)rootVoName, (boolean)true, (String)username);
        GCUBELayoutTab accounting = new GCUBELayoutTab("Accounting", GCUBELayoutType.ONE_COL, new GCUBEPortlet("Navigation", PortletsIdManager.getLRPortletId((String)"LR_navigation")));
        GCUBELayoutTab portalAccounting = new GCUBELayoutTab("Portal Accounting", GCUBELayoutType.ONE_COL, new GCUBEPortlet("PortalAccounting", PortletsIdManager.getLRPortletId((String)"portalaccounting")));
        GCUBELayoutTab nodeAccounting = new GCUBELayoutTab("Node Accounting", GCUBELayoutType.ONE_COL, new GCUBEPortlet("PortalAccounting", PortletsIdManager.getLRPortletId((String)"nodeaccounting")));
        GCUBELayoutTab serviceAccounting = new GCUBELayoutTab("Service Accounting", GCUBELayoutType.ONE_COL, new GCUBEPortlet("PortalAccounting", PortletsIdManager.getLRPortletId((String)"nodeaccounting")));
        accounting.addSubTab(portalAccounting);
        accounting.addSubTab(nodeAccounting);
        accounting.addSubTab(serviceAccounting);
        siteLayout.addTab(accounting);
        siteLayout.addTab(new GCUBELayoutTab("Services Availability", GCUBELayoutType.ONE_COL, new GCUBEPortlet("Services", PortletsIdManager.getLRPortletId((String)"servicesaccounting"))));
        siteLayout.addTab(new GCUBELayoutTab("Monitoring", GCUBELayoutType.ONE_COL, new GCUBEPortlet("Monitoring", PortletsIdManager.getLRPortletId((String)"ecomonitoring"))));
        return GCubeSiteManagerImpl.createRootVO((String)username, (String)rootVoName, (String)"desc", (GCUBESiteLayout)siteLayout, (String)themeid);
    }

    private long createVO(String voName, long parentid, String themeid) throws PortalException, SystemException {
        String username = this.getASLSession().getUsername();
        GCUBESiteLayout siteLayout = GCubeSiteManagerImpl.getBaseLayout((String)voName, (boolean)true, (String)username);
        GCUBELayoutTab vreManagementTab = new GCUBELayoutTab("VRE Management", GCUBELayoutType.ONE_COL, new GCUBEPortlet("VRE Management", PortletsIdManager.getLRPortletId((String)"LR_navigation")));
        GCUBELayoutTab vreDefinitionTab = new GCUBELayoutTab("VRE Definition", GCUBELayoutType.ONE_COL, new GCUBEPortlet("VRE Definition", PortletsIdManager.getLRPortletId((String)"vredefinition")));
        GCUBELayoutTab vreDeploymentTab = new GCUBELayoutTab("VRE Deployment", GCUBELayoutType.ONE_COL, new GCUBEPortlet("VRE Deployment", PortletsIdManager.getLRPortletId((String)"vredeployment")));
        GCUBELayoutTab vreDeployerTab = new GCUBELayoutTab("VRE Deployer", GCUBELayoutType.ONE_COL, new GCUBEPortlet("VRE Deployer", PortletsIdManager.getLRPortletId((String)"vredeployer")));
        vreDeployerTab.setHidden(true);
        vreManagementTab.addSubTab(vreDefinitionTab);
        vreManagementTab.addSubTab(vreDeploymentTab);
        vreManagementTab.addSubTab(vreDeployerTab);
        siteLayout.addTab(vreManagementTab);
        return GCubeSiteManagerImpl.createVO((String)username, (String)voName, (String)"desc", (long)parentid, (GCUBESiteLayout)siteLayout, (String)themeid);
    }

    private long createVRE(String vreName, String desc, long parentid, String themeid) throws PortalException, SystemException {
        String username = this.getASLSession().getUsername();
        GCUBESiteLayout siteLayout = GCubeSiteManagerImpl.getBaseLayout((String)vreName, (boolean)false, (String)username);
        return GCubeSiteManagerImpl.createVRE((String)username, (String)vreName, (String)desc, (long)parentid, (GCUBESiteLayout)siteLayout, (String)themeid);
    }

    public String[] getInfrastructureConfig() {
        String[] toReturn = new String[]{PortalContext.getConfiguration().getInfrastructureName(), PortalContext.getConfiguration().getVOsAsString()};
        return toReturn;
    }

    private String getPortalBasicUrl() {
        HttpServletRequest request = this.getThreadLocalRequest();
        String toReturn = "";
        String protocol = request.isSecure() ? "https://" : "http://";
        toReturn = toReturn + protocol;
        toReturn = toReturn + request.getServerName();
        toReturn = toReturn + (request.getServerPort() == 80 ? "" : ":" + request.getServerPort());
        _log.trace("getPortalBasicUrl: " + toReturn + "queryString: " + request.getQueryString());
        return toReturn;
    }

    public VO getRootVO() {
        _log.debug("root called");
        this.getASLSession().invalidate();
        if (this.rootVO != null) {
            return this.rootVO;
        }
        Organization rootOrganization = null;
        List organizations = null;
        try {
            organizations = OrganizationLocalServiceUtil.getOrganizations((int)0, (int)OrganizationLocalServiceUtil.getOrganizationsCount());
        }
        catch (SystemException e) {
            e.printStackTrace();
        }
        for (Organization organization : organizations) {
            if (!organization.getName().equals(LoginServiceUtil.getRootOrganizationName())) continue;
            rootOrganization = organization;
            break;
        }
        this.rootVO.setName(rootOrganization.getName());
        this.rootVO.setGroupName("/" + rootOrganization.getName());
        this.rootVO.setRoot(true);
        ThemeDisplay themeDisplay = (ThemeDisplay)this.getThreadLocalRequest().getSession().getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Group orgGroup = rootOrganization.getGroup();
        String friendlyURL = orgGroup.getPathFriendlyURL(true, themeDisplay) + orgGroup.getFriendlyURL();
        this.rootVO.setFriendlyURL(this.getPortalBasicUrl() + friendlyURL);
        return this.rootVO;
    }

    public ResearchEnvironment getSelectedRE() {
        _log.debug("getting Selected Research Environment");
        HttpSession session = this.getThreadLocalRequest().getSession();
        String selectedGroupName = this.getASLSession().getScopeName();
        ArrayList vos = (ArrayList)session.getAttribute(CACHED_VOS);
        for (VO vo : vos) {
            if (vo.getGroupName().equals(selectedGroupName)) {
                return vo;
            }
            ArrayList vres = vo.getVres();
            for (VRE vre : vres) {
                if (!vre.getGroupName().equals(selectedGroupName)) continue;
                this.setVREBelonginApplication(vre);
                return new ResearchEnvironment(vre.getName(), vre.getDescription(), vre.getImageURL(), vre.getGroupName(), vre.getFriendlyURL(), vre.getUserBelonging());
            }
        }
        return null;
    }

    private String getVoAdminRoleName() {
        Properties props = new Properties();
        String toReturn = "";
        try {
            String propertyfile = SiteManagerUtil.getTomcatFolder() + "conf" + File.separator + "gcube-data.properties";
            File propsFile = new File(propertyfile);
            FileInputStream fis = new FileInputStream(propsFile);
            props.load(fis);
            toReturn = props.getProperty("voadminRole");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    private boolean hasRole(String rolename, String organizationName, User user) throws SystemException {
        for (Role role : user.getRoles()) {
            if (role.getName().compareTo(rolename + "-" + organizationName) != 0) continue;
            return true;
        }
        return false;
    }

    public Boolean installPortalEnv(String infrastructure, String startScopes, SelectedTheme theme, boolean automaticRedirect) {
        String rootVoName;
        block7: {
            String[] sites;
            rootVoName = infrastructure.replaceAll(" ", "");
            if (startScopes.contains(",")) {
                sites = startScopes.split(",");
                for (int i = 0; i < sites.length; ++i) {
                    sites[i] = sites[i].replaceAll(" ", "");
                }
            } else {
                sites = new String[]{startScopes.replaceAll(" ", "")};
            }
            _log.info("Starting create Root VO for infrastructure " + this.rootVO.toString());
            try {
                _log.info("Creating Site Roles for infrastructure " + this.rootVO.toString());
                LiferayRoleManager rm = new LiferayRoleManager();
                rm.createRole("Data-Manager", "Data Manager");
                rm.createRole("Infrastructure-Manager", "Infrastructure Manager");
                rm.createRole("VRE-Designer", "Virtual Organization Administrator");
                rm.createRole("VRE-Designer", "The Virtual Research Environment Designer");
                rm.createRole("VRE-Manager", "The Virtual Research Environment Manager");
                if (LoginServiceUtil.setupGuestSite((SelectedTheme)theme)) {
                    String themid = "";
                    this.SELECTED_THEMEID = themid = SiteManagerUtil.getgCubeThemeId((String)"gcubeportaltheme");
                    long parentid = this.createRootVO(rootVoName, themid);
                    _log.info("Root VO for infrastructure " + rootVoName + " Created with Success id: " + parentid + " themid:" + this.SELECTED_THEMEID);
                    for (int i = 0; i < sites.length; ++i) {
                        this.createVO(sites[i], parentid, themid);
                    }
                    break block7;
                }
                return false;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        LoginServiceUtil.appendRootOrganizationName((String)rootVoName);
        LoginServiceUtil.addPropertyDefaultLandingPageAndTheme((boolean)automaticRedirect, (SelectedTheme)theme);
        return true;
    }

    public Boolean isLayoutLoaded() {
        this.getASLSession();
        return new Boolean(false);
    }

    public void loadLayout(String scope, String URL2) {
        _log.trace("Calling Load Layout...");
        HttpSession session = this.getThreadLocalRequest().getSession();
        ASLSession mysession = SessionManager.getInstance().getASLSession(session.getId(), session.getAttribute("username").toString());
        mysession.setAttribute("loadlayout", (Object)"true");
        session.setAttribute("loadLayout", (Object)"true");
        session.setAttribute("selectedVRE", (Object)scope);
        mysession.logUserLogin(scope);
        mysession.setScope(scope);
        _log.trace("User login logged to: " + scope);
    }

    private void setVREBelonginApplication(VRE vre) {
        _log.info("AvailablePortlets stored in session");
        ArrayList<String> toSet = new ArrayList<String>();
        toSet.add("AnnotationFrontEnd_V2");
        this.getASLSession().setAttribute("availablePortlets", toSet);
    }

    public HashMap<String, ArrayList<CheckResult>> checkInfrastructure(String infrastructure, String startScopes) {
        HashMap<String, ArrayList<CheckResult>> toReturn = new HashMap<String, ArrayList<CheckResult>>();
        toReturn.put(infrastructure, LoginServiceUtil.checkScope((String)infrastructure));
        if (startScopes.contains(",")) {
            String[] organizations = startScopes.split(",");
            for (int i = 0; i < organizations.length; ++i) {
                toReturn.put(organizations[i], LoginServiceUtil.checkScope((String)(infrastructure + "/" + organizations[i])));
            }
        } else {
            String[] organizations = new String[]{startScopes};
            toReturn.put(organizations[0], LoginServiceUtil.checkScope((String)(infrastructure + "/" + organizations[0])));
        }
        _log.debug("Infra check result: " + toReturn);
        return toReturn;
    }

    public Boolean checkVresPresence(String infrastructure, String startScopes) {
        if (startScopes.contains(",")) {
            String[] organizations = startScopes.split(",");
            for (int i = 0; i < organizations.length; ++i) {
                if (!LoginServiceUtil.checkVresPresence((String)(infrastructure + "/" + organizations[i])).booleanValue()) continue;
                return true;
            }
            return false;
        }
        String[] organizations = new String[]{startScopes};
        return LoginServiceUtil.checkVresPresence((String)(infrastructure + "/" + organizations[0]));
    }

    public ArrayList<VO> getVresFromInfrastructure(String infrastructure, String startScopes) {
        ArrayList<VO> toReturn = new ArrayList<VO>();
        if (startScopes.contains(",")) {
            String[] organizations = startScopes.split(",");
            for (int i = 0; i < organizations.length; ++i) {
                VO toAdd = new VO();
                toAdd.setName(organizations[i]);
                toAdd.setVres(LoginServiceUtil.getVREsFromInfrastructure((String)(infrastructure + "/" + organizations[i])));
                toReturn.add(toAdd);
            }
        } else {
            String[] organizations = new String[]{startScopes};
            VO toAdd = new VO();
            toAdd.setName(organizations[0]);
            toAdd.setVres(LoginServiceUtil.getVREsFromInfrastructure((String)(infrastructure + "/" + organizations[0])));
            toReturn.add(toAdd);
        }
        return toReturn;
    }

    public Boolean installVREs(ArrayList<VO> parents) {
        LiferayGroupManager gm = new LiferayGroupManager();
        for (VO vo : parents) {
            if (vo.getVres().size() <= 0) continue;
            long parentGroupId = -1L;
            try {
                parentGroupId = gm.getGroupId(vo.getName());
                for (VRE vre : vo.getVres()) {
                    if (vre.getUserBelonging() == null) continue;
                    this.createVRE(vre.getName(), vre.getDescription(), parentGroupId, this.SELECTED_THEMEID);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }
}

