/**
 * 
 */
package org.gcube.portlets.user.gcubegisviewer.client;

import java.util.List;
import java.util.Map;

import org.gcube.portlets.user.gisviewer.client.commons.beans.DataResult;
import org.gcube.portlets.user.gisviewer.client.commons.beans.GisViewerBaseLayerInterface;
import org.gcube.portlets.user.gisviewer.client.commons.beans.LayerItem;
import org.gcube.portlets.user.gisviewer.client.commons.beans.LayerItemsResult;
import org.gcube.portlets.user.gisviewer.client.commons.beans.Property;
import org.gcube.portlets.user.gisviewer.client.commons.beans.TransectParameters;
import org.gcube.portlets.user.gisviewer.client.commons.beans.WfsTable;
import org.gcube.portlets.user.gisviewer.client.commons.beans.WmsRequest;

import com.google.gwt.user.client.rpc.AsyncCallback;

/**
 * @author "Federico De Faveri defaveri@isti.cnr.it"
 *
 */
public interface GCubeGisViewerServiceAsync {

	/**
	 * 
	 * @see org.gcube.portlets.user.gisviewer.client.GisViewerService#getDataResult(java.util.List)
	 */
	void getDataResult(List<String> urls, AsyncCallback<List<DataResult>> callback);

	/**
	 * 
	 * @see org.gcube.portlets.user.gisviewer.client.GisViewerService#getGroupsInfo(java.lang.String)
	 */
	void getGroupsInfo(String groupName, AsyncCallback<LayerItemsResult> callback);

	
	void getTransectParameters(AsyncCallback<TransectParameters> callback);
	/**
	 * 
	 * @see org.gcube.portlets.user.gisviewer.client.GisViewerService#getLayersInfo(java.util.List)
	 */
	void getLayersInfo(List<String> layersName, AsyncCallback<LayerItemsResult> callback);

	public void getLayersInfoByLayerItems(List<LayerItem> layerItems, AsyncCallback<LayerItemsResult> asyncCallback);

//	public void getLayersInfoByLayerConfigurations(List<LayerConfiguration> layerConfigurations, AsyncCallback<LayerItemsResult> asyncCallback);

	public void getDataResult(List<LayerItem> layerItems, String bbox, AsyncCallback<List<WfsTable>> asyncCallback);

	void saveLayerItem(String name, String mimeType, String url, String destinationFolderId, AsyncCallback<Void> callback);

	void saveMapImageItem(String name, String mimeType, String bbox,
			String width, String height, String[] geoservers, String[] layers,
			String[] styles, String[] opacities, String[] cqlfilters,
			String[] gsrefs, String destinationFolderId, AsyncCallback<Void> callback);
	
	void getListProperty(String geoserverUrl, LayerItem layer,
			AsyncCallback<List<Property>> callback);
	
	void getDataResult(List<LayerItem> layerItems, String bbox,
			int maxWFSFeature, AsyncCallback<List<WfsTable>> callback);
	
	void getBaseLayersToGisViewer(AsyncCallback<List<? extends GisViewerBaseLayerInterface>> callback);
	
	void parseWmsRequest(WmsRequest request, AsyncCallback<String> callback);

	/**
	 * @param name
	 * @param outputFormat
	 * @param parameters
	 * @param id
	 * @param asyncCallback
	 */
	void saveMapImageItem(String name, String outputFormat,
			Map<String, String> parameters, String id,
			AsyncCallback<Void> asyncCallback);
}
