/**
 * 
 */
package org.gcube.portlets.user.gcubegisviewer.client;

import java.util.List;

import org.gcube.portlets.user.gcubegisviewer.client.event.HasSaveHandlers;
import org.gcube.portlets.user.gcubegisviewer.client.event.SaveEvent;
import org.gcube.portlets.user.gcubegisviewer.client.event.SaveHandler;
import org.gcube.portlets.user.gisviewer.client.GisViewer;
import org.gcube.portlets.user.gisviewer.client.GisViewerParameters;
import org.gcube.portlets.user.gisviewer.client.GisViewerSaveHandler;
import com.google.gwt.event.shared.HandlerRegistration;

/**
 * @author "Federico De Faveri defaveri@isti.cnr.it"
 *
 */
public class GCubeGisViewer extends GisViewer implements HasSaveHandlers {

	/**
	 * @param parameters
	 */
	public GCubeGisViewer(GisViewerParameters parameters) {
		this(parameters.getProjection(), parameters.getOpeningGroup(), parameters.getOpeningLayers(), (parameters.getGisViewerSaveHandler()==null)?new GCubeGisViewerSaveHandler():parameters.getGisViewerSaveHandler());
	}
	
	protected GCubeGisViewer(String projection, String groupName, List<String> layers, GisViewerSaveHandler gisViewerSaveHandler)
	{
		super(new GisViewerParameters(projection, groupName, layers, gisViewerSaveHandler));
		if (gisViewerSaveHandler instanceof GCubeGisViewerSaveHandler) {
			((GCubeGisViewerSaveHandler)gisViewerSaveHandler).setHasSaveHandlers(this);
		}
	}

	@Override
	public HandlerRegistration addSaveHandler(SaveHandler handler) {
		return addHandler(handler, SaveEvent.getType());
	}
	
	public void setMaskOnSaveEvents()
	{
		addSaveHandler(new SaveHandler() {
			
			@Override
			public void onSaveSuccess(SaveEvent event) {
				unmask();				
			}
			
			@Override
			public void onSaveFailure(SaveEvent event) {
				unmask();
				com.google.gwt.user.client.Window.alert("An error occured saving "+event.getName()+" in the workspace...");				
			}
			
			@Override
			public void onSave(SaveEvent event) {
				mask("Saving "+event.getName()+" in the workspace...");
			}
		});
	}

}
