/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.dataminermanager.client;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.resources.client.ResourceCallback;
import com.google.gwt.resources.client.ResourceException;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import org.gcube.portlets.user.dataminermanager.client.DataMinerManager;
import org.gcube.portlets.user.dataminermanager.client.common.EventBusProvider;
import org.gcube.portlets.user.dataminermanager.client.events.MenuSwitchEvent;
import org.gcube.portlets.user.dataminermanager.client.type.MenuType;
import org.gcube.portlets.user.dataminermanager.client.util.UtilsGXT3;

public class Header
extends HorizontalPanel {
    private Image menuGoBack;
    private Image menuExperiment;
    private Image menuDataSpace;
    private Image menuComputations;
    private Image menuHelp;
    private Enum<MenuType> currentSelection;

    public Header() {
        this.create();
        this.bind();
    }

    private void bind() {
        EventBusProvider.INSTANCE.addHandler(MenuSwitchEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void create() {
        Image logo = new Image(DataMinerManager.resources.logoLittle());
        logo.setAltText("Data Miner Manager");
        logo.setTitle("Data Miner Manager");
        logo.addStyleName("menuImgLogo");
        this.menuGoBack = new Image(DataMinerManager.resources.goBack());
        this.menuGoBack.addStyleName("menuItemImage");
        this.menuGoBack.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.menuDataSpace = new Image(DataMinerManager.resources.menuItemInputspace());
        this.menuDataSpace.addStyleName("menuItemImage");
        this.menuDataSpace.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.menuExperiment = new Image(DataMinerManager.resources.menuItemExperiment());
        this.menuExperiment.addStyleName("menuItemImage");
        this.menuExperiment.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.menuComputations = new Image(DataMinerManager.resources.menuItemComputations());
        this.menuComputations.addStyleName("menuItemImage");
        this.menuComputations.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.menuHelp = new Image(DataMinerManager.resources.menuItemHelp());
        this.menuHelp.addStyleName("menuItemImage");
        this.menuHelp.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.add((Widget)logo);
        this.add((Widget)this.menuGoBack);
        this.add((Widget)this.menuDataSpace);
        this.add((Widget)this.menuExperiment);
        this.add((Widget)this.menuComputations);
        this.add((Widget)this.menuHelp);
        this.setCellWidth((Widget)logo, "100px");
        this.setCellWidth((Widget)this.menuGoBack, "100px");
        this.setCellWidth((Widget)this.menuDataSpace, "80px");
        this.setCellWidth((Widget)this.menuExperiment, "80px");
        this.setCellWidth((Widget)this.menuComputations, "80px");
        this.setCellWidth((Widget)this.menuHelp, "80px");
        this.menuGoBack.setVisible(false);
        this.menuDataSpace.setVisible(false);
        this.menuExperiment.setVisible(false);
        this.menuComputations.setVisible(false);
        this.menuHelp.setVisible(false);
    }

    public void setMenu(MenuType menuType) {
        Log.debug((String)("SetMenu: " + menuType));
        if (menuType.compareTo((Enum)MenuType.HOME) == 0) {
            this.menuGoBack.setVisible(false);
            this.menuDataSpace.setVisible(false);
            this.menuExperiment.setVisible(false);
            this.menuComputations.setVisible(false);
            this.menuHelp.setVisible(false);
            if (this.currentSelection != null && this.currentSelection.compareTo(MenuType.EXPERIMENT) == 0) {
                this.menuExperiment.removeStyleName("menuItemImage-selected");
            } else if (this.currentSelection != null && this.currentSelection.compareTo(MenuType.DATA_SPACE) == 0) {
                this.menuDataSpace.removeStyleName("menuItemImage-selected");
            } else if (this.currentSelection != null && this.currentSelection.compareTo(MenuType.COMPUTATIONS) == 0) {
                this.menuComputations.removeStyleName("menuItemImage-selected");
            }
        } else {
            if (this.currentSelection == null || this.currentSelection != null && this.currentSelection.compareTo(MenuType.HOME) == 0) {
                this.menuGoBack.setVisible(true);
                this.menuDataSpace.setVisible(true);
                this.menuExperiment.setVisible(true);
                this.menuComputations.setVisible(true);
                this.menuHelp.setVisible(true);
            }
            if (this.currentSelection != null && this.currentSelection.compareTo(MenuType.EXPERIMENT) == 0) {
                this.menuExperiment.removeStyleName("menuItemImage-selected");
            } else if (this.currentSelection != null && this.currentSelection.compareTo(MenuType.DATA_SPACE) == 0) {
                this.menuDataSpace.removeStyleName("menuItemImage-selected");
            } else if (this.currentSelection != null && this.currentSelection.compareTo(MenuType.COMPUTATIONS) == 0) {
                this.menuComputations.removeStyleName("menuItemImage-selected");
            }
            Image imgNew = menuType.compareTo((Enum)MenuType.DATA_SPACE) == 0 ? this.menuDataSpace : (menuType.compareTo((Enum)MenuType.EXPERIMENT) == 0 ? this.menuExperiment : this.menuComputations);
            imgNew.addStyleName("menuItemImage-selected");
        }
        this.currentSelection = menuType;
    }

    private void menuSwitch(MenuSwitchEvent event) {
        Log.debug((String)("MenuSwitch: " + event));
        if (event.getMenuType().compareTo((Enum)MenuType.HOME) == 0) {
            this.menuGoBack.setVisible(false);
            this.menuDataSpace.setVisible(false);
            this.menuExperiment.setVisible(false);
            this.menuComputations.setVisible(false);
            this.menuHelp.setVisible(false);
            if (this.currentSelection != null && this.currentSelection.compareTo(MenuType.EXPERIMENT) == 0) {
                this.menuExperiment.removeStyleName("menuItemImage-selected");
            } else if (this.currentSelection != null && this.currentSelection.compareTo(MenuType.DATA_SPACE) == 0) {
                this.menuDataSpace.removeStyleName("menuItemImage-selected");
            } else if (this.currentSelection != null && this.currentSelection.compareTo(MenuType.COMPUTATIONS) == 0) {
                this.menuComputations.removeStyleName("menuItemImage-selected");
            }
        } else {
            if (this.currentSelection == null || this.currentSelection != null && this.currentSelection.compareTo(MenuType.HOME) == 0) {
                this.menuGoBack.setVisible(true);
                this.menuDataSpace.setVisible(true);
                this.menuExperiment.setVisible(true);
                this.menuComputations.setVisible(true);
                this.menuHelp.setVisible(true);
            }
            if (this.currentSelection != null && this.currentSelection.compareTo(MenuType.EXPERIMENT) == 0) {
                this.menuExperiment.removeStyleName("menuItemImage-selected");
            } else if (this.currentSelection != null && this.currentSelection.compareTo(MenuType.DATA_SPACE) == 0) {
                this.menuDataSpace.removeStyleName("menuItemImage-selected");
            } else if (this.currentSelection != null && this.currentSelection.compareTo(MenuType.COMPUTATIONS) == 0) {
                this.menuComputations.removeStyleName("menuItemImage-selected");
            }
            Image imgNew = event.getMenuType().compareTo((Enum)MenuType.DATA_SPACE) == 0 ? this.menuDataSpace : (event.getMenuType().compareTo((Enum)MenuType.EXPERIMENT) == 0 ? this.menuExperiment : this.menuComputations);
            imgNew.addStyleName("menuItemImage-selected");
        }
        this.currentSelection = event.getMenuType();
    }

    private void showHelp() {
        try {
            DataMinerManager.resources.wikiLink().getText((ResourceCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (ResourceException e) {
            Log.error((String)("Error retrieving wiki link!: " + e.getLocalizedMessage()));
            UtilsGXT3.alert((String)"Error", (String)"Error retrieving wiki link!");
            e.printStackTrace();
        }
    }

    static /* synthetic */ void access$000(Header x0, MenuSwitchEvent x1) {
        x0.menuSwitch(x1);
    }

    static /* synthetic */ void access$100(Header x0) {
        x0.showHelp();
    }
}

