/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.dataminermanager.client.parametersfield;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import com.sencha.gxt.core.client.dom.XDOM;
import com.sencha.gxt.core.client.util.Format;
import com.sencha.gxt.core.client.util.Margins;
import com.sencha.gxt.widget.core.client.button.TextButton;
import com.sencha.gxt.widget.core.client.container.BoxLayoutContainer;
import com.sencha.gxt.widget.core.client.container.HBoxLayoutContainer;
import com.sencha.gxt.widget.core.client.container.HtmlLayoutContainer;
import com.sencha.gxt.widget.core.client.container.MarginData;
import com.sencha.gxt.widget.core.client.container.SimpleContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import com.sencha.gxt.widget.core.client.event.SelectEvent;
import com.sencha.gxt.widget.core.client.form.TextField;
import java.util.ArrayList;
import org.gcube.data.analysis.dataminermanagercl.shared.data.TableItemSimple;
import org.gcube.data.analysis.dataminermanagercl.shared.parameters.Parameter;
import org.gcube.data.analysis.dataminermanagercl.shared.parameters.TabularParameter;
import org.gcube.data.analysis.dataminermanagercl.shared.workspace.ItemDescription;
import org.gcube.portlets.user.dataminermanager.client.DataMinerManager;
import org.gcube.portlets.user.dataminermanager.client.events.TabularFldChangeEvent;
import org.gcube.portlets.user.dataminermanager.client.parametersfield.AbstractFld;
import org.gcube.portlets.user.dataminermanager.client.parametersfield.TabularFld;
import org.gcube.portlets.user.dataminermanager.client.rpc.DataMinerPortletServiceAsync;
import org.gcube.portlets.user.dataminermanager.client.util.UtilsGXT3;
import org.gcube.portlets.user.dataminermanager.client.workspace.DownloadWidget;
import org.gcube.portlets.widgets.wsexplorer.client.notification.WorkspaceExplorerSelectNotification;
import org.gcube.portlets.widgets.wsexplorer.client.select.WorkspaceExplorerSelectDialog;
import org.gcube.portlets.widgets.wsexplorer.shared.Item;

public class TabularFld
extends AbstractFld
implements TabularFldChangeEvent.HasTabularFldChangeEventHandler {
    private SimpleContainer fieldContainer;
    private HBoxLayoutContainer horiz;
    private VerticalLayoutContainer vp;
    private WorkspaceExplorerSelectDialog wselectDialog;
    private TextButton selectButton;
    private TextButton selectButton2;
    private TextButton cancelButton;
    private TextButton downloadButton;
    private HtmlLayoutContainer templatesList;
    private TableItemSimple selectedTableItem = null;
    private ItemDescription itemDescriptionSelected;
    private TabularParameter tabularParameter;

    public TabularFld(Parameter parameter) {
        super(parameter);
        Log.debug((String)"TabularField");
        try {
            this.tabularParameter = (TabularParameter)parameter;
            SimpleContainer tabContainer = new SimpleContainer();
            this.vp = new VerticalLayoutContainer();
            this.init();
            this.createField(tabContainer);
            this.showNoSelectionField();
        }
        catch (Throwable e) {
            Log.error((String)("TabularField: " + e.getLocalizedMessage()));
            UtilsGXT3.alert((String)"Error", (String)("Error creating Tabular Field: " + e.getLocalizedMessage()));
            e.printStackTrace();
        }
    }

    private void createField(SimpleContainer tabContainer) {
        HtmlLayoutContainer descr;
        ArrayList templates = this.tabularParameter.getTemplates();
        if (templates == null || templates.isEmpty()) {
            this.templatesList = new HtmlLayoutContainer("<p></p>");
            this.templatesList.addStyleName("workflow-parameters-description");
        } else {
            String list = "";
            boolean first = true;
            for (String template : templates) {
                list = list + (first ? "" : ", ") + Format.ellipse((String)template, (int)50);
                first = false;
            }
            this.templatesList = new HtmlLayoutContainer("<p>Suitable Data Set Templates: <br>" + list + "</p>");
            this.templatesList.addStyleName("workflow-parameters-description");
        }
        tabContainer.add((Widget)this.vp, new MarginData(new Margins(0)));
        this.fieldContainer = new SimpleContainer();
        this.horiz = new HBoxLayoutContainer();
        this.horiz.setPack(BoxLayoutContainer.BoxLayoutPack.START);
        this.horiz.setEnableOverflow(false);
        if (this.tabularParameter.getDescription() == null) {
            descr = new HtmlLayoutContainer("<p style='margin-left:5px !important;'></p>");
            descr.addStyleName("workflow-fieldDescription");
        } else {
            descr = new HtmlLayoutContainer("<p style='margin-left:5px !important;'>" + this.tabularParameter.getDescription() + "</p>");
            descr.addStyleName("workflow-fieldDescription");
        }
        this.horiz.add((IsWidget)tabContainer, new BoxLayoutContainer.BoxLayoutData(new Margins()));
        this.horiz.add((IsWidget)descr, new BoxLayoutContainer.BoxLayoutData(new Margins()));
        this.fieldContainer.add((Widget)this.horiz);
    }

    private void init() throws Exception {
        try {
            try {
                this.wselectDialog = new WorkspaceExplorerSelectDialog("Select CSV", false);
                1 handler = new /* Unavailable Anonymous Inner Class!! */;
                this.wselectDialog.addWorkspaceExplorerSelectNotificationListener((WorkspaceExplorerSelectNotification.WorskpaceExplorerSelectNotificationListener)handler);
                this.wselectDialog.setZIndex(XDOM.getTopZIndex());
            }
            catch (Throwable e) {
                Log.error((String)("TabularField error using WorkspaceExplorerSelectDialog: " + e.getLocalizedMessage()));
                e.printStackTrace();
                throw new Exception("TabularField error using WorkspaceExplorerSelectDialog: " + e.getLocalizedMessage());
            }
            this.selectButton = new TextButton("Select Data Set");
            this.selectButton.addSelectHandler((SelectEvent.SelectHandler)new /* Unavailable Anonymous Inner Class!! */);
            this.selectButton.setIcon(DataMinerManager.resources.folderExplore());
            this.selectButton.setToolTip("Select Data Set");
            this.selectButton2 = new TextButton("");
            this.selectButton2.addSelectHandler((SelectEvent.SelectHandler)new /* Unavailable Anonymous Inner Class!! */);
            this.selectButton2.setIcon(DataMinerManager.resources.folderExplore());
            this.selectButton2.setToolTip("Select Another Data Set");
            this.cancelButton = new TextButton("");
            this.cancelButton.setIcon(DataMinerManager.resources.cancel());
            this.cancelButton.addSelectHandler((SelectEvent.SelectHandler)new /* Unavailable Anonymous Inner Class!! */);
            this.downloadButton = new TextButton("");
            this.downloadButton.setIcon(DataMinerManager.resources.download());
            this.downloadButton.addSelectHandler((SelectEvent.SelectHandler)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Throwable e) {
            Log.error((String)("TabularField init: " + e.getLocalizedMessage()));
            e.printStackTrace();
            throw e;
        }
    }

    private void retrieveTableInformation(Item item) {
        Log.debug((String)("Retrieved: " + item));
        this.itemDescriptionSelected = new ItemDescription(item.getId(), item.getName(), item.getOwner(), item.getPath(), item.getType().name());
        DataMinerPortletServiceAsync.INSTANCE.retrieveTableInformation(this.itemDescriptionSelected, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void downloadFile() {
        if (this.itemDescriptionSelected != null) {
            DownloadWidget downloadWidget = new DownloadWidget();
            downloadWidget.download(this.itemDescriptionSelected.getId());
        } else {
            UtilsGXT3.info((String)"Attention", (String)"Select a table!");
        }
    }

    private void showNoSelectionField() {
        this.vp.clear();
        this.vp.add((Widget)this.selectButton);
        this.vp.add((Widget)this.templatesList);
        this.vp.forceLayout();
        this.fieldContainer.forceLayout();
    }

    private void showFieldWithSelection() {
        String tableName = this.selectedTableItem.getName();
        if (tableName == null || tableName.isEmpty()) {
            tableName = "NoName";
        }
        TextField tableDescription = new TextField();
        tableDescription.setValue((Object)tableName);
        tableDescription.setReadOnly(true);
        HBoxLayoutContainer h = new HBoxLayoutContainer();
        h.add((IsWidget)tableDescription, new BoxLayoutContainer.BoxLayoutData(new Margins()));
        h.add((IsWidget)this.selectButton2, new BoxLayoutContainer.BoxLayoutData(new Margins()));
        h.add((IsWidget)this.downloadButton, new BoxLayoutContainer.BoxLayoutData(new Margins()));
        h.add((IsWidget)this.cancelButton, new BoxLayoutContainer.BoxLayoutData(new Margins()));
        this.vp.clear();
        this.vp.add((Widget)h);
        this.vp.add((Widget)this.templatesList);
        this.vp.forceLayout();
        this.fieldContainer.forceLayout();
    }

    public String getValue() {
        return this.selectedTableItem == null ? null : this.selectedTableItem.getId();
    }

    public Widget getWidget() {
        return this.fieldContainer;
    }

    public boolean isValid() {
        return this.selectedTableItem != null;
    }

    public HandlerRegistration addTabularFldChangeEventHandler(TabularFldChangeEvent.TabularFldChangeEventHandler handler) {
        return this.fieldContainer.addHandler((EventHandler)handler, TabularFldChangeEvent.getType());
    }

    private void updateListeners(TableItemSimple tableItemSimple) {
        TabularFldChangeEvent event = new TabularFldChangeEvent(tableItemSimple);
        this.fireEvent((GwtEvent)event);
    }

    public void fireEvent(GwtEvent<?> event) {
        this.fieldContainer.fireEvent(event);
    }

    static /* synthetic */ void access$000(TabularFld x0, Item x1) {
        x0.retrieveTableInformation(x1);
    }

    static /* synthetic */ WorkspaceExplorerSelectDialog access$100(TabularFld x0) {
        return x0.wselectDialog;
    }

    static /* synthetic */ TableItemSimple access$202(TabularFld x0, TableItemSimple x1) {
        x0.selectedTableItem = x1;
        return x0.selectedTableItem;
    }

    static /* synthetic */ void access$300(TabularFld x0) {
        x0.showNoSelectionField();
    }

    static /* synthetic */ void access$400(TabularFld x0, TableItemSimple x1) {
        x0.updateListeners(x1);
    }

    static /* synthetic */ void access$500(TabularFld x0) {
        x0.downloadFile();
    }

    static /* synthetic */ void access$600(TabularFld x0) {
        x0.showFieldWithSelection();
    }

    static /* synthetic */ TableItemSimple access$200(TabularFld x0) {
        return x0.selectedTableItem;
    }
}

