/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.dataminermanager.client.experiments;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import com.sencha.gxt.core.client.util.Margins;
import com.sencha.gxt.widget.core.client.button.TextButton;
import com.sencha.gxt.widget.core.client.container.HtmlLayoutContainer;
import com.sencha.gxt.widget.core.client.container.MarginData;
import com.sencha.gxt.widget.core.client.container.SimpleContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import com.sencha.gxt.widget.core.client.event.SelectEvent;
import com.sencha.gxt.widget.core.client.form.FieldSet;
import com.sencha.gxt.widget.core.client.form.FormPanel;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.gcube.data.analysis.dataminermanagercl.shared.parameters.ColumnListParameter;
import org.gcube.data.analysis.dataminermanagercl.shared.parameters.ColumnParameter;
import org.gcube.data.analysis.dataminermanagercl.shared.parameters.Parameter;
import org.gcube.data.analysis.dataminermanagercl.shared.parameters.ParameterType;
import org.gcube.data.analysis.dataminermanagercl.shared.process.Operator;
import org.gcube.portlets.user.dataminermanager.client.DataMinerManager;
import org.gcube.portlets.user.dataminermanager.client.events.TabularFldChangeEvent;
import org.gcube.portlets.user.dataminermanager.client.experiments.ComputationParametersPanel;
import org.gcube.portlets.user.dataminermanager.client.parametersfield.AbstractFld;
import org.gcube.portlets.user.dataminermanager.client.parametersfield.ColumnFld;
import org.gcube.portlets.user.dataminermanager.client.parametersfield.ColumnListFld;
import org.gcube.portlets.user.dataminermanager.client.parametersfield.OperatorFieldWidget;
import org.gcube.portlets.user.dataminermanager.client.parametersfield.TabularFld;
import org.gcube.portlets.user.dataminermanager.client.rpc.DataMinerPortletServiceAsync;
import org.gcube.portlets.user.dataminermanager.client.util.UtilsGXT3;

public class ComputationParametersPanel
extends SimpleContainer {
    private static final String START_BUTTON_TOOLTIP = "Start Computation";
    private static final ImageResource PRELOAD_IMAGE = DataMinerManager.resources.loaderBig();
    private VerticalLayoutContainer v;
    private Operator operator;
    private FormPanel parametersPanel;
    private FieldSet parametersFieldSet;
    private VerticalLayoutContainer vParameters;
    private Map<String, OperatorFieldWidget> fieldWidgetsMap;
    private ComputationParametersPanelHandler handler = null;
    private TextButton submit;

    public ComputationParametersPanel(Operator operator) {
        this.operator = operator;
        this.fieldWidgetsMap = new HashMap();
        try {
            this.init();
            this.create();
        }
        catch (Throwable e) {
            Log.error((String)("ComputationParametersPanel" + e.getLocalizedMessage()));
            e.printStackTrace();
        }
    }

    private void init() {
        this.setStylePrimaryName("workflow");
        this.setResize(true);
    }

    private void create() {
        this.v = new VerticalLayoutContainer();
        this.add((Widget)this.v);
        Image img = new Image(GWT.getModuleBaseURL() + "../images/operators/" + (this.operator.hasImage() ? this.operator.getId() : "DEFAULT_IMAGE") + ".png");
        img.setStylePrimaryName("workflow-icon");
        this.v.add((IsWidget)img, new VerticalLayoutContainer.VerticalLayoutData(-1.0, -1.0, new Margins(-15, 0, 0, 5)));
        String locationRef = "";
        try {
            String location = Window.Location.getHref();
            String[] locationData = location.split("\\?");
            locationRef = locationData[0];
        }
        catch (Throwable e) {
            Log.error((String)("Error retrieving location: " + e.getLocalizedMessage()));
        }
        HtmlLayoutContainer title = new HtmlLayoutContainer("<span><a href='" + locationRef + "?" + "OperatorId" + "=" + this.operator.getId() + "'>" + this.operator.getName() + "</a></span>");
        title.addStyleName("workflow-title");
        this.v.add((IsWidget)title, new VerticalLayoutContainer.VerticalLayoutData(-1.0, -1.0, new Margins(20, 0, 0, -25)));
        String descr = this.operator.getDescription();
        descr = descr == null || descr.contentEquals("") ? "no-description" : this.operator.getDescription();
        HtmlLayoutContainer description = new HtmlLayoutContainer("<span style='padding-left:10px;padding-right:10px;display:inline-block;'>" + descr + "</span>");
        description.addStyleName("workflow-description");
        this.v.add((IsWidget)description, new VerticalLayoutContainer.VerticalLayoutData(-1.0, -1.0, new Margins(0)));
        this.parametersPanel = new /* Unavailable Anonymous Inner Class!! */;
        this.parametersPanel.setBorders(false);
        this.parametersPanel.getElement().getStyle().setPaddingBottom(20.0, Style.Unit.PX);
        this.parametersFieldSet = new FieldSet();
        this.parametersFieldSet.setHeadingText("Parameters");
        this.vParameters = new VerticalLayoutContainer();
        Image imgLoading = new Image(PRELOAD_IMAGE);
        this.vParameters.add((IsWidget)imgLoading, new VerticalLayoutContainer.VerticalLayoutData(1.0, -1.0, new Margins(0)));
        this.parametersFieldSet.add((Widget)this.vParameters, new MarginData(new Margins(0)));
        this.parametersFieldSet.setCollapsible(false);
        this.parametersPanel.add((Widget)this.parametersFieldSet);
        this.v.add((IsWidget)this.parametersPanel, new VerticalLayoutContainer.VerticalLayoutData(1.0, -1.0, new Margins(5)));
        this.submit = new TextButton(START_BUTTON_TOOLTIP);
        this.submit.setToolTip(START_BUTTON_TOOLTIP);
        this.submit.setIcon(DataMinerManager.resources.startComputation());
        this.submit.getElement().getStyle().setMarginLeft(20.0, Style.Unit.PX);
        this.submit.getElement().getStyle().setMarginBottom(20.0, Style.Unit.PX);
        this.submit.addSelectHandler((SelectEvent.SelectHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.v.add((Widget)this.submit);
        this.submit.setVisible(false);
        this.forceLayout();
        this.loadOperatorParameters();
    }

    private void loadOperatorParameters() {
        DataMinerPortletServiceAsync.INSTANCE.getParameters(this.operator, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void showForm() {
        try {
            for (Parameter p : this.operator.getOperatorParameters()) {
                OperatorFieldWidget fieldWidget = new OperatorFieldWidget(p);
                this.fieldWidgetsMap.put(p.getName(), fieldWidget);
                this.vParameters.add((IsWidget)fieldWidget.getParameterLabel(), new VerticalLayoutContainer.VerticalLayoutData(1.0, -1.0, new Margins(0)));
            }
            for (Parameter p : this.operator.getOperatorParameters()) {
                if (p.getTypology().compareTo((Enum)ParameterType.COLUMN) != 0 && p.getTypology().compareTo((Enum)ParameterType.COLUMN_LIST) != 0) continue;
                String tabParamName = p.getTypology().compareTo((Enum)ParameterType.COLUMN) == 0 ? ((ColumnParameter)p).getReferredTabularParameterName() : ((ColumnListParameter)p).getReferredTabularParameterName();
                try {
                    TabularFld tabularField = (TabularFld)((OperatorFieldWidget)this.fieldWidgetsMap.get(tabParamName)).getField();
                    if (tabularField == null) continue;
                    AbstractFld field = ((OperatorFieldWidget)this.fieldWidgetsMap.get(p.getName())).getField();
                    if (field instanceof ColumnFld) {
                        ColumnFld columnField = (ColumnFld)field;
                        tabularField.addTabularFldChangeEventHandler((TabularFldChangeEvent.TabularFldChangeEventHandler)columnField);
                        continue;
                    }
                    if (!(field instanceof ColumnListFld)) continue;
                    ColumnListFld columnListField = (ColumnListFld)field;
                    tabularField.addTabularFldChangeEventHandler((TabularFldChangeEvent.TabularFldChangeEventHandler)columnListField);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    UtilsGXT3.alert((String)"Error", (String)("Column parameter \"" + p.getName() + " refers to a tabular parameter that doesn't exists (" + tabParamName + ")\""));
                }
            }
            this.parametersPanel.getElement().getStyle().setPaddingBottom(0.0, Style.Unit.PX);
            this.submit.setVisible(true);
            this.parametersPanel.forceLayout();
            this.forceLayout();
        }
        catch (Throwable e) {
            Log.error((String)("Error in show form:" + e.getLocalizedMessage()));
            Log.error((String)("Error: " + Arrays.asList(e.getStackTrace()).toString()));
            e.printStackTrace();
        }
    }

    public void updateOperatorParametersValues() {
        for (Map.Entry entry : this.fieldWidgetsMap.entrySet()) {
            OperatorFieldWidget fieldWidget = (OperatorFieldWidget)entry.getValue();
            fieldWidget.updateOperatorParameterValue();
        }
    }

    public Operator getOperator() {
        return this.operator;
    }

    public void setHandler(ComputationParametersPanelHandler handler) {
        this.handler = handler;
    }

    static /* synthetic */ Map access$000(ComputationParametersPanel x0) {
        return x0.fieldWidgetsMap;
    }

    static /* synthetic */ ComputationParametersPanelHandler access$100(ComputationParametersPanel x0) {
        return x0.handler;
    }

    static /* synthetic */ FormPanel access$200(ComputationParametersPanel x0) {
        return x0.parametersPanel;
    }

    static /* synthetic */ Operator access$300(ComputationParametersPanel x0) {
        return x0.operator;
    }

    static /* synthetic */ VerticalLayoutContainer access$400(ComputationParametersPanel x0) {
        return x0.vParameters;
    }
}

