/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.dataminermanagertester.server.testbatch;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.gcube.data.analysis.dataminermanagercl.server.DataMinerService;
import org.gcube.data.analysis.dataminermanagercl.server.dmservice.SClient;
import org.gcube.data.analysis.dataminermanagercl.shared.data.OutputData;
import org.gcube.data.analysis.dataminermanagercl.shared.data.computations.ComputationId;
import org.gcube.data.analysis.dataminermanagercl.shared.parameters.Parameter;
import org.gcube.data.analysis.dataminermanagercl.shared.process.ComputationStatus;
import org.gcube.data.analysis.dataminermanagercl.shared.process.Operator;
import org.gcube.portlets.user.dataminermanagertester.server.task.TaskRequest;
import org.gcube.portlets.user.dataminermanagertester.server.testbatch.TesterCaller;
import org.gcube.portlets.user.dataminermanagertester.server.testbuild.TestBuilder;
import org.gcube.portlets.user.dataminermanagertester.server.testconfig.DMTest;
import org.gcube.portlets.user.dataminermanagertester.shared.config.DMBatchConfig;
import org.gcube.portlets.user.dataminermanagertester.shared.config.TestType;
import org.gcube.portlets.user.dataminermanagertester.shared.exception.ServiceException;
import org.gcube.portlets.user.dataminermanagertester.shared.result.BatchTestResult;
import org.gcube.portlets.user.dataminermanagertester.shared.result.SingleTestResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TesterCaller {
    private static Logger logger = LoggerFactory.getLogger(TesterCaller.class);
    private DMTest dmTest;
    private DMBatchConfig dmBatchconfig;
    private ArrayList<String> dms;

    public BatchTestResult runTest(TaskRequest taskRequest) throws ServiceException {
        TestType t = null;
        if (taskRequest == null || taskRequest.getDmBatchConfig() == null || taskRequest.getDmBatchConfig().getTestType() == null || taskRequest.getDmBatchConfig().getTestType().isEmpty()) {
            throw new ServiceException("Invalid test type: " + taskRequest.getDmBatchConfig().getTestType());
        }
        t = TestType.getTypeFromId((String)taskRequest.getDmBatchConfig().getTestType());
        this.dmBatchconfig = taskRequest.getDmBatchConfig();
        this.dms = taskRequest.getDmBatchConfig().getDms();
        if (this.dms == null || this.dms.isEmpty()) {
            logger.error("Invalid urls list");
            throw new ServiceException("Invalid urls list");
        }
        BatchTestResult result = t.compareTo((Enum)TestType.Capabilities) == 0 ? this.runGetCapabilities() : this.runAlgorithms(t);
        return result;
    }

    private BatchTestResult runGetCapabilities() {
        LinkedHashMap<String, SingleTestResult> testResultMap = new LinkedHashMap<String, SingleTestResult>();
        for (String dm : this.dms) {
            try {
                String url = null;
                if (this.dmBatchconfig.getProtocol() != null && dm != null) {
                    dm = dm.trim();
                    url = new String(this.dmBatchconfig.getProtocol() + "://" + dm + "/wps/");
                }
                SClient sClient = new DataMinerService().getClient(this.dmBatchconfig.getToken(), url);
                List operatorsClassifications = sClient.getOperatorsClassifications();
                logger.debug("OperatorsClassifications: " + operatorsClassifications);
                String response = new String("Success");
                ComputationStatus computationStatus = new ComputationStatus(ComputationStatus.Status.COMPLETE, 100.0);
                SingleTestResult singleTestResult = new SingleTestResult(computationStatus, response);
                testResultMap.put(dm, singleTestResult);
            }
            catch (Exception e) {
                logger.error("Error testing: " + dm);
                ComputationStatus computationStatus = new ComputationStatus(e);
                SingleTestResult singleTestResult = new SingleTestResult(computationStatus, null);
                testResultMap.put(dm, singleTestResult);
            }
        }
        BatchTestResult result = new BatchTestResult(testResultMap);
        return result;
    }

    private BatchTestResult runAlgorithms(TestType t) throws ServiceException {
        TestBuilder testBuilder = new TestBuilder();
        this.dmTest = testBuilder.build(t);
        LinkedHashMap<String, SingleTestResult> testResultMap = new LinkedHashMap<String, SingleTestResult>();
        for (String dm : this.dms) {
            try {
                String url = null;
                if (this.dmBatchconfig.getProtocol() != null && dm != null) {
                    dm = dm.trim();
                    url = new String(this.dmBatchconfig.getProtocol() + "://" + dm + "/wps/");
                }
                SClient sClient = new DataMinerService().getClient(this.dmBatchconfig.getToken(), url);
                ComputationId computationId = this.runSingleTest(sClient);
                String response = null;
                ComputationStatus computationStatus = this.monitorSingleTest(sClient, computationId);
                switch (1.$SwitchMap$org$gcube$data$analysis$dataminermanagercl$shared$process$ComputationStatus$Status[computationStatus.getStatus().ordinal()]) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        response = this.retrieveOutputForSingleTest(sClient, computationId);
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 5: {
                        break;
                    }
                }
                SingleTestResult singleTestResult = new SingleTestResult(computationStatus, response);
                testResultMap.put(dm, singleTestResult);
            }
            catch (Exception e) {
                logger.error("Error testing: " + dm);
                ComputationStatus computationStatus = new ComputationStatus(e);
                SingleTestResult singleTestResult = new SingleTestResult(computationStatus, null);
                testResultMap.put(dm, singleTestResult);
            }
        }
        BatchTestResult result = new BatchTestResult(testResultMap);
        return result;
    }

    private ComputationId runSingleTest(SClient sClient) throws ServiceException {
        try {
            List operatorsClassifications = sClient.getOperatorsClassifications();
            logger.debug("OperatorsClassifications: " + operatorsClassifications);
            Operator operator = sClient.getOperatorById(this.dmTest.getId());
            if (operator == null) {
                logger.error("Operator not found");
                throw new ServiceException("Operator: " + this.dmTest.getId() + " not found");
            }
            logger.debug("Operator Name: " + operator.getName() + " (" + operator.getId() + ")");
            logger.debug("Operator: " + operator);
            List parameters = sClient.getInputParameters(operator);
            logger.debug("Parameters: " + parameters);
            for (Parameter parameter : parameters) {
                logger.debug("Parameter:[Name=" + parameter.getName() + ", Typology=" + parameter.getTypology() + "]");
            }
            this.dmTest.createRequest(operator);
            logger.debug("Start Computation");
            ComputationId computationId = sClient.startComputation(operator);
            logger.debug("Started ComputationId: " + computationId);
            return computationId;
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServiceException(e.getLocalizedMessage(), e);
        }
    }

    private ComputationStatus monitorSingleTest(SClient sClient, ComputationId computationId) throws ServiceException {
        try {
            logger.debug("Requesting operation progress");
            ComputationStatus computationStatus = null;
            ComputationStatus.Status status = null;
            block10: while (status == null || status.compareTo((Enum)ComputationStatus.Status.ACCEPTED) == 0 || status.compareTo((Enum)ComputationStatus.Status.RUNNING) == 0) {
                try {
                    computationStatus = sClient.getComputationStatus(computationId);
                }
                catch (Exception e) {
                    logger.error("Error retrieving computation Status:" + e.getLocalizedMessage(), (Throwable)e);
                    throw new ServiceException("Error retrieving computation Status:" + e.getLocalizedMessage(), (Throwable)e);
                }
                logger.debug("ComputationStatus: " + computationStatus);
                if (computationStatus == null) {
                    logger.error("ComputationStatus is null");
                    throw new ServiceException("Error retrieving computation Status: ComputationStatus is null");
                }
                status = computationStatus.getStatus();
                if (status == null) {
                    logger.error("Status is null");
                    throw new ServiceException("Error retrieving computation Status: Status is null");
                }
                switch (1.$SwitchMap$org$gcube$data$analysis$dataminermanagercl$shared$process$ComputationStatus$Status[status.ordinal()]) {
                    case 2: 
                    case 3: 
                    case 4: {
                        continue block10;
                    }
                }
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            return computationStatus;
        }
        catch (ServiceException e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.error(e.getLocalizedMessage(), e);
            throw new ServiceException(e.getLocalizedMessage(), e);
        }
    }

    private String retrieveOutputForSingleTest(SClient sClient, ComputationId computationId) throws ServiceException {
        try {
            OutputData outputData = sClient.getOutputDataByComputationId(computationId);
            if (this.dmTest.isValidResult(outputData)) {
                return this.dmTest.getResult(outputData);
            }
            throw new ServiceException("Invalid output data for test: " + this.dmTest.getId());
        }
        catch (ServiceException e) {
            logger.error(e.getLocalizedMessage());
            throw e;
        }
        catch (Throwable e) {
            logger.error(e.getLocalizedMessage(), e);
            throw new ServiceException(e.getLocalizedMessage(), e);
        }
    }
}

