/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.dataminermanagertester.server.testconfig;

import java.util.ArrayList;
import org.gcube.data.analysis.dataminermanagercl.shared.data.OutputData;
import org.gcube.data.analysis.dataminermanagercl.shared.data.output.MapResource;
import org.gcube.data.analysis.dataminermanagercl.shared.data.output.Resource;
import org.gcube.data.analysis.dataminermanagercl.shared.parameters.FileParameter;
import org.gcube.data.analysis.dataminermanagercl.shared.process.Operator;
import org.gcube.portlets.user.dataminermanagertester.server.testconfig.DMTest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenMeshRecostructorGPUTest
implements DMTest {
    private static Logger logger = LoggerFactory.getLogger(OpenMeshRecostructorGPUTest.class);
    private static final String id = "org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mappedclasses.transducerers.OPEN_MESH_RECONSTRUCTOR_GPU";

    public String getId() {
        return id;
    }

    public void createRequest(Operator operator) {
        logger.debug("Create Request");
        FileParameter inputZipFile = new FileParameter();
        inputZipFile.setName("InputZipFile");
        inputZipFile.setValue("https://data.d4science.org/shub/E_ZWNlZW1VbzI1NGdyRTRrbWtGZXcvdU52cG1RVnd2UDZrdGp1cDFodmZWRzFtQVlydVNHV0NuVis1VVRFT0FWZg==");
        ArrayList<FileParameter> parameters = new ArrayList<FileParameter>();
        parameters.add(inputZipFile);
        logger.debug("Parameters set: " + parameters);
        operator.setOperatorParameters(parameters);
    }

    public String getResult(OutputData outputData) {
        StringBuilder result = new StringBuilder();
        logger.debug("Output: " + outputData);
        Resource resource = outputData.getResource();
        if (resource.isMap()) {
            MapResource mapResource = (MapResource)resource;
            for (String key : mapResource.getMap().keySet()) {
                logger.debug("Entry: " + key + " = " + mapResource.getMap().get(key));
                result.append("Entry: " + key + " = " + mapResource.getMap().get(key));
            }
        }
        return result.toString();
    }

    public boolean isValidResult(OutputData outputData) {
        boolean valid;
        logger.debug("Output: " + outputData);
        Resource resource = outputData.getResource();
        if (resource.isMap()) {
            MapResource mapResource = (MapResource)resource;
            for (String key : mapResource.getMap().keySet()) {
                logger.debug("Entry: " + key + " = " + mapResource.getMap().get(key));
            }
            valid = true;
        } else {
            valid = false;
        }
        return valid;
    }
}

