/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.dataminermanagertester.server.testconfig;

import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gcube.data.analysis.dataminermanagercl.shared.data.OutputData;
import org.gcube.data.analysis.dataminermanagercl.shared.data.output.FileResource;
import org.gcube.data.analysis.dataminermanagercl.shared.data.output.ImageResource;
import org.gcube.data.analysis.dataminermanagercl.shared.data.output.MapResource;
import org.gcube.data.analysis.dataminermanagercl.shared.data.output.Resource;
import org.gcube.data.analysis.dataminermanagercl.shared.data.output.TableResource;
import org.gcube.data.analysis.dataminermanagercl.shared.parameters.ColumnListParameter;
import org.gcube.data.analysis.dataminermanagercl.shared.parameters.ObjectParameter;
import org.gcube.data.analysis.dataminermanagercl.shared.parameters.TabularParameter;
import org.gcube.data.analysis.dataminermanagercl.shared.process.Operator;
import org.gcube.portlets.user.dataminermanagertester.server.testconfig.DBScanTest;
import org.gcube.portlets.user.dataminermanagertester.server.testconfig.DMTest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBScanTest
implements DMTest {
    private static Logger logger = LoggerFactory.getLogger(DBScanTest.class);
    private static final String id = "org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mappedclasses.clusterers.DBSCAN";

    public String getId() {
        return id;
    }

    public void createRequest(Operator operator) {
        logger.debug("Create Request");
        TabularParameter occurencePointsTable = new TabularParameter();
        occurencePointsTable.setName("OccurrencePointsTable");
        occurencePointsTable.setValue("https://data.d4science.org/YmRKWDU4Y0RJT2hSLzcybU4zRmJoTEg2YTBMWlRZVUpHbWJQNStIS0N6Yz0");
        ColumnListParameter columnListParameter = new ColumnListParameter();
        columnListParameter.setName("FeaturesColumnNames");
        columnListParameter.setValue("depthmean|sstmnmax|salinitymin");
        ObjectParameter occurencePointsClusterLabel = new ObjectParameter();
        occurencePointsClusterLabel.setName("OccurrencePointsClusterLabel");
        occurencePointsClusterLabel.setValue("Test");
        ObjectParameter epsilon = new ObjectParameter();
        epsilon.setName("epsilon");
        epsilon.setValue("10");
        ObjectParameter minPoints = new ObjectParameter();
        minPoints.setName("min_points");
        minPoints.setValue("1");
        ArrayList<Object> parameters = new ArrayList<Object>();
        parameters.add(occurencePointsTable);
        parameters.add(columnListParameter);
        parameters.add(occurencePointsClusterLabel);
        parameters.add(epsilon);
        parameters.add(minPoints);
        logger.debug("Parameters set: " + parameters);
        operator.setOperatorParameters(parameters);
    }

    public String getResult(OutputData outputData) {
        StringBuilder result = new StringBuilder();
        logger.debug("Output: " + outputData);
        Resource resource = outputData.getResource();
        if (resource.isMap()) {
            MapResource mapResource = (MapResource)resource;
            block7: for (String key : mapResource.getMap().keySet()) {
                Resource res = (Resource)mapResource.getMap().get(key);
                switch (1.$SwitchMap$org$gcube$data$analysis$dataminermanagercl$shared$data$output$Resource$ResourceType[res.getResourceType().ordinal()]) {
                    case 1: {
                        FileResource fileResource = (FileResource)res;
                        String fileName = this.retrieveFileName(fileResource.getUrl());
                        logger.debug("Entry: " + key + " = " + mapResource.getMap().get(key) + ", FileName=" + fileName);
                        result.append("Entry: " + key + " = " + mapResource.getMap().get(key) + ", FileName=" + fileName);
                        continue block7;
                    }
                    case 2: {
                        ImageResource imageResource = (ImageResource)res;
                        String imageName = this.retrieveFileName(imageResource.getLink());
                        logger.debug("Entry: " + key + " = " + mapResource.getMap().get(key) + ", ImageName=" + imageName);
                        result.append("Entry: " + key + " = " + mapResource.getMap().get(key) + ", ImageName=" + imageName);
                        continue block7;
                    }
                    case 3: {
                        logger.debug("Entry: " + key + " = " + mapResource.getMap().get(key));
                        result.append("Entry: " + key + " = " + mapResource.getMap().get(key));
                        continue block7;
                    }
                    case 4: {
                        logger.debug("Entry: " + key + " = " + mapResource.getMap().get(key));
                        result.append("Entry: " + key + " = " + mapResource.getMap().get(key));
                        continue block7;
                    }
                    case 5: {
                        TableResource tableResource = (TableResource)res;
                        String tableName = this.retrieveFileName(tableResource.getResourceId());
                        logger.debug("Entry: " + key + " = " + mapResource.getMap().get(key) + ", TableName=" + tableName);
                        result.append("Entry: " + key + " = " + mapResource.getMap().get(key) + ", TableName=" + tableName);
                        continue block7;
                    }
                }
                logger.debug("Entry: " + key + " = " + mapResource.getMap().get(key));
                result.append("Entry: " + key + " = " + mapResource.getMap().get(key));
            }
        }
        return result.toString();
    }

    public boolean isValidResult(OutputData outputData) {
        boolean valid;
        logger.debug("Output: " + outputData);
        Resource resource = outputData.getResource();
        if (resource.isMap()) {
            MapResource mapResource = (MapResource)resource;
            for (String key : mapResource.getMap().keySet()) {
                logger.debug("Entry: " + key + " = " + mapResource.getMap().get(key));
            }
            valid = true;
        } else {
            valid = false;
        }
        return valid;
    }

    private String retrieveFileName(String url) {
        String fileName = "output";
        try {
            URL urlObj = new URL(url);
            HttpURLConnection connection = (HttpURLConnection)urlObj.openConnection();
            connection.setRequestMethod("GET");
            String contentDisposition = connection.getHeaderField("Content-Disposition");
            Pattern regex = Pattern.compile("(?<=filename=\").*?(?=\")");
            Matcher regexMatcher = regex.matcher(contentDisposition);
            if (regexMatcher.find()) {
                fileName = regexMatcher.group();
            }
            if (fileName == null || fileName.isEmpty()) {
                fileName = "output";
            }
            return fileName;
        }
        catch (Throwable e) {
            logger.error("Error retrieving file name: " + e.getLocalizedMessage(), e);
            return fileName;
        }
    }
}

