package org.gcube.portlets.user.collectionsviewer.client.view.panels;

import java.util.ArrayList;
import java.util.List;

import net.eliasbalasis.tibcopagebus4gwt.client.PageBusAdapter;
import net.eliasbalasis.tibcopagebus4gwt.client.PageBusAdapterException;
import net.eliasbalasis.tibcopagebus4gwt.testsubscriber.client.Person;
import net.eliasbalasis.tibcopagebus4gwt.testsubscriber.client.PersonJsonizer;
import net.eliasbalasis.tibcopagebus4gwt.testsubscriber.client.SubscriberData;

import org.gcube.portlets.user.collectionsviewer.client.ViewerService;
import org.gcube.portlets.user.collectionsviewer.client.ViewerServiceAsync;
import org.gcube.portlets.user.collectionsviewer.shared.CollectionBean;
import org.jsonmaker.gwt.client.Jsonizer;

import com.extjs.gxt.ui.client.Style.HorizontalAlignment;
import com.extjs.gxt.ui.client.core.XTemplate;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.store.GroupingStore;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Info;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.grid.ColumnConfig;
import com.extjs.gxt.ui.client.widget.grid.ColumnModel;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.grid.GroupingView;
import com.extjs.gxt.ui.client.widget.grid.RowExpander;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.google.gwt.core.client.GWT;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;


public class MainPanel extends ContentPanel { 

	/**
	 * Create a remote service proxy to talk to the server-side Greeting service.
	 */
	private final ViewerServiceAsync viewerService = GWT.create(ViewerService.class);

	/**
	 * 
	 */
	private void showLoading() {
		mask("Loading Collections", "loading-indicator");		
	}

	final PageBusAdapter pageBusAdapter = new PageBusAdapter();

	public MainPanel() {
		setHeaderVisible(false);
		showLoading();
		viewerService.getAvailableCollections(new AsyncCallback<List<CollectionBean>>() {			
			public void onSuccess(List<CollectionBean> collections) {
				unmask();
				if (collections.size() == 1 && collections.get(0).getId().equals("0000")) {
					addText("Error on server: Cannot retrieve collection in this scope");
					layout();
				}
				else
					showCollections(collections);
			}			
			public void onFailure(Throwable caught) {
				unmask();
				addText("Error on server: " + caught.getMessage());
			}
		});		
	}

	/**
	 * view for collections step
	 * @param vDesc
	 */
	public void showCollections(List<CollectionBean> collections) {  

		ColumnModel cm = null;
		List<ColumnConfig> configs = new ArrayList<ColumnConfig>();  

		XTemplate tpl = XTemplate.create("<p style=\"padding-left:10px;\"><b>Description:</b> {description}<br><b>ID:</b> {id}<br>");

		RowExpander expander = new RowExpander();
		expander.setTemplate(tpl);

		configs.add(expander);

		ColumnConfig column = new ColumnConfig();  
		column.setId("id");  
		column.setHeader("ID");
		column.setHidden(true);
		column.setWidth(50);  
		column.setRowHeader(true);  
		configs.add(column);  

		column = new ColumnConfig();  
		column.setId("name");  
		column.setHeader("Name");  
		column.setWidth(150);  
		configs.add(column);  

		column = new ColumnConfig();  
		column.setId("creationTime");  
		column.setHeader("Creation Time"); 
		column.setHidden(true);
		column.setAlignment(HorizontalAlignment.CENTER);
		column.setDateTimeFormat(DateTimeFormat.getFormat("dd/MM/yyyy"));
		column.setWidth(50);  
		configs.add(column);  
		
		column = new ColumnConfig();  
		column.setId("source");  
		column.setHeader("Source"); 
		column.setHidden(true);
		column.setWidth(150);  
		configs.add(column);  

		cm = new ColumnModel(configs); 

		/**
		 * load the grid data
		 */
		GroupingStore<CollectionBean> store = new GroupingStore<CollectionBean>();
		store.add(collections);  
	    store.groupBy("source");  

	
	    
		final Grid<CollectionBean> grid = new Grid<CollectionBean>(store, cm); 
	    
		grid.addPlugin(expander);
		grid.setStyleAttribute("borderTop", "none"); 
		grid.setAutoExpandColumn("name"); 
		grid.setBorders(true); 
		grid.setStripeRows(true);
	
		
		GroupingView view = new GroupingView();  
	    view.setShowGroupedColumn(false); 
	    grid.setView(view);
	    view.setForceFit(true);  	 


		ContentPanel gridPanel = new ContentPanel(new FitLayout());
		gridPanel.setHeaderVisible(false);
		gridPanel.add(grid); 		

		gridPanel.addButton(new Button("Explore", new SelectionListener<ButtonEvent>() {  
			@Override  
			public void componentSelected(ButtonEvent ce) {  
				CollectionBean cb = grid.getSelectionModel().getSelectedItem();
				

				SubscriberData subscriberData = new SubscriberData();
				subscriberData.setHeader("myHeader");
				subscriberData.setBody("myBody");
				//passing collection id
				Person id = new Person();
				id.setName(cb.getId());
				
				id.setDescription(cb.getSource());

				// publish a message with Person bean data
				try {
					pageBusAdapter.PageBusPublish("net.eliasbalasis.tibcopagebus4gwt.testsubscriber.client.Person", id, (Jsonizer)GWT.create(PersonJsonizer.class));
				} catch(PageBusAdapterException ex) {
					Window.alert("Publication failed\n\n"+ex.toString()+"\n\n"+ex.getCause().toString());
				}
				Info.display("Event Publicaton", "Correctly sent id of " + cb.getName());
			}  
		}));  
		gridPanel.setBorders(false);

		add(gridPanel);

		setLayout(new FitLayout()); 
		layout();

	}

}  
