/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.wftemplates.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.util.ArrayList;
import java.util.Date;
import javax.servlet.http.HttpSession;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.portlets.admin.wfdocslibrary.server.db.MyDerbyStore;
import org.gcube.portlets.admin.wfdocslibrary.server.db.Store;
import org.gcube.portlets.admin.wfdocslibrary.shared.WfGraph;
import org.gcube.portlets.admin.wfdocslibrary.shared.WfGraphDetails;
import org.gcube.portlets.admin.wfdocslibrary.shared.WfRole;
import org.gcube.portlets.admin.wfdocslibrary.shared.WfRoleDetails;
import org.gcube.portlets.admin.wfdocslibrary.shared.WfTemplate;
import org.gcube.portlets.admin.wftemplates.client.WfTemplatesService;

public class WfTemplatesServiceImpl
extends RemoteServiceServlet
implements WfTemplatesService {
    private static final String HARD_CODED_VO_NAME = "/gcube/devsec";
    private static GCUBELog log = new GCUBELog(WfTemplatesServiceImpl.class);
    private Store store;
    private XStream xstream;

    public void init() {
        this.store = new MyDerbyStore();
        this.xstream = new XStream((HierarchicalStreamDriver)new DomDriver());
    }

    private ASLSession getASLSession() {
        HttpSession session = this.getThreadLocalRequest().getSession();
        String username = (String)session.getAttribute("username");
        if (username == null) {
            username = "test.user";
            SessionManager.getInstance().getASLSession(session.getId(), username).setScope(HARD_CODED_VO_NAME);
            SessionManager.getInstance().getASLSession(session.getId(), username).setUserFullName("Test User FullName");
        }
        return SessionManager.getInstance().getASLSession(session.getId(), username);
    }

    public Boolean saveTemplate(String wfName, WfGraph toSave) {
        log.info((Object)("Attempting to Save Template ..." + wfName));
        String wfXML = this.xstream.toXML((Object)toSave);
        log.debug((Object)("Serialized Workflow ...\n" + wfXML));
        System.out.println("Serialized Workflow ...\n" + wfXML);
        log.info((Object)"Saving template into DB ...");
        boolean result = this.store.addWorkflowTemplate(wfName, this.getASLSession().getUserFullName(), wfXML);
        log.info((Object)("Saving into DB SUCCESSFUL, returning " + result));
        return result;
    }

    public ArrayList<WfTemplate> getTemplates() {
        ArrayList<WfTemplate> templates = new ArrayList<WfTemplate>();
        for (WfGraphDetails g : this.store.getAllWorkflowTemplates()) {
            WfGraph graph = (WfGraph)this.xstream.fromXML(g.getGraph());
            Date date = g.getDateCreated();
            templates.add(new WfTemplate(g.getId(), g.getName(), g.getAuthor(), date, graph));
        }
        return new ArrayList<WfTemplate>(templates);
    }

    public ArrayList<WfRoleDetails> getRoleDetails() {
        log.debug((Object)"Getting Workflow Roles from DB");
        ArrayList<WfRoleDetails> toReturn = new ArrayList<WfRoleDetails>();
        for (WfRole r : this.store.getAllRoles()) {
            toReturn.add(new WfRoleDetails(r.getRoleid(), r.getRolename()));
        }
        return toReturn;
    }

    public Boolean deleteTemplate(WfTemplate toDelete) {
        return this.store.deleteWfTemplate(toDelete.getTemplateid());
    }
}

