/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.wftemplates.client.view;

import com.allen_sauer.gwt.dnd.client.PickupDragController;
import com.allen_sauer.gwt.dnd.client.drop.DropController;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.HasClickHandlers;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.HasKeyboardSelectionPolicy;
import com.google.gwt.user.cellview.client.SimplePager;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DockLayoutPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.HasRows;
import com.google.gwt.view.client.ProvidesKey;
import com.google.gwt.view.client.RangeChangeEvent;
import com.google.gwt.view.client.SelectionModel;
import com.google.gwt.view.client.SingleSelectionModel;
import com.orange.links.client.DiagramController;
import com.orange.links.client.canvas.DiagramCanvas;
import com.orange.links.client.canvas.MultiBrowserDiagramCanvas;
import com.orange.links.client.connection.Connection;
import com.orange.links.client.event.TieLinkHandler;
import java.util.ArrayList;
import java.util.List;
import org.gcube.portlets.admin.wfdocslibrary.shared.EdgePoint;
import org.gcube.portlets.admin.wfdocslibrary.shared.ForwardAction;
import org.gcube.portlets.admin.wfdocslibrary.shared.Step;
import org.gcube.portlets.admin.wfdocslibrary.shared.WfGraph;
import org.gcube.portlets.admin.wfdocslibrary.shared.WfTemplate;
import org.gcube.portlets.admin.wftemplates.client.WfTemplatesConstants;
import org.gcube.portlets.admin.wftemplates.client.presenter.MyDiagramController;
import org.gcube.portlets.admin.wftemplates.client.presenter.MyDropController;
import org.gcube.portlets.admin.wftemplates.client.presenter.WfTemplatesPresenter;
import org.gcube.portlets.admin.wftemplates.client.view.WfStep;
import org.gcube.portlets.admin.wftemplates.client.view.WfTemplatesView;
import org.gcube.portlets.user.gcubewidgets.client.GCubePanel;

public class WfTemplatesView
extends Composite
implements WfTemplatesPresenter.Display {
    public static final int TEMPLATES_PER_PAGE = 15;
    private GCubePanel mainPanel;
    private DockLayoutPanel layoutPanel = new DockLayoutPanel(Style.Unit.PCT);
    private VerticalPanel westPanel;
    private VerticalPanel centerPanel;
    private HorizontalPanel southPanel;
    AbsolutePanel dropPanel = new AbsolutePanel();
    private Button createNewButton = new Button("Create New");
    private Button addNewStepButton = new Button("Add New Step");
    private Button deleteButton = new Button("Delete selected");
    private Button saveButton = new Button("Save template");
    private Button resetButton = new Button("Reset current");
    private MyDiagramController dc;
    PickupDragController dragController;
    private CellTable<WfTemplate> table;
    private SingleSelectionModel<WfTemplate> selectionModel;
    private ArrayList<Step> steps;
    private ArrayList<WfStep> wfsteps;

    public WfTemplatesView() {
        this.mainPanel = new GCubePanel("Workflow Template Editor", "https://gcube.wiki.gcube-system.org/gcube/index.php/Workflow_Templates");
        this.westPanel = this.getWestPanel();
        this.southPanel = this.getSouthPanel();
        this.centerPanel = this.getCenterPanel();
        this.centerPanel.setWidth("100%");
        this.southPanel.setWidth("100%");
        this.southPanel.setStyleName("southPanel");
        this.layoutPanel.addWest((Widget)this.westPanel, 20.0);
        this.layoutPanel.addSouth((Widget)this.southPanel, 7.0);
        this.layoutPanel.add((Widget)this.centerPanel);
        this.mainPanel.add((Widget)this.layoutPanel);
        this.initWidget((Widget)this.mainPanel);
        Window.addResizeHandler((ResizeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.initTable();
        this.updateSize();
        this.enableGraphControlPanel(false);
    }

    public void resetView() {
        this.resetInitGraphWidget(null, null);
        this.enableGraphControlPanel(false);
        this.enableSaveButton(false);
        this.enableDropPanel(false);
    }

    private void initTable() {
        2 keyProvider = new /* Unavailable Anonymous Inner Class!! */;
        this.table = new CellTable(15, (ProvidesKey)keyProvider);
        this.selectionModel = new SingleSelectionModel();
        this.table.setSelectionModel((SelectionModel)this.selectionModel);
    }

    private VerticalPanel getCenterPanel() {
        VerticalPanel toRet = new VerticalPanel();
        HTML displayInit = new HTML("Click on a template or create a new one", true);
        displayInit.setStyleName("splashDisplay");
        toRet.setHorizontalAlignment(HasAlignment.ALIGN_CENTER);
        toRet.setVerticalAlignment(HasAlignment.ALIGN_MIDDLE);
        toRet.add((Widget)displayInit);
        return toRet;
    }

    private VerticalPanel getWestPanel() {
        VerticalPanel toReturn = new VerticalPanel();
        toReturn.setWidth("100%");
        toReturn.setStyleName("westPanel");
        return toReturn;
    }

    public void setData(List<WfTemplate> list) {
        this.table = this.getTemplatesTable(list);
        this.getWestPanel().clear();
        SimplePager.Resources pagerResources = (SimplePager.Resources)GWT.create(SimplePager.Resources.class);
        SimplePager pager = new SimplePager(SimplePager.TextLocation.CENTER, pagerResources, false, 0, true);
        pager.setDisplay((HasRows)this.table);
        this.westPanel.add((Widget)this.table);
        this.westPanel.setHorizontalAlignment(HasAlignment.ALIGN_CENTER);
        this.westPanel.add((Widget)pager);
        HorizontalPanel bottomPanel = new HorizontalPanel();
        bottomPanel.add((Widget)this.deleteButton);
        bottomPanel.add((Widget)this.createNewButton);
        this.westPanel.add((Widget)bottomPanel);
    }

    private CellTable<WfTemplate> getTemplatesTable(List<WfTemplate> templates) {
        if (this.table.getColumnCount() == 0) {
            3 nameColumn = new /* Unavailable Anonymous Inner Class!! */;
            this.table.addColumn((Column)nameColumn, "Name");
            4 authorColumn = new /* Unavailable Anonymous Inner Class!! */;
            this.table.addColumn((Column)authorColumn, "Author");
            this.table.setKeyboardSelectionPolicy(HasKeyboardSelectionPolicy.KeyboardSelectionPolicy.DISABLED);
        }
        this.table.addRangeChangeHandler((RangeChangeEvent.Handler)new /* Unavailable Anonymous Inner Class!! */);
        this.table.setRowCount(templates.size());
        this.table.setRowData(0, templates);
        this.table.setWidth("100%", true);
        return this.table;
    }

    private HorizontalPanel getSouthPanel() {
        HorizontalPanel toRet = new HorizontalPanel();
        HorizontalPanel buttonsP = new HorizontalPanel();
        toRet.setHorizontalAlignment(HasAlignment.ALIGN_RIGHT);
        toRet.setVerticalAlignment(HasAlignment.ALIGN_MIDDLE);
        buttonsP.add((Widget)this.addNewStepButton);
        buttonsP.add((Widget)this.resetButton);
        buttonsP.add((Widget)this.saveButton);
        buttonsP.setSpacing(5);
        toRet.setStyleName("southPanel");
        this.saveButton.setWidth("120px");
        toRet.add((Widget)buttonsP);
        return toRet;
    }

    public HasClickHandlers getCreateNewButton() {
        return this.createNewButton;
    }

    public HasClickHandlers getDeleteButton() {
        return this.deleteButton;
    }

    public HasClickHandlers getSaveButton() {
        return this.saveButton;
    }

    public HasClickHandlers getResetButton() {
        return this.resetButton;
    }

    public HasClickHandlers getAddNewStepButton() {
        return this.addNewStepButton;
    }

    public MyDiagramController getDiagramController() {
        return this.dc;
    }

    public SingleSelectionModel<WfTemplate> getTableSelectionModel() {
        return this.selectionModel;
    }

    public void displaySelectedWfTemplate(WfGraph graph, TieLinkHandler linkHandler, HandlerManager eventBus) {
        this.resetInitGraphWidget(linkHandler, eventBus);
        Step[] steps = graph.getSteps();
        for (int i = 0; i < steps.length; ++i) {
            this.addNewStep(steps[i].getLabel(), steps[i].getDescription(), new int[]{steps[i].getLeft(), steps[i].getTop()});
        }
        ForwardAction[][] matrix = graph.getMatrix();
        for (int i = 0; i < steps.length; ++i) {
            for (int j = 0; j < steps.length; ++j) {
                if (matrix[i][j] == null) continue;
                Connection c1 = this.dc.drawStraightArrowConnection((Widget)this.wfsteps.get(i), (Widget)this.wfsteps.get(j));
                ForwardAction fwA = matrix[i][j];
                this.addNewRoles(c1, fwA.getRolesToString());
                for (EdgePoint p : fwA.getPoints()) {
                    this.dc.addPointOnConnection(c1, p.getLeft(), p.getTop());
                }
            }
        }
    }

    public void showCreateNewTemplate(TieLinkHandler linkHandler, HandlerManager eventBus) {
        DiagramCanvas canvas = this.resetInitGraphWidget(linkHandler, eventBus);
        int midY = canvas.getHeight() / 2;
        this.addNewStep("Start", "This is the entry point step of the workflow and is always present", new int[]{25, midY});
        this.addNewStep("End", "This is the ending point step of the workflow and is always present", new int[]{canvas.getWidth() - 100, midY});
    }

    private DiagramCanvas resetInitGraphWidget(TieLinkHandler linkHandler, HandlerManager eventBus) {
        this.centerPanel.setHorizontalAlignment(HasAlignment.ALIGN_LEFT);
        int width = this.centerPanel.getOffsetWidth();
        int height = this.centerPanel.getOffsetHeight();
        MultiBrowserDiagramCanvas canvas = new MultiBrowserDiagramCanvas(width, height - 50);
        this.steps = new ArrayList();
        this.wfsteps = new ArrayList();
        if (this.dc == null) {
            this.centerPanel.clear();
            this.dc = new MyDiagramController((DiagramCanvas)canvas, eventBus);
            this.dc.showGrid(true);
            this.dc.addTieLinkHandler(linkHandler);
            this.centerPanel.setVerticalAlignment(HasAlignment.ALIGN_TOP);
            this.centerPanel.add((Widget)this.dc.getView());
            this.dragController = new PickupDragController(this.dc.getView(), true);
            this.dragController.setBehaviorConstrainedToBoundaryPanel(false);
            this.dc.addDeleteOptionInContextualMenu("Delete this edge");
            this.dc.addSetStraightOptionInContextualMenu("Set Straight");
            MultiBrowserDiagramCanvas canvas2 = new MultiBrowserDiagramCanvas(width, height - (height - 50));
            DiagramController dc2 = new DiagramController((DiagramCanvas)canvas2);
            dc2.showGrid(true);
            this.dropPanel.add((Widget)dc2.getView());
            HTML remove = new HTML("Remove Step");
            Image trashbin = new Image(WfTemplatesConstants.TRASH_IMAGE);
            trashbin.addStyleName("removePanel");
            remove.addStyleName("removePanel");
            dc2.addWidget((Widget)remove, width / 2 - 60, 10);
            dc2.addWidget((Widget)trashbin, width / 2 - 97, 10);
            this.dropPanel.setPixelSize(width, 50);
            this.dropPanel.getElement().getStyle().setBackgroundColor("#333");
            this.dropPanel.getElement().getStyle().setBackgroundColor("rgba(51,51,51,0.30");
            this.dropPanel.getElement().getStyle().setOpacity(0.5);
            this.centerPanel.add((Widget)this.dropPanel);
            this.dropPanel.setVisible(false);
            MyDropController dropController = new MyDropController(this.dropPanel, this.dc);
            this.dragController.registerDropController((DropController)dropController);
        } else {
            GWT.log((String)"CLEARING DIAGRAM");
            this.dc.clearDiagram();
        }
        return canvas;
    }

    private void makeDraggable(Widget toDrag) {
        this.dragController.makeDraggable(toDrag);
    }

    public void enableDropPanel(boolean enabled) {
        this.dropPanel.setVisible(enabled);
    }

    public void addNewStep(String stepName, String description, int ... leftTop) {
        if (leftTop.length != 2 && leftTop.length != 0) {
            throw new IllegalArgumentException("Only int left int top permitted or none of them");
        }
        WfStep toAdd = new WfStep(stepName, description);
        int left = 50;
        int top = 50;
        if (leftTop.length == 2) {
            left = leftTop[0];
            top = leftTop[1];
        }
        this.dc.addWidget((Widget)toAdd, left, top);
        this.makeDraggable((Widget)toAdd);
        this.steps.add(new Step(left, top, stepName, description, null));
        this.wfsteps.add(toAdd);
    }

    public void addNewRoles(Connection selectedEdge, String toDisplay) {
        Label decorationLabel = new Label(toDisplay);
        decorationLabel.getElement().getStyle().setPadding(2.0, Style.Unit.PX);
        decorationLabel.getElement().getStyle().setBackgroundColor("#FFF");
        decorationLabel.getElement().getStyle().setProperty("border", "1px dashed black");
        this.dc.addDecoration((Widget)decorationLabel, selectedEdge);
    }

    public void enableSaveButton(boolean enabled) {
        this.saveButton.setEnabled(enabled);
    }

    private void updateSize() {
        RootPanel workspace = RootPanel.get((String)"WfTemplates");
        int topBorder = workspace.getAbsoluteTop();
        int leftBorder = workspace.getAbsoluteLeft();
        int rightScrollBar = 17;
        int rootHeight = Window.getClientHeight() - topBorder - 4;
        int rootWidth = Window.getClientWidth() - leftBorder;
        this.mainPanel.setPixelSize(rootWidth - 10, rootHeight - 30);
        this.layoutPanel.setPixelSize(rootWidth - 10, rootHeight - 30);
        this.westPanel.setSize("100%", "100%");
        this.centerPanel.setSize("100%", "100%");
    }

    public Widget asWidget() {
        return this;
    }

    public void showLoading(boolean show) {
        VerticalPanel load = new VerticalPanel();
        if (show) {
            load.setWidth("100%");
            RootPanel workspace = RootPanel.get();
            int topBorder = workspace.getAbsoluteTop();
            int rootHeight = Window.getClientHeight() - topBorder - 100;
            load.setHeight(rootHeight + "px");
            load.setHorizontalAlignment(HasAlignment.ALIGN_CENTER);
            load.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
            load.add((Widget)new Image(WfTemplatesConstants.LOADING));
            this.westPanel.add((Widget)load);
        } else {
            this.westPanel.clear();
        }
    }

    public void enableGraphControlPanel(boolean enabled) {
        this.southPanel.setVisible(true);
        this.saveButton.setEnabled(enabled);
        this.addNewStepButton.setEnabled(enabled);
        this.resetButton.setEnabled(enabled);
    }

    public void enableDeleteButton(boolean enabled) {
        this.deleteButton.setEnabled(enabled);
    }

    static /* synthetic */ void access$000(WfTemplatesView x0) {
        x0.updateSize();
    }

    static /* synthetic */ CellTable access$100(WfTemplatesView x0) {
        return x0.table;
    }
}

