/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.wfdocviewer.client.presenter;

import com.extjs.gxt.ui.client.event.SelectionChangedListener;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.ListView;
import com.google.gwt.cell.client.FieldUpdater;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HasWidgets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.gcube.portlets.admin.wfdocslibrary.shared.PermissionType;
import org.gcube.portlets.admin.wfdocslibrary.shared.Step;
import org.gcube.portlets.admin.wfdocslibrary.shared.WfGraph;
import org.gcube.portlets.admin.wfdocslibrary.shared.WfRole;
import org.gcube.portlets.admin.wfdocslibrary.shared.WfRoleDetails;
import org.gcube.portlets.admin.wfdocviewer.client.WorkflowDocServiceAsync;
import org.gcube.portlets.admin.wfdocviewer.client.presenter.Display;
import org.gcube.portlets.admin.wfdocviewer.client.presenter.Presenter;
import org.gcube.portlets.admin.wfdocviewer.client.view.dialog.AddRolesDialog;
import org.gcube.portlets.admin.wfdocviewer.shared.WfDocumentBean;
import org.gcube.portlets.user.workspace.lighttree.client.event.PopupHandler;

public class WorkflowDocsPresenter
implements Presenter {
    private static final boolean testing = false;
    private ArrayList<WfRoleDetails> rolesCache = null;
    private final WorkflowDocServiceAsync rpcService;
    private final HandlerManager eventBus;
    private final Display display;
    private WfGraph displayingWorkflow;
    private String selectedReportID;
    private String selectedReportName;
    private String selecteTemplateName;

    public WorkflowDocsPresenter(WorkflowDocServiceAsync rpcService, HandlerManager eventBus, Display view) {
        this.rpcService = rpcService;
        this.eventBus = eventBus;
        this.display = view;
    }

    public void bind() {
        this.display.getGridSelectionModel().addSelectionChangedListener((SelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        this.display.getDeleteButton().addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.display.getDetailsButton().addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.display.getAddnewButton().addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.display.getNextButton().addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.display.getActionsLogButton().addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.display.getCreateNewWfReportButton().addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.display.getWSTreepopup().addPopupHandler((PopupHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.display.getSelectWfTemplateCombo().addSelectionChangedListener((SelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        this.display.getViewCheckColumn().setFieldUpdater((FieldUpdater)new /* Unavailable Anonymous Inner Class!! */);
        this.display.getUpdateCheckColumn().setFieldUpdater((FieldUpdater)new /* Unavailable Anonymous Inner Class!! */);
        this.display.getDeleteCheckColumn().setFieldUpdater((FieldUpdater)new /* Unavailable Anonymous Inner Class!! */);
        this.display.getEditPermissionCheckColumn().setFieldUpdater((FieldUpdater)new /* Unavailable Anonymous Inner Class!! */);
        this.display.getAddCommentsCheckColumn().setFieldUpdater((FieldUpdater)new /* Unavailable Anonymous Inner Class!! */);
        this.display.getDeleteCommentsCheckColumn().setFieldUpdater((FieldUpdater)new /* Unavailable Anonymous Inner Class!! */);
        this.display.getUpdateCommentsCheckColumn().setFieldUpdater((FieldUpdater)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void go(HasWidgets container) {
        this.bind();
        container.clear();
        container.add(this.display.asWidget());
        this.fetchWfDocumentsDetails();
        this.enableActionButtons(false);
    }

    private void fetchWfDocumentsDetails() {
        this.display.maskWestPanel("Loading Workflows Documents", true);
        this.rpcService.getAllWfDocuments((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void doInstanciateNewWorkflow(String reportid, String reportName) {
        this.display.maskCenterPanel("Retrieving workflow templates, please wait ... ", true);
        this.rpcService.getAllTemplates((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void doLoadWfReport(String workflowid, String status) {
        this.display.maskCenterPanel("Retrieving selected workflow report details, please wait ... ", true);
        this.rpcService.getWfReport(workflowid, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void doLoadWfTemplateToInstanciate(String id) {
        this.display.maskCenterPanel("Retrieving selected workflow template, please wait ... ", true);
        this.rpcService.getWfTemplate(id, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void showAddRoleDialog() {
        if (this.rolesCache == null) {
            this.rpcService.getRoleDetails((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        } else {
            AddRolesDialog dlg = new AddRolesDialog(this.eventBus, this.rolesCache);
            dlg.show();
        }
    }

    public void doAddRolesToSelectedStep(ArrayList<WfRoleDetails> roles) {
        ArrayList<WfRole> rolesFull = new ArrayList<WfRole>();
        for (WfRoleDetails r : roles) {
            rolesFull.add(new WfRole(r.getId(), r.getDisplayName(), ""));
        }
        this.display.addRoleToPermissionTable(rolesFull);
    }

    private void updateStep(Step currStep, WfRole role, boolean value, PermissionType type) {
        Step[] allSteps = this.displayingWorkflow.getSteps();
        int i = 0;
        while (i < allSteps.length) {
            if (allSteps[i].getLabel().compareTo(currStep.getLabel()) == 0) {
                currStep = allSteps[i];
            }
            ++i;
        }
        HashMap ps = currStep.getPermissions();
        if (ps == null) {
            ps = new HashMap();
        }
        if (ps.containsKey(role)) {
            ArrayList<PermissionType> toUpdate = (ArrayList<PermissionType>)ps.get(role);
            if (toUpdate == null) {
                toUpdate = new ArrayList<PermissionType>();
            }
            if (toUpdate.contains(type)) {
                toUpdate.remove(type);
            }
            if (value) {
                toUpdate.add(type);
            }
        } else if (value) {
            ArrayList<PermissionType> toCreate = new ArrayList<PermissionType>();
            toCreate.add(type);
            ps.put(role, toCreate);
        }
        currStep.setPermissions(ps);
    }

    private void doLoadRolesAndUsers() {
        this.display.maskCenterPanel("Loading users from system, pleas wait ... ", true);
        this.rpcService.getVREUsers((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private ArrayList<WfRole> getAllRolesFromTemplate() {
        ArrayList<WfRole> toRet = new ArrayList<WfRole>();
        Step[] steps = this.displayingWorkflow.getSteps();
        int i = 0;
        while (i < steps.length) {
            Step curStep = steps[i];
            if (curStep.getPermissions() != null) {
                GWT.log((String)("step : " + curStep.getLabel()));
                for (WfRole role : curStep.getPermissions().keySet()) {
                    boolean found = false;
                    for (WfRole retRole : toRet) {
                        if (!retRole.getRoleid().equals(role.getRoleid())) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    toRet.add(role);
                }
            }
            ++i;
        }
        return toRet;
    }

    private Step checkAllPermissions() {
        Step[] steps = this.displayingWorkflow.getSteps();
        int i = 0;
        while (i < steps.length) {
            Step curStep = steps[i];
            if (curStep.getPermissions() == null) {
                return curStep;
            }
            ++i;
        }
        return null;
    }

    private void doCommitWfReport() {
        HashMap rolesWithUsers = this.display.getUsersAndRoles();
        HashMap<String, List> rolesWithUsersForService = new HashMap<String, List>();
        for (String roleName : rolesWithUsers.keySet()) {
            ListView list = (ListView)rolesWithUsers.get(roleName);
            list.getSelectionModel().selectAll();
            if (list.getSelectionModel().getSelectedItems().size() == 0) {
                Window.alert((String)"You must select at least a user for each role");
                return;
            }
            rolesWithUsersForService.put(roleName, list.getSelectionModel().getSelectedItems());
        }
        this.display.maskCenterPanel("Saving Workflow, please wait ... ", true);
        String reportName = this.selectedReportName;
        if (reportName.contains(".d4sR")) {
            reportName = this.selectedReportName.substring(0, this.selectedReportName.length() - 5);
        }
        String wfReportName = String.valueOf(reportName) + "-" + this.selecteTemplateName;
        this.rpcService.saveWorkflow(this.selectedReportID, wfReportName, this.displayingWorkflow, rolesWithUsersForService, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void doLoadActionsLog(String workflowid) {
        this.display.maskCenterPanel("Fetching actions log, please wait ... ", true);
        this.rpcService.fetchActionsByWorkflowId(workflowid, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void enableActionButtons(boolean enable) {
        this.display.getDetailsButton().setEnabled(enable);
        this.display.getActionsLogButton().setEnabled(enable);
        this.display.getDeleteButton().setEnabled(enable);
    }

    private void doDeleteWfReport(WfDocumentBean docBean) {
        this.display.maskCenterPanel("Deleting workflow documente, please wait ... ", true);
        this.rpcService.deleteWorkflowDocument(docBean, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    static /* synthetic */ void access$0(WorkflowDocsPresenter workflowDocsPresenter, boolean bl) {
        workflowDocsPresenter.enableActionButtons(bl);
    }

    static /* synthetic */ Display access$1(WorkflowDocsPresenter workflowDocsPresenter) {
        return workflowDocsPresenter.display;
    }

    static /* synthetic */ void access$2(WorkflowDocsPresenter workflowDocsPresenter, WfDocumentBean wfDocumentBean) {
        workflowDocsPresenter.doDeleteWfReport(wfDocumentBean);
    }

    static /* synthetic */ void access$3(WorkflowDocsPresenter workflowDocsPresenter, String string, String string2) {
        workflowDocsPresenter.doLoadWfReport(string, string2);
    }

    static /* synthetic */ Step access$4(WorkflowDocsPresenter workflowDocsPresenter) {
        return workflowDocsPresenter.checkAllPermissions();
    }

    static /* synthetic */ void access$5(WorkflowDocsPresenter workflowDocsPresenter) {
        workflowDocsPresenter.doLoadRolesAndUsers();
    }

    static /* synthetic */ void access$6(WorkflowDocsPresenter workflowDocsPresenter, String string) {
        workflowDocsPresenter.doLoadActionsLog(string);
    }

    static /* synthetic */ void access$7(WorkflowDocsPresenter workflowDocsPresenter) {
        workflowDocsPresenter.doCommitWfReport();
    }

    static /* synthetic */ void access$8(WorkflowDocsPresenter workflowDocsPresenter, String string) {
        workflowDocsPresenter.selectedReportID = string;
    }

    static /* synthetic */ void access$9(WorkflowDocsPresenter workflowDocsPresenter, String string) {
        workflowDocsPresenter.selectedReportName = string;
    }

    static /* synthetic */ HandlerManager access$10(WorkflowDocsPresenter workflowDocsPresenter) {
        return workflowDocsPresenter.eventBus;
    }

    static /* synthetic */ String access$11(WorkflowDocsPresenter workflowDocsPresenter) {
        return workflowDocsPresenter.selectedReportID;
    }

    static /* synthetic */ String access$12(WorkflowDocsPresenter workflowDocsPresenter) {
        return workflowDocsPresenter.selectedReportName;
    }

    static /* synthetic */ void access$13(WorkflowDocsPresenter workflowDocsPresenter, String string) {
        workflowDocsPresenter.selecteTemplateName = string;
    }

    static /* synthetic */ void access$14(WorkflowDocsPresenter workflowDocsPresenter, String string) {
        workflowDocsPresenter.doLoadWfTemplateToInstanciate(string);
    }

    static /* synthetic */ void access$15(WorkflowDocsPresenter workflowDocsPresenter, Step step, WfRole wfRole, boolean bl, PermissionType permissionType) {
        workflowDocsPresenter.updateStep(step, wfRole, bl, permissionType);
    }

    static /* synthetic */ void access$16(WorkflowDocsPresenter workflowDocsPresenter, WfGraph wfGraph) {
        workflowDocsPresenter.displayingWorkflow = wfGraph;
    }

    static /* synthetic */ void access$17(WorkflowDocsPresenter workflowDocsPresenter) {
        workflowDocsPresenter.showAddRoleDialog();
    }

    static /* synthetic */ void access$18(WorkflowDocsPresenter workflowDocsPresenter, ArrayList arrayList) {
        workflowDocsPresenter.rolesCache = arrayList;
    }

    static /* synthetic */ ArrayList access$19(WorkflowDocsPresenter workflowDocsPresenter) {
        return workflowDocsPresenter.getAllRolesFromTemplate();
    }

    static /* synthetic */ void access$20(WorkflowDocsPresenter workflowDocsPresenter) {
        workflowDocsPresenter.fetchWfDocumentsDetails();
    }
}

