/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.vredefinition.client.presenter;

import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.MessageBox;
import com.extjs.gxt.ui.client.widget.treepanel.TreePanel;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.gcube.portlets.admin.vredefinition.client.VREDefinitionServiceAsync;
import org.gcube.portlets.admin.vredefinition.client.model.VREDefinitionModel;
import org.gcube.portlets.admin.vredefinition.client.model.VREFunctionalityModel;
import org.gcube.portlets.admin.vredefinition.client.presenter.Presenter;
import org.gcube.portlets.admin.vredefinition.client.presenter.VREFunctionalitiesPresenter;

public class VREFunctionalitiesPresenter
implements Presenter {
    private final VREDefinitionServiceAsync rpcService;
    private final Display display;
    private final VREDefinitionModel vreModel;
    private LayoutContainer container;
    private final HandlerManager eventBus;

    public VREFunctionalitiesPresenter(VREDefinitionServiceAsync rpcService, VREDefinitionModel vreModel, HandlerManager eventBus, Display display) {
        this.display = display;
        this.rpcService = rpcService;
        this.vreModel = vreModel;
        this.eventBus = eventBus;
    }

    public void bind() {
        this.display.getTreeFunctionalities().addListener(Events.OnClick, (Listener)new /* Unavailable Anonymous Inner Class!! */);
    }

    public boolean doSave() {
        TreePanel items = this.display.getTreeFunctionalities();
        for (ModelData item : items.getStore().getAllItems()) {
            item.set("isSelected", (Object)false);
        }
        for (ModelData item : items.getCheckedSelection()) {
            item.set("isSelected", (Object)true);
        }
        this.vreModel.setVREFunctionalities(items.getStore().getRootItems());
        return this.validateVREFunctionalitiesSelected();
    }

    private boolean validateVREFunctionalitiesSelected() {
        List categories = this.vreModel.getVREFunctionalities();
        boolean check = false;
        block0: for (ModelData category : categories) {
            for (ModelData func : ((VREFunctionalityModel)category).getChildren()) {
                if (!((VREFunctionalityModel)func).isSelected()) continue;
                check = true;
                continue block0;
            }
        }
        if (!check) {
            MessageBox.alert((String)"Alert", (String)"Please, select at least one Functionality", null);
        }
        return check;
    }

    public void go(LayoutContainer container) {
        this.container = container;
        container.removeAll();
        container.add(this.display.asWidget());
        container.layout();
        if (this.vreModel.getVREFunctionalities() == null) {
            this.fetchFunctionalities();
            container.mask("Loading data...", "loading-indicator");
        } else {
            this.display.setData(this.vreModel.getVREFunctionalities());
            this.bind();
        }
    }

    private void fetchFunctionalities() {
        this.rpcService.getFunctionality(false, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public Widget display() {
        return this.display.asWidget();
    }

    static /* synthetic */ HandlerManager access$0(VREFunctionalitiesPresenter vREFunctionalitiesPresenter) {
        return vREFunctionalitiesPresenter.eventBus;
    }

    static /* synthetic */ LayoutContainer access$1(VREFunctionalitiesPresenter vREFunctionalitiesPresenter) {
        return vREFunctionalitiesPresenter.container;
    }

    static /* synthetic */ Display access$2(VREFunctionalitiesPresenter vREFunctionalitiesPresenter) {
        return vREFunctionalitiesPresenter.display;
    }
}

