package org.gcube.portlets.admin.software_upload_wizard.server.rpc.handlers;

import org.gcube.portlets.admin.software_upload_wizard.server.importmanagers.ImportSessionManager;
import org.gcube.portlets.admin.software_upload_wizard.server.logging.InjectLogger;
import org.gcube.portlets.admin.software_upload_wizard.shared.rpc.SetThirdParty;
import org.gcube.portlets.admin.software_upload_wizard.shared.rpc.SetThirdPartyResult;
import org.slf4j.Logger;

import com.google.inject.Inject;

import net.customware.gwt.dispatch.server.ActionHandler;
import net.customware.gwt.dispatch.server.ExecutionContext;
import net.customware.gwt.dispatch.shared.ActionException;
import net.customware.gwt.dispatch.shared.DispatchException;

public class SetThirdPartyHandler implements ActionHandler<SetThirdParty, SetThirdPartyResult> {

	@InjectLogger
	private Logger logger;
	
	ImportSessionManager importSessionManager;
	
	@Inject
	public SetThirdPartyHandler(ImportSessionManager importSessionManager) {
		super();
		this.importSessionManager = importSessionManager;
	}

	@Override
	public Class<SetThirdParty> getActionType() {
		return SetThirdParty.class;
	}

	@Override
	public SetThirdPartyResult execute(SetThirdParty action,
			ExecutionContext context) throws DispatchException {
		try {
			boolean thirdParty = action.isThirdParty();
			logger.trace("Setting third party value: " + thirdParty);
			importSessionManager.getImportSession().getServiceProfile()
					.setThirdPartySoftware(thirdParty);
			return new SetThirdPartyResult(thirdParty);
		} catch (Exception e) {
			logger.error("Error while executing " + this.getClass().getName() +":\n" + e.toString());
			throw new ActionException(e);
		}
	}

	@Override
	public void rollback(SetThirdParty action, SetThirdPartyResult result,
			ExecutionContext context) throws DispatchException {
		//TODO Implement rollback operations 
	}

}
