package org.gcube.portlets.admin.software_upload_wizard.server.logging.slf4j;

import java.lang.reflect.Field;

import org.slf4j.Logger;
import org.slf4j.impl.GCubeClientLogAdapter;

import com.google.inject.MembersInjector;

public class Slf4jMemberInjector<I> implements MembersInjector<I> {

	private final Field field;
	private final Logger logger;
	
	public Slf4jMemberInjector(Field field) {
		this.field = field;
//		this.logger = LoggerFactory.getLogger(field.getDeclaringClass());
		this.logger = new GCubeClientLogAdapter(field.getDeclaringClass());
		field.setAccessible(true);
	}
	
	@Override
	public void injectMembers(I arg0) {
		try {
			field.set(arg0, logger);
		} catch (IllegalAccessException e) {
			throw new RuntimeException(e);
		}
	}

}
