package org.gcube.portlets.admin.software_upload_wizard.server.softwaremanagers.softwaregateway;

import org.apache.commons.lang.StringUtils;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.portlets.admin.software_upload_wizard.server.logging.InjectLogger;
import org.slf4j.Logger;

import com.google.inject.Inject;

public class VOSoftwareGatewayRegistrationManager implements
		ISoftwareGatewayRegistrationManager {

	ISoftwareGatewayRegistrationManager decoratedSGRegistrationManager;

	@InjectLogger
	Logger logger;

	@Inject
	public VOSoftwareGatewayRegistrationManager(
			@DefaultSG ISoftwareGatewayRegistrationManager decoratedSGRegistrationManager) {
		super();
		this.decoratedSGRegistrationManager = decoratedSGRegistrationManager;
	}

	@Override
	public void registerProfile(String serviceProfileContent, GCUBEScope scope)
			throws Exception {
		int charMatches = StringUtils.countMatches(scope.toString(), "/");
		logger.trace("Modifing scope \"" + scope.toString()
				+ "\" according to SG rules.");
		if (charMatches == 0 || charMatches > 3)
			throw new Exception("Software gateway cannot accept scope: "
					+ scope.toString());
		GCUBEScope newScope = null;
		if (charMatches > 0 && charMatches < 3) {
			logger.debug("Scope does not need to be modified");
			newScope = scope;
		}else if (charMatches == 3) {
			newScope = GCUBEScope.getScope(scope.toString().substring(0,
					scope.toString().lastIndexOf("/")));
			logger.debug("Scope modification applied: '" + scope.toString() + "'"
					+ " --> '" + newScope.toString() + "'");
		}
		decoratedSGRegistrationManager.registerProfile(serviceProfileContent,
				newScope);
	}
}
