/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.resourcemanagement.support.server.managers.resources;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.gcube.common.resources.gcore.Resource;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.common.scope.impl.ScopeBean;
import org.gcube.informationsystem.publisher.AdvancedPublisher;
import org.gcube.informationsystem.publisher.RegistryPublisher;
import org.gcube.informationsystem.publisher.RegistryPublisherFactory;
import org.gcube.resourcemanagement.support.server.exceptions.AbstractResourceException;
import org.gcube.resourcemanagement.support.server.exceptions.ResourceAccessException;
import org.gcube.resourcemanagement.support.server.exceptions.ResourceOperationException;
import org.gcube.resourcemanagement.support.server.exceptions.ResourceParameterException;
import org.gcube.resourcemanagement.support.server.managers.report.ReportBuilder;
import org.gcube.resourcemanagement.support.server.managers.report.ReportEntry;
import org.gcube.resourcemanagement.support.server.managers.report.ReportOperation;
import org.gcube.resourcemanagement.support.server.types.AllowedResourceTypes;
import org.gcube.resourcemanagement.support.server.utils.Assertion;
import org.gcube.resourcemanagement.support.server.utils.ServerConsole;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.QueryBox;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.gcube.vremanagement.resourcemanager.client.RMBinderLibrary;
import org.gcube.vremanagement.resourcemanager.client.RMReportingLibrary;
import org.gcube.vremanagement.resourcemanager.client.fws.Types;
import org.gcube.vremanagement.resourcemanager.client.proxies.Proxies;

public abstract class AbstractResourceManager {
    private String id = null;
    private String name = null;
    private AllowedResourceTypes type = null;
    private String subType = null;
    private RegistryPublisher publisher = null;
    private static final String LOG_PREFIX = "[AbstractResMgr]";

    public AbstractResourceManager(AllowedResourceTypes type) throws ResourceParameterException, ResourceAccessException {
        Assertion<ResourceParameterException> checker = new Assertion<ResourceParameterException>();
        checker.validate(type != null, new ResourceParameterException("Invalid Parameter type"));
        this.type = type;
        try {
            this.publisher = RegistryPublisherFactory.create();
        }
        catch (Exception e) {
            ServerConsole.error(LOG_PREFIX, e);
        }
    }

    public AbstractResourceManager(String id, AllowedResourceTypes type) throws ResourceParameterException, ResourceAccessException {
        this(type);
        Assertion<ResourceParameterException> checker = new Assertion<ResourceParameterException>();
        checker.validate(id != null && id.trim().length() > 0, new ResourceParameterException("Invalid Parameter id"));
        this.id = id.trim();
    }

    public AbstractResourceManager(String id, String name, AllowedResourceTypes type) throws ResourceParameterException, ResourceAccessException {
        this(id, type);
        Assertion<ResourceParameterException> checker = new Assertion<ResourceParameterException>();
        checker.validate(name != null && name.trim().length() > 0, new ResourceParameterException("Invalid Parameter name"));
        this.name = name;
    }

    public AbstractResourceManager(String id, String name, AllowedResourceTypes type, String subtype) throws ResourceParameterException, ResourceAccessException {
        this(id, name, type);
        if (subtype != null) {
            this.subType = subtype.trim();
        }
    }

    public final RegistryPublisher getRegistryPublisher() {
        return this.publisher;
    }

    public final String getID() {
        return this.id;
    }

    public final void setID(String id) {
        this.id = id;
    }

    public final String getName() {
        return this.name;
    }

    public final AllowedResourceTypes getType() {
        return this.type;
    }

    public final String getSubType() {
        return this.subType;
    }

    public final RMBinderLibrary getResourceManager(String scope) throws AbstractResourceException {
        ScopeBean bscope = new ScopeBean(scope);
        if (bscope.is(ScopeBean.Type.VRE)) {
            scope = bscope.enclosingScope().toString();
        }
        ScopeProvider.instance.set(scope);
        ServerConsole.info(LOG_PREFIX, "Getting Resource Manager in scope [" + scope.toString() + "]");
        RMBinderLibrary rml = (RMBinderLibrary)Proxies.binderService().build();
        if (rml == null) {
            throw new ResourceAccessException("Unable to find ResourceManagers for resource " + (Object)((Object)this.getType()) + " in scope: " + scope.toString());
        }
        return rml;
    }

    public final RMReportingLibrary getReportResourceManager(String scope) throws AbstractResourceException {
        ScopeBean bscope = new ScopeBean(scope);
        if (bscope.is(ScopeBean.Type.VRE)) {
            scope = bscope.enclosingScope().toString();
        }
        ScopeProvider.instance.set(scope);
        ServerConsole.info(LOG_PREFIX, "Getting Resource Manager in scope [" + scope.toString() + "]");
        RMReportingLibrary rml = (RMReportingLibrary)Proxies.reportingService().build();
        if (rml == null) {
            throw new ResourceAccessException("Unable to find ResourceManagers for resource " + (Object)((Object)this.getType()) + " in scope: " + scope.toString());
        }
        return rml;
    }

    private String bindToScope(String targetScope) throws AbstractResourceException {
        Assertion<AbstractResourceException> checker = new Assertion<AbstractResourceException>();
        checker.validate(targetScope != null, new ResourceParameterException("Invalid parameter targetScope. null not allowed."));
        checker.validate(this.getID() != null, new ResourceOperationException("Invalid resource ID. null not allowed."));
        ServerConsole.trace(LOG_PREFIX, "[BIND-SCOPE-ENTER] Adding " + (Object)((Object)this.getType()) + " " + this.getID() + " to scope [" + targetScope.toString() + "]");
        System.out.println("***\n\n[BIND-SCOPE-ENTER] Adding " + (Object)((Object)this.getType()) + " " + this.getID() + " to scope [" + targetScope.toString() + "]");
        String curr = ScopeProvider.instance.get();
        ScopeProvider.instance.set(targetScope.toString());
        Types.AddResourcesParameters addParam = new Types.AddResourcesParameters();
        Types.ResourceItem toAdd = new Types.ResourceItem();
        toAdd.setId(this.getID());
        toAdd.setType(this.getType().name());
        Types.ResourceList r = new Types.ResourceList();
        ArrayList<Types.ResourceItem> temp = new ArrayList<Types.ResourceItem>();
        temp.add(toAdd);
        r.setResource(temp);
        addParam.setResources(r);
        addParam.setTargetScope(targetScope.toString());
        RMBinderLibrary manager = this.getResourceManager(targetScope);
        try {
            ScopeBean scope = new ScopeBean(targetScope);
            if (scope.is(ScopeBean.Type.VRE)) {
                ScopeProvider.instance.set(scope.enclosingScope().toString());
            } else {
                ScopeProvider.instance.set(targetScope);
            }
            System.out.println("***\n\nCalling manager.addResources(addParam) addParam.toString()=" + addParam.toString());
            String reportID = manager.addResources(addParam);
            ServerConsole.trace(LOG_PREFIX, "[BIND-SCOPE-EXIT] Applyed Adding " + (Object)((Object)this.getType()) + " " + this.getID() + " to scope [" + targetScope.toString() + "]... reportID: " + reportID);
            System.out.println("***\n\n[BIND-SCOPE-EXIT] Applyed Adding " + (Object)((Object)this.getType()) + " " + this.getID() + " to scope [" + targetScope.toString() + "]... reportID: " + reportID);
            RMReportingLibrary pt = this.getReportResourceManager(scope.toString());
            String toReturn = pt.getReport(reportID);
            ScopeProvider.instance.set(curr);
            return toReturn;
        }
        catch (Exception e) {
            e.printStackTrace();
            ServerConsole.trace(LOG_PREFIX, "[BIND-SCOPE-EXIT] [FAILURE]");
            System.out.println("***[BIND-SCOPE-EXIT] [FAILURE]" + e.getMessage());
            throw new ResourceOperationException("During resource::addToScope: " + targetScope + " Message: \n" + e.getMessage());
        }
    }

    public final String addToExistingScope(ScopeBean sourceScope, ScopeBean targetScope) throws AbstractResourceException {
        Assertion<AbstractResourceException> checker = new Assertion<AbstractResourceException>();
        checker.validate(sourceScope != null, new ResourceParameterException("Invalid parameter sourceScope. null not allowed."));
        checker.validate(targetScope != null, new ResourceParameterException("Invalid parameter targetScope. null not allowed."));
        checker.validate(this.getID() != null, new ResourceOperationException("Invalid resource ID. null not allowed."));
        String curr = ScopeProvider.instance.get();
        ScopeProvider.instance.set(sourceScope.toString());
        ReportBuilder report = new ReportBuilder();
        ServerConsole.trace(LOG_PREFIX, "[ADD-ToExistingScope] Adding from scope [" + sourceScope.toString() + "] to existing scope [" + targetScope.toString() + "] " + (Object)((Object)this.getType()) + " " + this.getID());
        if (this.getType() != AllowedResourceTypes.GHN && this.getType() != AllowedResourceTypes.RunningInstance && sourceScope.type() == ScopeBean.Type.VO && targetScope.type() == ScopeBean.Type.VO) {
            return this.copyFromToVO(sourceScope, targetScope);
        }
        if (!targetScope.toString().contains(sourceScope.toString())) {
            throw new ResourceOperationException("You are not allowed to apply to this scope. Target scope is not enclosed in the source one.");
        }
        report.addEntry(new ReportEntry(ReportOperation.AddToScope, this, "Added " + (Object)((Object)this.getType()) + " " + this.getID() + " to parent scope " + targetScope.toString() + " the remote report ID is: " + this.bindToScope(targetScope.toString()), true));
        String toReturn = report.getXML();
        ScopeProvider.instance.set(curr);
        return toReturn;
    }

    public final String copyFromToVO(ScopeBean sourceScope, ScopeBean targetScope) throws AbstractResourceException {
        Assertion<AbstractResourceException> checker = new Assertion<AbstractResourceException>();
        checker.validate(sourceScope != null && sourceScope.type() == ScopeBean.Type.VO, new ResourceParameterException("The sourceScope is invalid or not of type VO."));
        checker.validate(targetScope != null && targetScope.type() == ScopeBean.Type.VO, new ResourceParameterException("The targetScope is invalid or not of type VO."));
        checker.validate(sourceScope.enclosingScope() == targetScope.enclosingScope(), new ResourceParameterException("The sourceScope and targetScope must be children of the same root VO."));
        checker.validate(this.getType() != AllowedResourceTypes.GHN && this.getType() != AllowedResourceTypes.RunningInstance, new ResourceAccessException("Operation not allowed for RI and GHNs."));
        checker.validate(this.getID() != null, new ResourceAccessException("Operation not allowed on resources with no ID."));
        Resource resStub = this.getResource(sourceScope);
        this.bindToScope(targetScope.toString());
        String currentScope = ScopeProvider.instance.get();
        ScopeProvider.instance.set(targetScope.toString());
        Resource toReturn = null;
        try {
            toReturn = this.getRegistryPublisher().create(resStub);
        }
        catch (Exception e) {
            throw new ResourceAccessException(e.getMessage());
        }
        ScopeProvider.instance.set(currentScope);
        return toReturn.id();
    }

    protected abstract Resource buildResource(String var1) throws AbstractResourceException;

    public final Resource getResource(ScopeBean scope) throws AbstractResourceException {
        return this.buildResource(this.getXMLDescription(scope));
    }

    protected final String getXMLDescription(ScopeBean scope) throws AbstractResourceException {
        Assertion<ResourceAccessException> checker = new Assertion<ResourceAccessException>();
        checker.validate(this.getID() != null, new ResourceAccessException("Cannot execute on resources with no ID."));
        ScopeProvider.instance.set(scope.toString());
        QueryBox query = new QueryBox("for  $resource in  collection('/db/Profiles/" + this.getType().name() + "')//Resource where ( $resource/ID/string() eq '" + this.getID() + "') return $resource");
        DiscoveryClient client = ICFactory.client();
        List results = client.submit((Query)query);
        if (results == null || results.isEmpty()) {
            throw new ResourceAccessException("Cannot retrieve the IS profile for resource: " + this.getID() + " in scope: " + scope.toString());
        }
        return ((String)results.get(0)).toString();
    }

    private String basicRemoveFromScope(ScopeBean scope) throws AbstractResourceException {
        Assertion<AbstractResourceException> checker = new Assertion<AbstractResourceException>();
        checker.validate(scope != null, new ResourceParameterException("Invalid parameter scope. null not allowed."));
        checker.validate(this.getID() != null, new ResourceOperationException("Invalid ID. null not allowed."));
        ServerConsole.trace(LOG_PREFIX, "[REMOVE-FROM-SCOPE] Removing from scope [" + scope.toString() + "] " + (Object)((Object)this.getType()) + " " + this.getID());
        String retval = null;
        Types.RemoveResourcesParameters params = new Types.RemoveResourcesParameters();
        Types.ResourceItem toRemove = new Types.ResourceItem();
        toRemove.setId(this.getID());
        toRemove.setType(this.getType().name());
        Types.ResourceList resourcesToRemove = new Types.ResourceList();
        ArrayList<Types.ResourceItem> temp = new ArrayList<Types.ResourceItem>();
        temp.add(toRemove);
        resourcesToRemove.setResource(temp);
        params.resources = resourcesToRemove;
        params.targetScope = scope.toString();
        ServerConsole.trace(LOG_PREFIX, "[REMOVE-FROM-SCOPE] Sending the Remove Resource request....");
        try {
            RMBinderLibrary manager = this.getResourceManager(scope.toString());
            ScopeProvider.instance.set(scope.toString());
            retval = manager.removeResources(params);
        }
        catch (Exception e) {
            throw new ResourceOperationException("During removeFrom scope of " + (Object)((Object)this.getType()) + " " + this.getID() + ": " + e.getMessage());
        }
        return retval;
    }

    public final String removeFromScope(ScopeBean scope) throws AbstractResourceException {
        ServerConsole.trace(LOG_PREFIX, "[BASIC-FROM-SCOPE] Removing from scope [" + scope.toString() + "] " + (Object)((Object)this.getType()) + " " + this.getID());
        Assertion<AbstractResourceException> checker = new Assertion<AbstractResourceException>();
        checker.validate(scope != null, new ResourceParameterException("Invalid parameter scope. null not allowed."));
        checker.validate(this.getID() != null, new ResourceOperationException("Invalid ID. null not allowed."));
        ScopeProvider.instance.set(scope.toString());
        String retval = this.basicRemoveFromScope(scope);
        return retval;
    }

    protected List<ScopeBean> validateScopes(String[] scopes) {
        Vector<ScopeBean> retval = new Vector<ScopeBean>();
        for (int i = 0; i < scopes.length; ++i) {
            retval.add(new ScopeBean(scopes[i]));
        }
        return retval;
    }

    public final void forceDelete(ScopeBean scope) throws AbstractResourceException {
        ServerConsole.trace(LOG_PREFIX, "[FORCE DELETE] [DELETE-BRANCH] deleting resource from scope " + scope);
        String currScope = ScopeProvider.instance.get();
        Resource toDelete = this.getResource(scope);
        while (scope.enclosingScope() != null) {
            scope = scope.enclosingScope();
        }
        ScopeProvider.instance.set(scope.toString());
        AdvancedPublisher advancedPublisher = new AdvancedPublisher(this.getRegistryPublisher());
        advancedPublisher.forceRemove(toDelete);
        ServerConsole.trace(LOG_PREFIX, "[FORCE DELETE] [DELETE-BRANCH] deleted resource from scope " + scope);
        ScopeProvider.instance.set(currScope);
    }

    public final String delete(ScopeBean scope) throws AbstractResourceException {
        Assertion<AbstractResourceException> checker = new Assertion<AbstractResourceException>();
        checker.validate(scope != null, new ResourceParameterException("Invalid parameter scope. null not allowed."));
        checker.validate(this.getID() != null, new ResourceOperationException("Invalid ID. null not allowed."));
        System.out.println("DELETING TYPE: " + (Object)((Object)this.getType()));
        String currScope = ScopeProvider.instance.get();
        ScopeProvider.instance.set(scope.toString());
        Resource resStub = this.getResource(scope);
        List<ScopeBean> boundedScopes = this.validateScopes((String[])resStub.scopes().toArray((Object[])new String[0]));
        ServerConsole.trace(LOG_PREFIX, "[DELETE] " + (Object)((Object)this.getType()) + " " + this.getID() + " in scope [" + scope + "]");
        ServerConsole.trace(LOG_PREFIX, "[DELETE] " + (Object)((Object)this.getType()) + " " + this.getID() + " is bound to (" + boundedScopes.size() + ") scopes");
        String toReturn = "";
        if (boundedScopes.size() > 1) {
            ServerConsole.trace(LOG_PREFIX, "[DELETE] [DELETE-BRANCH] deleting resource is a remove from scope since more than 1 scope is present " + resStub.id());
            toReturn = this.basicRemoveFromScope(scope);
        } else if (boundedScopes.size() == 1) {
            ServerConsole.trace(LOG_PREFIX, "[DELETE] [DELETE-BRANCH] deleting resource since is bound to 1 scope only " + resStub.id());
            try {
                this.getRegistryPublisher().remove(resStub);
                toReturn = "NO REPORT because with only one resource the RegistryPublisher().remove was called";
            }
            catch (Exception e) {
                ScopeProvider.instance.set(currScope);
            }
        }
        ScopeProvider.instance.set(currScope);
        return toReturn;
    }
}

