/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.resourcemanagement.support.server.tests;

import java.io.File;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.gcube.common.resources.gcore.HostingNode;
import org.gcube.common.resources.gcore.Resource;
import org.gcube.common.resources.gcore.utils.XPathHelper;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.common.scope.impl.ScopeBean;
import org.gcube.resourcemanagement.support.server.gcube.CacheManager;
import org.gcube.resourcemanagement.support.server.gcube.ISClientRequester;
import org.gcube.resourcemanagement.support.server.managers.resources.GHNManager;
import org.gcube.resourcemanagement.support.server.managers.resources.GenericResourceManager;
import org.gcube.resourcemanagement.support.server.managers.resources.ManagementUtils;
import org.gcube.resourcemanagement.support.server.managers.scope.ScopeManager;
import org.gcube.resourcemanagement.support.server.types.AllowedResourceTypes;
import org.gcube.resourcemanagement.support.server.utils.ServerConsole;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class GenericTest {
    private static final String LOG_PREFIX = "[SW-SUPPORT-TEST]";

    public static String testCreation() {
        System.out.println("\n\n\n******************** TEST CREATION ***************");
        String resID = null;
        try {
            resID = GenericResourceManager.create(null, new ScopeBean("/gcube/devsec"), "RMP Test " + new Date(), "RMP Test Description", "Hello", "test");
            ServerConsole.trace(null, "Generic Resource Created with ID: " + resID);
        }
        catch (Exception e) {
            ServerConsole.error(LOG_PREFIX, e);
        }
        finally {
            System.out.println("\n******************** TEST CREATION END ***************\n");
        }
        return resID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void testScopeCopy(String resID, String fromScope, String toScope) {
        System.out.println("\n\n\n******************** TEST SCOPE COPY ***************");
        try {
            String[] ids = new String[]{resID};
            ManagementUtils.addToExistingScope(AllowedResourceTypes.GenericResource, ids, new ScopeBean(fromScope), new ScopeBean(toScope));
        }
        catch (Exception e) {
            ServerConsole.error(LOG_PREFIX, e);
        }
        finally {
            System.out.println("\n******************** TEST SCOPE COPY END ***************\n");
        }
    }

    public static void testResourceEdit(String resID, ScopeBean scope) {
        System.out.println("\n\n\n******************** TEST RESEDIT COPY ***************");
        try {
            GenericResourceManager res = new GenericResourceManager(resID);
            res.update(res.getName() + " Edited", "updated description", "<update>updated body</update>", "test2", scope);
        }
        catch (Exception e) {
            ServerConsole.error(LOG_PREFIX, e);
        }
        finally {
            System.out.println("\n******************** TEST RESEDIT END ***************\n");
        }
    }

    public static void testModeGHN(String resID, String scope) throws Exception {
        ScopeBean queryScope = new ScopeBean(scope);
        GHNManager ghnManager = new GHNManager(resID);
        HostingNode res = (HostingNode)ghnManager.getResource(queryScope);
        res.profile().description().status("CERTIFIED");
        ScopeProvider.instance.set(queryScope.name());
        ghnManager.getRegistryPublisher().update((Resource)res);
    }

    public static void testGHN() {
        System.out.println("\n\n\n******************** TEST GHN ***************");
        try {
            GHNManager ghn1 = new GHNManager("796f0680-3937-11e2-9d5f-ae6a92affb51", "pcd4science3.cern.ch");
            ghn1.addToExistingScope(new ScopeBean("/gcube"), new ScopeBean("/gcube/devsec"));
        }
        catch (Exception e) {
            ServerConsole.error(LOG_PREFIX, e);
        }
        finally {
            System.out.println("\n******************** TEST GHN END ***************\n");
        }
    }

    public static void testRemoveFromScope(String resID, ScopeBean scope) {
        System.out.println("\n\n\n******************** TEST RESOURCE REMOVEFROMSCOPE ***************");
        try {
            GenericResourceManager res = new GenericResourceManager(resID);
            res.removeFromScope(scope);
        }
        catch (Exception e) {
            ServerConsole.error(LOG_PREFIX, e);
        }
        finally {
            System.out.println("\n******************** TEST RESOURCE REMOVEFROMSCOPE END ***************\n");
        }
    }

    public static void testDelete(String resID, ScopeBean scope) {
        System.out.println("\n\n\n******************** TEST RESOURCE DELETE ***************");
        try {
            GenericResourceManager res = new GenericResourceManager(resID);
            res.delete(scope);
        }
        catch (Exception e) {
            ServerConsole.error(LOG_PREFIX, e);
        }
        finally {
            System.out.println("\n******************** TEST RESOURCE DELETE END ***************\n");
        }
    }

    private static void testTree(ScopeBean scope) throws Exception {
        CacheManager cm = new CacheManager();
        cm.setUseCache(false);
        HashMap<String, ArrayList<String>> results = ISClientRequester.getResourcesTree(cm, scope);
        for (String res : results.keySet()) {
            System.out.println(res);
            for (String sub : results.get(res)) {
                System.out.println(sub);
            }
        }
        List<String> descs = ISClientRequester.getResourcesByType(cm, scope, "GenericResource", "VRE");
        for (String resourceDescriptor : descs) {
            DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Element node = docBuilder.parse(new InputSource(new StringReader(resourceDescriptor))).getDocumentElement();
            XPathHelper helper = new XPathHelper((Node)node);
            System.out.println((String)helper.evaluate("/Resource/Name/text()").get(0));
        }
    }

    public static void main(String[] args) throws Exception {
        ScopeManager.setScopeConfigFile("test-suite" + File.separator + "scopes" + File.separator + "scopedata_admin.xml");
        ScopeProvider.instance.set("/gcube/devsec");
        GenericTest.testTree(new ScopeBean("/gcube/devsec"));
    }
}

