<!-- 
   RES_SUBTYPE subtype parameters can be passed by expressing:
    
        where $subtype = "TheSubType" and $wsresource/Data//child::*[local-name()='Type'][0]/string() eq 'gDocRead'
 -->

for $profiles in collection('/db/Profiles/GenericResource')//Resource,  $wsresource in collection('/db/Properties')//Document 
let $scopes := string-join( $profiles/Scopes//Scope/text(), ';')
let $subtype := $profiles//Resource/Profile/SecondaryType/text()
where $subtype = "DataSource" and $profiles//Resource/ID eq $wsresource/SourceKey and $wsresource/Data//child::*[local-name()='ServiceName']/string() eq 'tree-manager-service'
<RES_SUBTYPE ISdefault =''/> 
    return 
    <Resource>
        {$profiles//Resource/ID}
        <Type>{$profiles//Resource/Type/text()}</Type>
        <SubType>{$subtype}</SubType>
        <Scopes>{$scopes}</Scopes>
        <Name>{$profiles//Resource/Profile/Name/text()}</Name>
        <CreationTime>{$profiles//Resource/Profile/Body/SourceProperties/creationTime/text()}</CreationTime>
        <UserCollection>{$profiles//Resource/Profile/Body/SourceProperties/user/text()}</UserCollection>
        <LastUpdateTime>{$wsresource/LastUpdateHuman/text()}</LastUpdateTime>
        <NumberOfMembers>{$wsresource//child::*[local-name()='Cardinality']/text()}</NumberOfMembers>
    </Resource>    