/****************************************************************************
 *  This software is part of the gCube Project.
 *  Site: http://www.gcube-system.org/
 ****************************************************************************
 * The gCube/gCore software is licensed as Free Open Source software
 * conveying to the EUPL (http://ec.europa.eu/idabc/eupl).
 * The software and documentation is provided by its authors/distributors
 * "as is" and no expressed or
 * implied warranty is given for its use, quality or fitness for a
 * particular case.
 ****************************************************************************
 * Filename: QueryLocator.java
 ****************************************************************************
 * @author <a href="mailto:daniele.strollo@isti.cnr.it">Daniele Strollo</a>
 ***************************************************************************/

package org.gcube.resourcemanagement.support.server.gcube.queries;

import java.io.InputStream;

/**
 * Keeps the association between an xquery and the path
 * on which it can be retrieved.
 * @author Daniele Strollo 
 * @author Massimiliano Assante (ISTI-CNR)
 */
public enum QueryLocation {
	// These two queries are needed to build the tree of resource types and subtypes
	// for resources different from wsresources.
	GET_TREE_TYPES("getTypes.xq"),
	GET_TREE_SUBTYPES("getSubTypes.xq"),

	// Customized queries to retrieve the relevant data from resources
	// according to their type
	LIST_GHN("resources/GHN.xq"),
	LIST_Collection("resources/Collection.xq"),
	LIST_VIEW("resources/VIEW.xq"),
	LIST_Service("resources/Service.xq"),
	LIST_GenericResource("resources/GenericResource.xq"),
	LIST_RunningInstance("resources/RunningInstance.xq"),
	LIST_RuntimeResource("resources/RuntimeResource.xq"),

	// To retrieve the list of generic resources publishing plugins
	// to deploy activation records
	GET_GENERIC_RESOURCE_PLUGINS("getPlugins.xq"),
	
	// to deploy activation records for Tree manager
	GET_GENERIC_RESOURCE_TREE_MANAGER_PLUGINS("getTreeManagerPlugins.xq"),

	// Related resources
	LIST_RELATED_GHN("related/GHN.xq"),
	LIST_RELATED_RunningInstance("related/RunningInstance.xq"),
	LIST_RELATED_Service("related/Service.xq"),

	// Queries for sweeper
	SWEEPER_EXPIRED_GHN("sweeper/expiredGhns.xq"),
	SWEEPER_DEAD_GHN("sweeper/deadGhns.xq"),
	SWEEPER_ORPHAN_RI("sweeper/orphanRI.xq"),

	// Used to build the gwt model representation inside dialogs.
	// see getResourceModels inside ISClientRequester.
	GET_RES_DETAILS_BYTYPE("getResourcesDetails.xq"),
	GET_RES_DETAILS_BYSUBTYPE("getResourcesDetailsSubtype.xq"),

	GET_RESOURCE_BYID("getResourceByID.xq"),
	GET_WSRES_TYPES("getWSResourcesTypes.xq"),
	GET_WSRES_DETAILS_BYTYPE("getWSResourcesDetails.xq"),
	GET_WSRES_DETAILS_BYSUBTYPE("getWSResourcesDetailsSubType.xq"),
	GET_WSRESOURCE_BYID("getWSResourceByID.xq");

	private final String path = "org/gcube/resourcemanagement/support/server/gcube/queries/xquery/";
	private String filename = null;
	QueryLocation(final String filename) {
		this.filename = filename;
	}
	public InputStream getFileName() {
		return this.getClass().getClassLoader().getResourceAsStream(this.path + this.filename);
	}
}
