/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.resourcemanagement.shared.resource;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.informationsystem.model.reference.entities.Facet;
import org.gcube.informationsystem.model.reference.entities.Resource;
import org.gcube.informationsystem.model.reference.relations.ConsistsOf;
import org.gcube.informationsystem.resourceregistry.client.ResourceRegistryClient;
import org.gcube.informationsystem.utils.ElementMapper;
import org.gcube.portlets.admin.resourcemanagement.shared.resource.CacheList;
import org.gcube.portlets.admin.resourcemanagement.shared.resource.GcoreEndPointObject;
import org.gcube.portlets.admin.resourcemanagement.shared.resource.GenericResourceObject;
import org.gcube.portlets.admin.resourcemanagement.shared.resource.HostingNodeObject;
import org.gcube.portlets.admin.resourcemanagement.shared.resource.ResourceObject;
import org.gcube.resourcemanagement.model.reference.entities.facets.AccessPointFacet;
import org.gcube.resourcemanagement.model.reference.entities.facets.ContactFacet;
import org.gcube.resourcemanagement.model.reference.entities.facets.IdentifierFacet;
import org.gcube.resourcemanagement.model.reference.entities.facets.MemoryFacet;
import org.gcube.resourcemanagement.model.reference.entities.facets.NetworkingFacet;
import org.gcube.resourcemanagement.model.reference.entities.facets.SchemaFacet;
import org.gcube.resourcemanagement.model.reference.entities.facets.SimplePropertyFacet;
import org.gcube.resourcemanagement.model.reference.entities.facets.SoftwareFacet;
import org.gcube.resourcemanagement.model.reference.entities.facets.StateFacet;
import org.gcube.resourcemanagement.model.reference.entities.resources.Actor;
import org.gcube.resourcemanagement.model.reference.entities.resources.ConcreteDataset;
import org.gcube.resourcemanagement.model.reference.entities.resources.Configuration;
import org.gcube.resourcemanagement.model.reference.entities.resources.ConfigurationTemplate;
import org.gcube.resourcemanagement.model.reference.entities.resources.Dataset;
import org.gcube.resourcemanagement.model.reference.entities.resources.EService;
import org.gcube.resourcemanagement.model.reference.entities.resources.HostingNode;
import org.gcube.resourcemanagement.model.reference.entities.resources.LegalBody;
import org.gcube.resourcemanagement.model.reference.entities.resources.Person;
import org.gcube.resourcemanagement.model.reference.entities.resources.Plugin;
import org.gcube.resourcemanagement.model.reference.entities.resources.RunningPlugin;
import org.gcube.resourcemanagement.model.reference.entities.resources.Schema;
import org.gcube.resourcemanagement.model.reference.entities.resources.Site;
import org.gcube.resourcemanagement.model.reference.entities.resources.Software;
import org.gcube.resourcemanagement.model.reference.entities.resources.VirtualService;
import org.gcube.resourcemanagement.model.reference.relations.consistsof.HasPersistentMemory;
import org.gcube.resourcemanagement.model.reference.relations.consistsof.HasVolatileMemory;
import org.gcube.resourcemanagement.model.reference.relations.consistsof.IsIdentifiedBy;
import org.json.JSONArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UtilityResource {
    private static Logger logger = LoggerFactory.getLogger(UtilityResource.class);

    public static ArrayList<String> getSubResourcesTree(ResourceRegistryClient resourceRegistryClient, String entity, String scope) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        String s = resourceRegistryClient.getInstances(entity, Boolean.valueOf(true));
        List resources = ElementMapper.unmarshalList(Resource.class, (String)s);
        for (Resource r : resources) {
            List iibs = r.getConsistsOf(IsIdentifiedBy.class);
            block35: for (IsIdentifiedBy iib : iibs) {
                Facet f = (Facet)iib.getTarget();
                switch (entity) {
                    case "Actor": {
                        if (!(f instanceof ContactFacet)) break;
                        logger.info("------------Actor--ContactFacet");
                        ContactFacet sf = (ContactFacet)f;
                        if (list.contains(sf.getEMail())) continue block35;
                        list.add(sf.getEMail());
                        break;
                    }
                    case "LegalBody": {
                        if (!(f instanceof ContactFacet)) break;
                        logger.info("------------LegalBody--ContactFacet");
                        ContactFacet sf = (ContactFacet)f;
                        if (list.contains(sf.getEMail())) continue block35;
                        list.add(sf.getEMail());
                        break;
                    }
                    case "Person": {
                        if (!(f instanceof ContactFacet)) break;
                        logger.info("------------Person--ContactFacet");
                        ContactFacet sf = (ContactFacet)f;
                        if (list.contains(sf.getEMail())) continue block35;
                        list.add(sf.getEMail());
                        break;
                    }
                    case "ConfigurationTemplate": {
                        if (!(f instanceof IdentifierFacet)) break;
                        logger.info("------------ConfigurationTemplate--IdentifierFacet");
                        ContactFacet sf = (IdentifierFacet)f;
                        if (list.contains(sf.getType().toString())) continue block35;
                        list.add(sf.getType().toString());
                        break;
                    }
                    case "Configuration": {
                        if (!(f instanceof SoftwareFacet)) break;
                        logger.info("------------Configuration--IdentifierFacet");
                        ContactFacet sf = (IdentifierFacet)f;
                        if (list.contains(sf.getType().toString())) continue block35;
                        list.add(sf.getType().toString());
                        break;
                    }
                    case "Dataset": {
                        if (!(f instanceof SoftwareFacet)) break;
                        logger.info("------------Dataset--SoftwareFacet");
                        ContactFacet sf = (SoftwareFacet)f;
                        if (list.contains(sf.getGroup())) continue block35;
                        list.add(sf.getGroup());
                        break;
                    }
                    case "ConcreteDataset": {
                        if (!(f instanceof SoftwareFacet)) break;
                        logger.info("------------ConcreteDataset--SoftwareFacet");
                        ContactFacet sf = (SoftwareFacet)f;
                        if (list.contains(sf.getGroup())) continue block35;
                        list.add(sf.getGroup());
                        break;
                    }
                    case "Schema": {
                        if (!(f instanceof SchemaFacet)) break;
                        logger.info("------------Schema--SchemaFacet");
                        ContactFacet sf = (SchemaFacet)f;
                        if (list.contains(sf.getName())) continue block35;
                        list.add(sf.getName());
                        break;
                    }
                    case "EService": {
                        if (!(f instanceof SoftwareFacet)) break;
                        logger.info("------------EService--SoftwareFacet");
                        ContactFacet sf = (SoftwareFacet)f;
                        if (list.contains(sf.getGroup())) continue block35;
                        list.add(sf.getGroup());
                        break;
                    }
                    case "RunningPlugin": {
                        if (!(f instanceof SoftwareFacet)) break;
                        logger.info("------------RunningPlugin--SoftwareFacet");
                        ContactFacet sf = (SoftwareFacet)f;
                        if (list.contains(sf.getGroup())) continue block35;
                        list.add(sf.getGroup());
                        break;
                    }
                    case "HostingNode": {
                        if (!(f instanceof NetworkingFacet)) break;
                        logger.info("------------HostingNode--Networking");
                        NetworkingFacet nf = (NetworkingFacet)f;
                        if (list.contains(nf.getDomainName())) continue block35;
                        list.add(nf.getDomainName());
                        break;
                    }
                    case "VirtualService": {
                        if (!(f instanceof SoftwareFacet)) break;
                        logger.info("------------VirtualService--SoftwareFacet");
                        ContactFacet sf = (SoftwareFacet)f;
                        if (list.contains(sf.getGroup())) continue block35;
                        list.add(sf.getGroup());
                        break;
                    }
                    case "Site": {
                        if (!(f instanceof SoftwareFacet)) break;
                        logger.info("------------Site--SoftwareFacet");
                        ContactFacet sf = (SoftwareFacet)f;
                        if (list.contains(sf.getGroup())) continue block35;
                        list.add(sf.getGroup());
                        break;
                    }
                    case "Software": {
                        if (!(f instanceof SoftwareFacet)) break;
                        logger.info("------------Software--SoftwareFacet");
                        ContactFacet sf = (SoftwareFacet)f;
                        if (list.contains(sf.getGroup())) continue block35;
                        list.add(sf.getGroup());
                        break;
                    }
                    case "Plugin": {
                        if (!(f instanceof SoftwareFacet)) break;
                        logger.info("------------Plugin--SoftwareFacet");
                        ContactFacet sf = (SoftwareFacet)f;
                        if (list.contains(sf.getGroup())) break;
                        list.add(sf.getGroup());
                    }
                }
            }
        }
        return list;
    }

    public static ArrayList<String> getSubResourcesTreeQuery(ResourceRegistryClient resourceRegistryClient, String entity) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        String field = null;
        String identifiedFacet = null;
        switch (entity) {
            case "Actor": {
                field = "eMail";
                identifiedFacet = "ContactFacet";
                break;
            }
            case "LegalBody": {
                field = "eMail";
                identifiedFacet = "ContactFacet";
                break;
            }
            case "Person": {
                field = "eMail";
                identifiedFacet = "ContactFacet";
                break;
            }
            case "ConfigurationTemplate": {
                field = "type";
                identifiedFacet = "IdentifierFacet";
                break;
            }
            case "Configuration": {
                field = "type";
                identifiedFacet = "IdentifierFacet";
                break;
            }
            case "Dataset": {
                field = "group";
                identifiedFacet = "SoftwareFacet";
                break;
            }
            case "ConcreteDataset": {
                field = "group";
                identifiedFacet = "SoftwareFacet";
                break;
            }
            case "Schema": {
                field = "name";
                identifiedFacet = "SchemaFacet";
                break;
            }
            case "EService": {
                field = "group";
                identifiedFacet = "SoftwareFacet";
                break;
            }
            case "RunningPlugin": {
                field = "group";
                identifiedFacet = "SoftwareFacet";
                break;
            }
            case "HostingNode": {
                field = "domainName";
                identifiedFacet = "NetworkingFacet";
                break;
            }
            case "VirtualService": {
                field = "group";
                identifiedFacet = "SoftwareFacet";
                break;
            }
            case "Site": {
                field = "group";
                identifiedFacet = "SoftwareFacet";
                break;
            }
            case "Software": {
                field = "group";
                identifiedFacet = "SoftwareFacet";
                break;
            }
            case "Plugin": {
                field = "group";
                identifiedFacet = "SoftwareFacet";
                break;
            }
            default: {
                return new ArrayList<String>(0);
            }
        }
        try {
            String query = "SELECT DISTINCT(" + field + ") AS " + field + " FROM (TRAVERSE outE('IsIdentifiedBy'),inV('" + identifiedFacet + "') FROM " + entity + ")";
            logger.info("------------query----------->" + query);
            String result = resourceRegistryClient.rawQuery(query, true);
            if (result != null && !result.isEmpty()) {
                logger.info("--------result-------->" + result);
                JSONArray jsonArray = new JSONArray(result);
                for (int i = 0; i < jsonArray.length(); ++i) {
                    list.add(jsonArray.getJSONObject(i).get(field).toString());
                }
            } else {
                logger.info("--------result-------->Attention invalid result!");
            }
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
        }
        return list;
    }

    public static List<String> createListActor(ResourceRegistryClient resourceRegistryClient, String typeC, String subTypeC) throws Exception {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{GenericResourceObject.class});
        Marshaller m = context.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        m.setProperty("jaxb.fragment", (Object)true);
        ArrayList<String> resource = new ArrayList<String>();
        String id = "";
        String type = "Actor";
        String subType = "";
        String serviceClass = "";
        String serviceName = "";
        List actors = resourceRegistryClient.getInstances(Actor.class, Boolean.valueOf(false));
        if (actors == null) {
            logger.info("Actors not found");
            return resource;
        }
        logger.info("Actors found: {}", (Object)actors.size());
        for (Actor actor : actors) {
            id = actor.getHeader().getUUID().toString();
            List facets = actor.getIdentificationFacets();
            for (Facet f : facets) {
                if (!(f instanceof ContactFacet)) continue;
                ContactFacet sf = (ContactFacet)f;
                serviceName = sf.getName();
                serviceClass = sf.getSurname();
                subType = "";
            }
            CacheList.resourceid.put(id, new ResourceObject(serviceName, actor.toString()));
            GenericResourceObject temp = new GenericResourceObject(id, type, subType, serviceName, serviceClass, ScopeProvider.instance.get());
            StringWriter sw = new StringWriter();
            m.marshal((Object)temp, (Writer)sw);
            if (subTypeC != null) {
                if (!subType.equals(subTypeC)) continue;
                resource.add(sw.toString());
                continue;
            }
            resource.add(sw.toString());
        }
        logger.info("Actor: {}", resource);
        return resource;
    }

    public static List<String> createListLegalBody(ResourceRegistryClient resourceRegistryClient, String typeC, String subTypeC) throws Exception {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{GenericResourceObject.class});
        Marshaller m = context.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        m.setProperty("jaxb.fragment", (Object)true);
        ArrayList<String> resource = new ArrayList<String>();
        String id = "";
        String type = "LegalBody";
        String subType = "";
        String serviceClass = "";
        String serviceName = "";
        List legalBodys = resourceRegistryClient.getInstances(LegalBody.class, Boolean.valueOf(false));
        if (legalBodys == null) {
            logger.info("LegalBodys not found");
            return resource;
        }
        logger.info("LegalBodys found: {}", (Object)legalBodys.size());
        for (LegalBody actor : legalBodys) {
            id = actor.getHeader().getUUID().toString();
            List facets = actor.getIdentificationFacets();
            for (Facet f : facets) {
                if (!(f instanceof ContactFacet)) continue;
                ContactFacet sf = (ContactFacet)f;
                serviceName = sf.getName();
                serviceClass = sf.getSurname();
                subType = "";
            }
            CacheList.resourceid.put(id, new ResourceObject(serviceName, actor.toString()));
            GenericResourceObject temp = new GenericResourceObject(id, type, subType, serviceName, serviceClass, ScopeProvider.instance.get());
            StringWriter sw = new StringWriter();
            m.marshal((Object)temp, (Writer)sw);
            if (subTypeC != null) {
                if (!subType.equals(subTypeC)) continue;
                resource.add(sw.toString());
                continue;
            }
            resource.add(sw.toString());
        }
        logger.info("LegalBody: {}", resource);
        return resource;
    }

    public static List<String> createListPerson(ResourceRegistryClient resourceRegistryClient, String typeC, String subTypeC) throws Exception {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{GenericResourceObject.class});
        Marshaller m = context.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        m.setProperty("jaxb.fragment", (Object)true);
        ArrayList<String> resource = new ArrayList<String>();
        String id = "";
        String type = "Person";
        String subType = "";
        String serviceClass = "";
        String serviceName = "";
        List persons = resourceRegistryClient.getInstances(Person.class, Boolean.valueOf(false));
        if (persons == null) {
            logger.info("Persons not found");
            return resource;
        }
        logger.info("Persons found: {}", (Object)persons.size());
        for (Person person : persons) {
            id = person.getHeader().getUUID().toString();
            List facets = person.getIdentificationFacets();
            for (Facet f : facets) {
                if (!(f instanceof ContactFacet)) continue;
                ContactFacet sf = (ContactFacet)f;
                serviceName = sf.getName();
                serviceClass = sf.getSurname();
                subType = "";
            }
            CacheList.resourceid.put(id, new ResourceObject(serviceName, person.toString()));
            GenericResourceObject temp = new GenericResourceObject(id, type, subType, serviceName, serviceClass, ScopeProvider.instance.get());
            StringWriter sw = new StringWriter();
            m.marshal((Object)temp, (Writer)sw);
            if (subTypeC != null) {
                if (!subType.equals(subTypeC)) continue;
                resource.add(sw.toString());
                continue;
            }
            resource.add(sw.toString());
        }
        logger.info("Person: {}", resource);
        return resource;
    }

    public static List<String> createListConfigurationTemplate(ResourceRegistryClient resourceRegistryClient, String typeC, String subTypeC) throws Exception {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{GenericResourceObject.class});
        Marshaller m = context.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        m.setProperty("jaxb.fragment", (Object)true);
        ArrayList<String> resource = new ArrayList<String>();
        String id = "";
        String type = "ConfigurationTemplate";
        String subType = "";
        String name = "";
        String description = "";
        List configurationTemplates = resourceRegistryClient.getInstances(ConfigurationTemplate.class, Boolean.valueOf(false));
        if (configurationTemplates == null) {
            logger.info("ConfigurationTemplate not found!");
            return resource;
        }
        logger.info("ConfigurationTemplate found: {}", (Object)configurationTemplates.size());
        for (ConfigurationTemplate configurationTemplate : configurationTemplates) {
            id = configurationTemplate.getHeader().getUUID().toString();
            List facets = configurationTemplate.getIdentificationFacets();
            for (Facet f : facets) {
                if (!(f instanceof IdentifierFacet)) continue;
                IdentifierFacet sf = (IdentifierFacet)f;
                name = sf.getValue();
                description = sf.getType().toString();
                subType = sf.getType().toString();
            }
            CacheList.resourceid.put(id, new ResourceObject(name, configurationTemplate.toString()));
            GenericResourceObject temp = new GenericResourceObject(id, type, subType, name, description, ScopeProvider.instance.get());
            StringWriter sw = new StringWriter();
            m.marshal((Object)temp, (Writer)sw);
            if (subTypeC != null) {
                if (!subType.equals(subTypeC)) continue;
                resource.add(sw.toString());
                continue;
            }
            resource.add(sw.toString());
        }
        logger.info("ConfigurationTemplate: {}", resource);
        return resource;
    }

    public static List<String> createListConfiguration(ResourceRegistryClient resourceRegistryClient, String typeC, String subTypeC) throws Exception {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{GenericResourceObject.class});
        Marshaller m = context.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        m.setProperty("jaxb.fragment", (Object)true);
        ArrayList<String> resource = new ArrayList<String>();
        String id = "";
        String type = "GenericResource";
        String subType = "";
        String name = "";
        String description = "";
        List configurations = resourceRegistryClient.getInstances(Configuration.class, Boolean.valueOf(false));
        if (configurations == null) {
            logger.info("Configurations not found!");
            return resource;
        }
        logger.info("Configurations found: {}", (Object)configurations.size());
        for (Configuration configuration : configurations) {
            id = configuration.getHeader().getUUID().toString();
            List facets = configuration.getIdentificationFacets();
            for (Facet f : facets) {
                if (!(f instanceof IdentifierFacet)) continue;
                IdentifierFacet sf = (IdentifierFacet)f;
                name = sf.getValue();
                subType = sf.getType().toString();
                description = sf.getType().toString();
            }
            CacheList.resourceid.put(id, new ResourceObject(name, configuration.toString()));
            GenericResourceObject temp = new GenericResourceObject(id, type, subType, name, description, ScopeProvider.instance.get());
            StringWriter sw = new StringWriter();
            m.marshal((Object)temp, (Writer)sw);
            if (subTypeC != null) {
                if (!subType.equals(subTypeC)) continue;
                resource.add(sw.toString());
                continue;
            }
            resource.add(sw.toString());
        }
        logger.info("Configuration: {}", resource);
        return resource;
    }

    public static List<String> createListDataset(ResourceRegistryClient resourceRegistryClient, String typeC, String subTypeC) throws Exception {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{GenericResourceObject.class});
        Marshaller m = context.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        m.setProperty("jaxb.fragment", (Object)true);
        ArrayList<String> resource = new ArrayList<String>();
        String id = "";
        String type = "Dataset";
        String subType = "";
        String serviceClass = "";
        String serviceName = "";
        List datasets = resourceRegistryClient.getInstances(Dataset.class, Boolean.valueOf(false));
        if (datasets == null) {
            logger.info("Datasets not found!");
            return resource;
        }
        logger.info("Datasets found: {}", (Object)datasets.size());
        for (Dataset dataset : datasets) {
            id = dataset.getHeader().getUUID().toString();
            List facets = dataset.getIdentificationFacets();
            for (Facet f : facets) {
                if (!(f instanceof SoftwareFacet)) continue;
                SoftwareFacet sf = (SoftwareFacet)f;
                serviceName = sf.getName();
                serviceClass = sf.getGroup();
                subType = sf.getGroup();
            }
            CacheList.resourceid.put(id, new ResourceObject(serviceName, dataset.toString()));
            GenericResourceObject temp = new GenericResourceObject(id, type, subType, serviceName, serviceClass, ScopeProvider.instance.get());
            StringWriter sw = new StringWriter();
            m.marshal((Object)temp, (Writer)sw);
            if (subTypeC != null) {
                if (!subType.equals(subTypeC)) continue;
                resource.add(sw.toString());
                continue;
            }
            resource.add(sw.toString());
        }
        logger.info("Dataset: {}", resource);
        return resource;
    }

    public static List<String> createListConcreteDataset(ResourceRegistryClient resourceRegistryClient, String typeC, String subTypeC) throws Exception {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{GenericResourceObject.class});
        Marshaller m = context.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        m.setProperty("jaxb.fragment", (Object)true);
        ArrayList<String> resource = new ArrayList<String>();
        String id = "";
        String type = "ConcreteDataset";
        String subType = "";
        String serviceClass = "";
        String serviceName = "";
        List concretedatasets = resourceRegistryClient.getInstances(ConcreteDataset.class, Boolean.valueOf(false));
        if (concretedatasets == null) {
            logger.info("ConcreteDatasets not found!");
            return resource;
        }
        logger.info("ConcreteDatasets found: {}", (Object)concretedatasets.size());
        for (ConcreteDataset concreteDataset : concretedatasets) {
            id = concreteDataset.getHeader().getUUID().toString();
            List facets = concreteDataset.getIdentificationFacets();
            for (Facet f : facets) {
                if (!(f instanceof SoftwareFacet)) continue;
                SoftwareFacet sf = (SoftwareFacet)f;
                serviceName = sf.getName();
                serviceClass = sf.getGroup();
                subType = sf.getGroup();
            }
            CacheList.resourceid.put(id, new ResourceObject(serviceName, concreteDataset.toString()));
            GenericResourceObject temp = new GenericResourceObject(id, type, subType, serviceName, serviceClass, ScopeProvider.instance.get());
            StringWriter sw = new StringWriter();
            m.marshal((Object)temp, (Writer)sw);
            if (subTypeC != null) {
                if (!subType.equals(subTypeC)) continue;
                resource.add(sw.toString());
                continue;
            }
            resource.add(sw.toString());
        }
        logger.info("ConcreteDataset: {}", resource);
        return resource;
    }

    public static List<String> createListSchema(ResourceRegistryClient resourceRegistryClient, String typeC, String subTypeC) throws Exception {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{GenericResourceObject.class});
        Marshaller m = context.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        m.setProperty("jaxb.fragment", (Object)true);
        ArrayList<String> resource = new ArrayList<String>();
        String id = "";
        String type = "Schema";
        String subType = "";
        String serviceClass = "";
        String serviceName = "";
        List schemas = resourceRegistryClient.getInstances(Schema.class, Boolean.valueOf(false));
        if (schemas == null) {
            logger.info("Schemas not found!");
            return resource;
        }
        logger.info("Schemas found: {}", (Object)schemas.size());
        for (Schema schema : schemas) {
            id = schema.getHeader().getUUID().toString();
            List facets = schema.getIdentificationFacets();
            for (Facet f : facets) {
                if (!(f instanceof SchemaFacet)) continue;
                SchemaFacet sf = (SchemaFacet)f;
                serviceName = sf.getName();
                serviceClass = sf.getDescription();
                subType = sf.getSchema().getValue();
            }
            CacheList.resourceid.put(id, new ResourceObject(serviceName, schema.toString()));
            GenericResourceObject temp = new GenericResourceObject(id, type, subType, serviceName, serviceClass, ScopeProvider.instance.get());
            StringWriter sw = new StringWriter();
            m.marshal((Object)temp, (Writer)sw);
            if (subTypeC != null) {
                if (!subType.equals(subTypeC)) continue;
                resource.add(sw.toString());
                continue;
            }
            resource.add(sw.toString());
        }
        logger.info("Schema: {}", resource);
        return resource;
    }

    public static List<String> createListEservice(ResourceRegistryClient resourceRegistryClient, String typeC, String subTypeC) throws Exception {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{GcoreEndPointObject.class});
        Marshaller m = context.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        m.setProperty("jaxb.fragment", (Object)true);
        ArrayList<String> resource = new ArrayList<String>();
        String id = "";
        String type = "EService";
        String subType = "";
        String serviceClass = "";
        String serviceName = "";
        String version = "";
        String status = "";
        String ghnName = "";
        List eservices = resourceRegistryClient.getInstances(EService.class, Boolean.valueOf(false));
        for (EService et : eservices) {
            Object f2;
            id = et.getHeader().getUUID().toString();
            List facets = et.getIdentificationFacets();
            for (Object f2 : facets) {
                if (!(f2 instanceof SoftwareFacet)) continue;
                SoftwareFacet sf = (SoftwareFacet)f2;
                version = sf.getVersion();
                serviceName = sf.getName();
                serviceClass = sf.getGroup();
                subType = sf.getGroup();
                version = sf.getVersion();
            }
            CacheList.resourceid.put(id, new ResourceObject(serviceName, et.toString()));
            ghnName = "";
            status = "";
            List consist = et.getConsistsOf();
            f2 = consist.iterator();
            while (f2.hasNext()) {
                ConsistsOf c = (ConsistsOf)f2.next();
                if (!(c instanceof ConsistsOf)) continue;
                if (c.getTarget() instanceof AccessPointFacet) {
                    AccessPointFacet af = (AccessPointFacet)c.getTarget();
                    try {
                        ghnName = af.getEndpoint().getHost().toString();
                    }
                    catch (Exception e) {
                        ghnName = "";
                    }
                }
                if (!(c.getTarget() instanceof StateFacet)) continue;
                StateFacet stf = (StateFacet)c.getTarget();
                try {
                    status = stf.getValue().toLowerCase();
                }
                catch (Exception e) {
                    status = "";
                }
            }
            GcoreEndPointObject temp = new GcoreEndPointObject(id, type, subType, ScopeProvider.instance.get(), serviceClass, serviceName, version, status, ghnName);
            StringWriter sw = new StringWriter();
            m.marshal((Object)temp, (Writer)sw);
            if (subTypeC != null) {
                if (!subType.equals(subTypeC)) continue;
                resource.add(sw.toString());
                continue;
            }
            resource.add(sw.toString());
        }
        logger.info("EService: {}", resource);
        return resource;
    }

    public static List<String> createListRunningPlugin(ResourceRegistryClient resourceRegistryClient, String typeC, String subTypeC) throws Exception {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{GenericResourceObject.class});
        Marshaller m = context.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        m.setProperty("jaxb.fragment", (Object)true);
        ArrayList<String> resource = new ArrayList<String>();
        String id = "";
        String type = "RunningPlugin";
        String subType = "";
        String serviceClass = "";
        String serviceName = "";
        List runningPlugins = resourceRegistryClient.getInstances(RunningPlugin.class, Boolean.valueOf(false));
        if (runningPlugins == null) {
            logger.info("RunningPlugins not found");
            return resource;
        }
        logger.info("RunningPlugins found: {}", (Object)runningPlugins.size());
        for (RunningPlugin runningPlugin : runningPlugins) {
            id = runningPlugin.getHeader().getUUID().toString();
            List facets = runningPlugin.getIdentificationFacets();
            for (Facet f : facets) {
                if (!(f instanceof SoftwareFacet)) continue;
                SoftwareFacet sf = (SoftwareFacet)f;
                serviceName = sf.getName();
                serviceClass = sf.getGroup();
                subType = sf.getGroup();
            }
            CacheList.resourceid.put(id, new ResourceObject(serviceName, runningPlugin.toString()));
            GenericResourceObject temp = new GenericResourceObject(id, type, subType, serviceName, serviceClass, ScopeProvider.instance.get());
            StringWriter sw = new StringWriter();
            m.marshal((Object)temp, (Writer)sw);
            if (subTypeC != null) {
                if (!subType.equals(subTypeC)) continue;
                resource.add(sw.toString());
                continue;
            }
            resource.add(sw.toString());
        }
        logger.info("RunningPlugin: {}", resource);
        return resource;
    }

    public static List<String> createListHostingNode(ResourceRegistryClient resourceRegistryClient, String typeC, String subTypeC) throws Exception {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{HostingNodeObject.class});
        Marshaller m = context.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        m.setProperty("jaxb.fragment", (Object)true);
        ArrayList<String> resource = new ArrayList<String>();
        String id = "";
        String type = "GHN";
        String subType = "";
        String status = "";
        String name = "";
        String upTime = "-";
        String lastUpdate = "-";
        long localAvailableSpace = 0L;
        long virtualSize = 0L;
        long virtualAvailable = 0L;
        String loadLast1Min = "-";
        String loadLast5Min = "-";
        String loadLast15Min = "-";
        String gcfVersion = "";
        String ghnVersion = "";
        List ehosting = resourceRegistryClient.getInstances(HostingNode.class, Boolean.valueOf(false));
        for (HostingNode eh : ehosting) {
            Object f2;
            id = eh.getHeader().getUUID().toString();
            lastUpdate = eh.getHeader().getLastUpdateTime().toString();
            List facets = eh.getIdentificationFacets();
            for (Object f2 : facets) {
                if (!(f2 instanceof NetworkingFacet)) continue;
                NetworkingFacet nf = (NetworkingFacet)f2;
                subType = nf.getDomainName();
                name = nf.getHostName();
            }
            CacheList.resourceid.put(id, new ResourceObject(name, eh.toString()));
            List consist = eh.getConsistsOf();
            f2 = consist.iterator();
            while (f2.hasNext()) {
                ConsistsOf c = (ConsistsOf)f2.next();
                if (!(c instanceof ConsistsOf)) continue;
                if (c.getTarget() instanceof SimplePropertyFacet) {
                    SimplePropertyFacet sp = (SimplePropertyFacet)c.getTarget();
                    try {
                        gcfVersion = sp.getAdditionalProperty("SmartGearsDistribution").toString();
                        ghnVersion = sp.getAdditionalProperty("SmartGears").toString();
                    }
                    catch (Exception e) {
                        gcfVersion = "";
                        ghnVersion = "";
                    }
                }
                if (c instanceof HasPersistentMemory) {
                    HasPersistentMemory hpm = (HasPersistentMemory)c;
                    try {
                        MemoryFacet mfh = (MemoryFacet)hpm.getTarget();
                        localAvailableSpace = mfh.getSize() - mfh.getUsed();
                    }
                    catch (Exception e) {
                        localAvailableSpace = 0L;
                    }
                }
                if (c instanceof HasVolatileMemory) {
                    HasVolatileMemory hvm = (HasVolatileMemory)c;
                    try {
                        if (hvm.getAdditionalProperty("memoryType").equals("RAM")) {
                            MemoryFacet mf = (MemoryFacet)hvm.getTarget();
                            virtualAvailable = mf.getSize() - mf.getUsed();
                            virtualSize = mf.getSize();
                        }
                    }
                    catch (Exception e) {
                        virtualAvailable = 0L;
                        virtualSize = 0L;
                    }
                }
                if (!(c.getTarget() instanceof StateFacet)) continue;
                StateFacet st = (StateFacet)c.getTarget();
                try {
                    status = st.getValue();
                }
                catch (Exception e) {
                    status = "";
                }
            }
            HostingNodeObject temp = new HostingNodeObject(id, type, subType, status, name, upTime, lastUpdate, localAvailableSpace, virtualSize, virtualAvailable, loadLast1Min, loadLast5Min, loadLast15Min, gcfVersion, ghnVersion, ScopeProvider.instance.get());
            StringWriter sw = new StringWriter();
            m.marshal((Object)temp, (Writer)sw);
            if (subTypeC != null) {
                if (!subType.equals(subTypeC)) continue;
                resource.add(sw.toString());
                continue;
            }
            resource.add(sw.toString());
        }
        return resource;
    }

    public static List<String> createListVirtualService(ResourceRegistryClient resourceRegistryClient, String typeC, String subTypeC) throws Exception {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{GenericResourceObject.class});
        Marshaller m = context.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        m.setProperty("jaxb.fragment", (Object)true);
        ArrayList<String> resource = new ArrayList<String>();
        String id = "";
        String type = "VirtualService";
        String subType = "";
        String serviceClass = "";
        String serviceName = "";
        List virtualServices = resourceRegistryClient.getInstances(VirtualService.class, Boolean.valueOf(false));
        if (virtualServices == null) {
            logger.info("VirtualServices not found");
            return resource;
        }
        logger.info("VirtualServices found: {}", (Object)virtualServices.size());
        for (VirtualService vs : virtualServices) {
            id = vs.getHeader().getUUID().toString();
            List facets = vs.getIdentificationFacets();
            for (Facet f : facets) {
                if (!(f instanceof SoftwareFacet)) continue;
                SoftwareFacet sf = (SoftwareFacet)f;
                serviceName = sf.getName();
                serviceClass = sf.getGroup();
                subType = sf.getGroup();
            }
            CacheList.resourceid.put(id, new ResourceObject(serviceName, vs.toString()));
            GenericResourceObject temp = new GenericResourceObject(id, type, subType, serviceName, serviceClass, ScopeProvider.instance.get());
            StringWriter sw = new StringWriter();
            m.marshal((Object)temp, (Writer)sw);
            if (subTypeC != null) {
                if (!subType.equals(subTypeC)) continue;
                resource.add(sw.toString());
                continue;
            }
            resource.add(sw.toString());
        }
        logger.info("VirtualService: {}", resource);
        return resource;
    }

    public static List<String> createListSite(ResourceRegistryClient resourceRegistryClient, String typeC, String subTypeC) throws Exception {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{GenericResourceObject.class});
        Marshaller m = context.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        m.setProperty("jaxb.fragment", (Object)true);
        ArrayList<String> resource = new ArrayList<String>();
        String id = "";
        String type = "Site";
        String subType = "";
        String serviceClass = "";
        String serviceName = "";
        List sites = resourceRegistryClient.getInstances(Site.class, Boolean.valueOf(false));
        if (sites == null) {
            logger.info("Site not found");
            return resource;
        }
        logger.info("Site found: {}", (Object)sites.size());
        for (Site site : sites) {
            id = site.getHeader().getUUID().toString();
            List facets = site.getIdentificationFacets();
            for (Facet f : facets) {
                if (!(f instanceof SoftwareFacet)) continue;
                SoftwareFacet sf = (SoftwareFacet)f;
                serviceName = sf.getName();
                serviceClass = sf.getGroup();
                subType = sf.getGroup();
            }
            CacheList.resourceid.put(id, new ResourceObject(serviceName, site.toString()));
            GenericResourceObject temp = new GenericResourceObject(id, type, subType, serviceName, serviceClass, ScopeProvider.instance.get());
            StringWriter sw = new StringWriter();
            m.marshal((Object)temp, (Writer)sw);
            if (subTypeC != null) {
                if (!subType.equals(subTypeC)) continue;
                resource.add(sw.toString());
                continue;
            }
            resource.add(sw.toString());
        }
        logger.info("Site: {}", resource);
        return resource;
    }

    public static List<String> createListSoftware(ResourceRegistryClient resourceRegistryClient, String typeC, String subTypeC) throws Exception {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{GenericResourceObject.class});
        Marshaller m = context.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        m.setProperty("jaxb.fragment", (Object)true);
        ArrayList<String> resource = new ArrayList<String>();
        String id = "";
        String type = "Software";
        String subType = "";
        String serviceClass = "";
        String serviceName = "";
        List softwares = resourceRegistryClient.getInstances(Software.class, Boolean.valueOf(false));
        if (softwares == null) {
            logger.info("Softwares not found");
            return resource;
        }
        logger.info("Softwares found: {}", (Object)softwares.size());
        for (Software software : softwares) {
            id = software.getHeader().getUUID().toString();
            List facets = software.getIdentificationFacets();
            for (Facet f : facets) {
                if (!(f instanceof SoftwareFacet)) continue;
                SoftwareFacet sf = (SoftwareFacet)f;
                serviceName = sf.getName();
                serviceClass = sf.getGroup();
                subType = sf.getGroup();
            }
            CacheList.resourceid.put(id, new ResourceObject(serviceName, software.toString()));
            GenericResourceObject temp = new GenericResourceObject(id, type, subType, serviceName, serviceClass, ScopeProvider.instance.get());
            StringWriter sw = new StringWriter();
            m.marshal((Object)temp, (Writer)sw);
            if (subTypeC != null) {
                if (!subType.equals(subTypeC)) continue;
                resource.add(sw.toString());
                continue;
            }
            resource.add(sw.toString());
        }
        logger.info("Software: {}", resource);
        return resource;
    }

    public static List<String> createListPlugin(ResourceRegistryClient resourceRegistryClient, String typeC, String subTypeC) throws Exception {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{GenericResourceObject.class});
        Marshaller m = context.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        m.setProperty("jaxb.fragment", (Object)true);
        ArrayList<String> resource = new ArrayList<String>();
        String id = "";
        String type = "Plugin";
        String subType = "";
        String serviceClass = "";
        String serviceName = "";
        List plugins = resourceRegistryClient.getInstances(Plugin.class, Boolean.valueOf(false));
        if (plugins == null) {
            logger.info("Plugins not found");
            return resource;
        }
        logger.info("Plugins found: {}", (Object)plugins.size());
        for (Plugin plugin : plugins) {
            id = plugin.getHeader().getUUID().toString();
            List facets = plugin.getIdentificationFacets();
            for (Facet f : facets) {
                if (!(f instanceof SoftwareFacet)) continue;
                SoftwareFacet sf = (SoftwareFacet)f;
                serviceName = sf.getName();
                serviceClass = sf.getGroup();
                subType = sf.getGroup();
            }
            CacheList.resourceid.put(id, new ResourceObject(serviceName, plugin.toString()));
            GenericResourceObject temp = new GenericResourceObject(id, type, subType, serviceName, serviceClass, ScopeProvider.instance.get());
            StringWriter sw = new StringWriter();
            m.marshal((Object)temp, (Writer)sw);
            if (subTypeC != null) {
                if (!subType.equals(subTypeC)) continue;
                resource.add(sw.toString());
                continue;
            }
            resource.add(sw.toString());
        }
        logger.info("Plugin: {}", resource);
        return resource;
    }
}

