package org.gcube.portlets.admin.resourcemanagement.server;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.gcube.common.authorization.library.provider.AccessTokenProvider;
import org.gcube.common.keycloak.KeycloakClient;
import org.gcube.common.keycloak.KeycloakClientFactory;
import org.gcube.common.keycloak.model.TokenResponse;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.informationsystem.model.reference.entities.Resource;
import org.gcube.informationsystem.resourceregistry.api.contexts.ContextCache;
import org.gcube.informationsystem.resourceregistry.client.ResourceRegistryClient;
import org.gcube.informationsystem.resourceregistry.client.ResourceRegistryClientFactory;
import org.gcube.informationsystem.types.reference.Type;
import org.gcube.portlets.admin.resourcemanagement.shared.resource.CacheList;
import org.gcube.portlets.admin.resourcemanagement.shared.resource.UtilityResource;
import org.gcube.resourcemanagement.support.client.views.ResourceTypeDecorator;
import org.gcube.resourcemanagement.support.shared.types.datamodel.CompleteResourceProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 
 * @author pieve mail:alessandro.pieve@isti.cnr.it
 *
 */
public class RegistryClientRequester {

	private static Logger logger = LoggerFactory.getLogger(RegistryClientRequester.class);
	
	private static ResourceRegistryClient resourceRegistryClient;

	private static KeycloakClient client = KeycloakClientFactory.newInstance();

	private static final String endpoint = "https://accounts.dev.d4science.org/auth/realms/d4science/protocol/openid-connect/token";
	private static final String clientID = "resource-registry-portlet-expieve";
	private static final String secret = "179bd3bc-5cc4-11ec-bf63-0242ac130001";

	private static final String rootScope = "/gcube";

	public static final Set<String> getAvailableContexts() throws Exception {
		Set<String> contextList = new HashSet<String>();
		ScopeProvider.instance.set(rootScope);
		AccessTokenProvider.instance.set(getTokenForContext(rootScope));
		try {
			resourceRegistryClient = ResourceRegistryClientFactory.create();

			ContextCache contextCache = ContextCache.getInstance();

			contextList = contextCache.getContextFullNameToUUIDAssociation().keySet();

		} catch (Exception e) {
			return Collections.emptySet();
		}finally {
			AccessTokenProvider.instance.reset();
			ScopeProvider.instance.reset();
		}
		return contextList;
	}

	private static String getTokenForContext(String context) {
		try {
			TokenResponse response = client.queryUMAToken(new URL(endpoint), clientID, secret, context, null);
			return response.getAccessToken();

		} catch (Exception e) {
			throw new RuntimeException("error getting access token for context "+context, e);
		}

	}

	/**
	 * For all the resource in the scope retrieves their
	 * (type, subtype) values.
	 * The result is a list of couples of that form.
	 * @return a list of string tuples (type, subtype)
	 * @throws Exception
	 */

	//list a resource with a sub category
	public static final HashMap<String, ArrayList<String>> getResourcesTree(String scope) throws Exception {


		HashMap<String, ArrayList<String>> retval = new HashMap<String, ArrayList<String>>();
		ScopeProvider.instance.set(scope);
		AccessTokenProvider.instance.set(getTokenForContext(scope));
		try {
			logger.info("GetResourcesTree: [Scope: {}]",scope);
			
			resourceRegistryClient = ResourceRegistryClientFactory.create();
			List<Type> types = resourceRegistryClient.getType(Resource.class, true);

			logger.info("Resources Types: {}",types.size());

			for (Type t : types) {
				logger.info("Resource Type: {} in {} ",t.getName(),scope);
				

				String val = null;
				if (t.getName().equals("EService"))
					val= "RunningInstance";
				if (t.getName().equals("Configuration"))
					val = "GenericResource";
				if (t.getName().equals("HostingNode"))
					val = "GHN";

				if (val!=null) {
					ArrayList<String> subtrees = new ArrayList<String>();
					try {
						subtrees = UtilityResource.getSubResourcesTreeQuery(resourceRegistryClient, t.getName());
					}catch (Exception e) {
						e.printStackTrace();
					}
					retval.put(val, subtrees);
				}

			}

		} catch (Exception e) {
			e.printStackTrace();
		}finally {
			AccessTokenProvider.instance.reset();
			ScopeProvider.instance.reset();
		}

		return retval;
	}


	//list string (xml formatted) for table
	public static final List<String> getResourcesByTypeSubType( String scope,String type,String subType) throws Exception {


		//CacheList.resourceid.clear();
		ScopeProvider.instance.set(scope);
		AccessTokenProvider.instance.set(getTokenForContext(scope));
		try {
			logger.info("GetResourcesByTypeSubType: [Scope:{}, Type:{}]",scope, type);
			
			resourceRegistryClient = ResourceRegistryClientFactory.create();
			List<String>resource=new ArrayList<String>();

			switch (type) {
			case "RunningInstance": 
				logger.info("---------------->RunningInstance ");
				resource=UtilityResource.createListEservice(resourceRegistryClient, type,subType);
				break;
			case "GenericResource": 
				logger.info("---------------->GenericResource ");
				//resource=UtilityResource.CreateListConfiguration(scope,type,subType);
				resource=UtilityResource.createListConfigurationQuery(resourceRegistryClient, type,subType);
				break;
			case "GHN": 
				logger.info("---------------->GHN ");
				resource=UtilityResource.createListHostingNode(resourceRegistryClient, type,subType);
				break;

			}
			return resource;
		}finally {
			AccessTokenProvider.instance.reset();
			ScopeProvider.instance.reset();
		}

	}




	public static CompleteResourceProfile getResourceByID(
			String xml2htmlMapping, String scope, String type,
			String resID) {

		String representation=CacheList.resourceid.get(resID).getBody();
		//get resource by id
		String title=CacheList.resourceid.get(resID).getTitle();
		String xmlRepresentation="<Resource>"
				+ "<ID>"+resID+"</ID>"
				+ "<Type>"+type+"</Type>"
				+ "<Scope>"+scope+"</Scope>"
				+ representation
				+ "</Resource>";
		String htmlRepresentation=representation;
		ScopeProvider.instance.set(scope);
		return new CompleteResourceProfile(resID, ResourceTypeDecorator.valueOf(type),title,xmlRepresentation, htmlRepresentation);
	}


}
