/****************************************************************************
 *  This software is part of the gCube Project.
 *  Site: http://www.gcube-system.org/
 ****************************************************************************
 * The gCube/gCore software is licensed as Free Open Source software
 * conveying to the EUPL (http://ec.europa.eu/idabc/eupl).
 * The software and documentation is provided by its authors/distributors
 * "as is" and no expressed or
 * implied warranty is given for its use, quality or fitness for a
 * particular case.
 ****************************************************************************
 * Filename: GenericResourceForm.java
 ****************************************************************************
 * @author <a href="mailto:daniele.strollo@isti.cnr.it">Daniele Strollo</a>
 ***************************************************************************/

package org.gcube.portlets.admin.resourcemanagement.client.forms.genericresources;

import org.gcube.portlets.admin.resourcemanagement.client.utils.OpCommands;
import org.gcube.resourcemanagement.support.client.views.validators.XMLValidator;
import org.gcube.resourcemanagement.support.shared.types.Tuple;
import org.gcube.resourcemanagement.support.shared.types.datamodel.ResourceDescriptor;

import com.extjs.gxt.ui.client.Style.HorizontalAlignment;
import com.extjs.gxt.ui.client.event.ComponentEvent;
import com.extjs.gxt.ui.client.widget.Dialog;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.extjs.gxt.ui.client.widget.form.FormButtonBinding;
import com.extjs.gxt.ui.client.widget.form.FormPanel;
import com.extjs.gxt.ui.client.widget.form.TextArea;
import com.extjs.gxt.ui.client.widget.form.TextField;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.extjs.gxt.ui.client.widget.layout.FormData;
import com.google.gwt.user.client.Element;

public class GenericResourceForm extends Dialog {
	private FormData formData = null;
	private FormPanel form = null;
	private ResourceDescriptor toEdit = null;

	public GenericResourceForm() {
		this.setLayout(new FitLayout());
		this.setHeading("Generic Resource Creation");
		this.setModal(true);
		this.setWidth(700);
		this.setHeight(500);
		this.setResizable(false);
		this.getButtonBar().removeAll();
		this.setHideOnButtonClick(true);
	}

	// Added for editing mode
	public GenericResourceForm(final ResourceDescriptor genericRes) {
		this();
		this.setHeading("Generic Resource Edit");
		this.toEdit = genericRes;
	}

	@Override
	protected final void onRender(final Element parent, final int index) {
		super.onRender(parent, index);
		formData = new FormData("-20");
		createForm();
	}

	public final void closeDialog() {
		this.hide();
	}

	private boolean isEditing() {
		return this.toEdit != null;
	}

	private void createForm() {
		form = new FormPanel();
		form.setFrame(true);
		form.setAutoWidth(true);

		form.setHeaderVisible(false);
		form.getHeader().setStyleName("x-hide-panel-header");

		TextField<String> resID = new TextField<String>();
		resID.setFieldLabel("Resource ID");
		// resID.setValidator(new StringValidator(120, false));
		resID.setAllowBlank(false);  // is required
		// If in editing mode
		if (toEdit != null && toEdit.getID() != null) {
			resID.setValue(toEdit.getID());
		} else {
			resID.setEmptyText("<generated by Resource Manager>");
		}
		resID.setEnabled(false);
		form.add(resID, formData);

		TextField<String> resName = new TextField<String>();
		resName.setFieldLabel("Resource Name");
		// resName.setValidator(new StringValidator(120, false));
		resName.setAllowBlank(false);  // is required
		// If in editing mode
		if (toEdit != null && toEdit.getName() != null) {
			resName.setValue(toEdit.getName());
		}
		form.add(resName, formData);

		TextField<String> resType = new TextField<String>();
		resType.setFieldLabel("Secondary type");
		// resType.setValidator(new StringValidator(120, false));
		resType.setAllowBlank(false);  // is required
		// If in editing mode
		if (toEdit != null && toEdit.get("SecondaryType") != null) {
			resType.setValue(((Object) toEdit.get("SecondaryType")).toString());
		}
		form.add(resType, formData);

		TextArea description = new TextArea();
		description.setFieldLabel("Description");
		// If in editing mode
		if (toEdit != null && toEdit.get("Description") != null) {
			description.setValue(((Object) toEdit.get("Description")).toString());
		}
		form.add(description, formData);

		TextArea body = new TextArea();
		body.setFieldLabel("Body");
		body.setHeight(235);
		body.setValidator(new XMLValidator("body"));
		// If in editing mode
		if (toEdit != null && toEdit.get("Body") != null) {
			body.setValue(((Object) toEdit.get("Body")).toString());
		}
		form.add(body, formData);

		Button submitBtn = new Button("Submit") {
			@SuppressWarnings("deprecation")
			@Override
			protected void onClick(final ComponentEvent ce) {
				super.onClick(ce);
				if (!form.isValid()) {
					return;
				}
				Tuple<String> values = new Tuple<String>();
				for (Field<?> field  : form.getFields()) {
					values.append(field.getRawValue());
				}
				// Creation mode
				if (!isEditing()) {
					String resName = values.get(1);
					String resType = values.get(2);
					String description = values.get(3);
					String body = values.get(4);

					OpCommands.doCreateGenericResource(null, resName, description, body, resType);
				} else {
					// Editing mode
					String resID = values.get(0);
					String resName = values.get(1);
					String resType = values.get(2);
					String description = values.get(3);
					String body = values.get(4);
					OpCommands.doEditGenericResource(resID, resName, description, body, resType);
				}

				closeDialog();
			}
		};
		form.addButton(submitBtn);
		form.addButton(new Button("Cancel") {
			@Override
			protected void onClick(final ComponentEvent ce) {
				super.onClick(ce);
				closeDialog();
			}
		});

		form.setButtonAlign(HorizontalAlignment.CENTER);

		FormButtonBinding binding = new FormButtonBinding(form);
		binding.addButton(submitBtn);

		this.add(form);
	}
}
