/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.resourcemanagement.client.widgets.panels;

import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Dialog;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.extjs.gxt.ui.client.widget.toolbar.SeparatorToolItem;
import com.extjs.gxt.ui.client.widget.toolbar.ToolBar;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import java.util.Vector;
import org.gcube.portlets.admin.resourcemanagement.client.utils.Commands;
import org.gcube.portlets.admin.resourcemanagement.client.widgets.panels.DetachablePanel;
import org.gcube.portlets.admin.resourcemanagement.client.widgets.registry.WidgetsRegistry;
import org.gcube.portlets.admin.resourcemanagement.client.widgets.viewport.MainContainer;
import org.gcube.resourcemanagement.support.shared.exceptions.InvalidParameterException;
import org.gcube.resourcemanagement.support.shared.util.Assertion;

public class DetachablePanel {
    private ToolBar toolBar = new ToolBar();
    private LayoutContainer parent = null;
    private boolean modal = true;
    private boolean isDetached = false;
    private ContentPanel rootPanel = null;
    private Button detachButton = null;
    private String title = "";
    private Component mainWidget = null;
    private final List<DetachablePanelHandler> handlers = new Vector();
    private LayoutContainer actualContainer = null;

    public DetachablePanel(LayoutContainer container, String title, String id, boolean modal) throws InvalidParameterException {
        Assertion checker = new Assertion();
        checker.validate(container != null, (Throwable)new InvalidParameterException("The container parameter is null"));
        this.parent = container;
        this.parent.setLayout((Layout)new FitLayout());
        this.modal = modal;
        this.title = title;
        this.onLoad();
        this.rootPanel.setId(id);
        this.rootPanel.setHeaderVisible(false);
        this.rootPanel.getHeader().setStyleName("x-hide-panel-header");
        WidgetsRegistry.registerWidget((String)id, (Widget)this.rootPanel);
        this.embedWindow();
    }

    public final ToolBar getToolBar() {
        return this.toolBar;
    }

    private void onLoad() {
        this.rootPanel = new /* Unavailable Anonymous Inner Class!! */;
        this.initToolBar();
        this.rootPanel.setId("detachable-panel-root");
        this.rootPanel.setTopComponent((Component)this.toolBar);
        this.rootPanel.setLayout((Layout)new FitLayout());
        this.rootPanel.setHeight("100%");
        this.rootPanel.remove((Widget)this.rootPanel.getHeader());
        this.rootPanel.layout();
    }

    private void initToolBar() {
        this.detachButton = new /* Unavailable Anonymous Inner Class!! */;
        this.detachButton.setToolTip("Embeds/Detaches the dialog");
        this.detachButton.setIconStyle("detach-icon");
        this.detachButton.setEnabled(true);
        this.toolBar.add((Component)this.detachButton);
        this.toolBar.add((Component)new SeparatorToolItem());
    }

    private void toggleDetachWindow() {
        if (!this.isDetached) {
            this.detachWindow();
            this.onDetach();
        } else {
            this.embedWindow();
            this.onEmbed();
        }
        this.isDetached = !this.isDetached;
    }

    private void detachWindow() {
        GWT.log((String)("Detaching panel " + this.title));
        this.rootPanel.removeFromParent();
        Dialog dlg = new Dialog();
        this.parent.disable();
        this.parent.removeFromParent();
        dlg.setLayout((Layout)new FitLayout());
        dlg.setHeading(this.title);
        dlg.setClosable(false);
        dlg.setModal(this.modal);
        dlg.setWidth(800);
        dlg.setHeight(500);
        dlg.setResizable(true);
        dlg.getButtonBar().removeAll();
        dlg.add((Widget)this.rootPanel);
        this.actualContainer = dlg;
        WidgetsRegistry.registerWidget((String)(this.rootPanel.getId() + "-dlg-detached"), (Widget)dlg);
        dlg.show();
    }

    private void embedWindow() {
        GWT.log((String)("Embedding panel " + this.title));
        this.parent.add((Widget)this.rootPanel);
        this.parent.enable();
        this.parent.layout(true);
        this.actualContainer = this.parent;
        Widget elem = WidgetsRegistry.getWidget((String)(this.rootPanel.getId() + "-dlg-detached"));
        if (elem != null) {
            elem.removeFromParent();
        }
        WidgetsRegistry.unregisterWidget((String)(this.rootPanel.getId() + "-dlg-detached"));
    }

    public final ContentPanel getRootPanel() {
        return this.rootPanel;
    }

    protected final void onDetach() {
        Commands.refreshViewport();
        this.rootPanel.layout(true);
        for (DetachablePanelHandler handler : this.handlers) {
            handler.onDetachEvent(this, this.mainWidget);
        }
    }

    protected final void onEmbed() {
        MainContainer viewport = Commands.getViewport();
        viewport.add((Widget)this.parent);
        Commands.refreshViewport();
        this.rootPanel.layout(true);
        for (DetachablePanelHandler handler : this.handlers) {
            handler.onEmbedEvent(this, this.mainWidget);
        }
    }

    public final void insertMainWidget(Component widget) {
        this.mainWidget = widget;
        this.getRootPanel().add((Widget)widget);
    }

    public final void layout(boolean force) {
        this.rootPanel.layout(force);
    }

    public final void addHandler(DetachablePanelHandler handler) {
        this.handlers.add(handler);
    }

    public final void removeHandler(DetachablePanelHandler handler) {
        this.handlers.remove(handler);
    }

    static /* synthetic */ LayoutContainer access$000(DetachablePanel x0) {
        return x0.actualContainer;
    }

    static /* synthetic */ void access$100(DetachablePanel x0) {
        x0.toggleDetachWindow();
    }
}

