/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.resourcemanagement.client.widgets.taskbar;

import com.extjs.gxt.ui.client.core.El;
import com.extjs.gxt.ui.client.event.ComponentEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.util.IconHelper;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.IconSupport;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.AbstractImagePrototype;

public class TaskbarButton
extends Component
implements IconSupport {
    private String type;
    private String text;
    private AbstractImagePrototype icon;
    private El iconEl;

    public TaskbarButton() {
    }

    public TaskbarButton(String id, String type, String text) {
        this.setId(id);
        this.setText(text);
        this.type = type;
    }

    public final void addSelectionListener(SelectionListener<? extends ComponentEvent> listener) {
        this.addListener(Events.Select, listener);
    }

    public final AbstractImagePrototype getIcon() {
        return this.icon;
    }

    public final String getText() {
        return this.text;
    }

    public final void onComponentEvent(ComponentEvent ce) {
        super.onComponentEvent(ce);
        if (ce.getEventTypeInt() == 1) {
            this.onClick(ce);
        }
    }

    public final void removeSelectionListener(SelectionListener<? extends ComponentEvent> listener) {
        this.removeListener(Events.Select, listener);
    }

    public final void setIcon(AbstractImagePrototype icon) {
        if (this.rendered) {
            this.iconEl.setInnerHtml("");
            this.iconEl.appendChild((Element)icon.createElement().cast());
        }
        this.icon = icon;
    }

    public final void setIconStyle(String icon) {
        this.setIcon(IconHelper.create((String)icon, (int)48, (int)48));
    }

    public final void setText(String text) {
        this.text = text;
    }

    protected void onClick(ComponentEvent ce) {
        ce.stopEvent();
        this.fireEvent(Events.Select, ce);
    }

    protected final void onRender(Element target, int index) {
        super.onRender(target, index);
        int splitTextTo = 16;
        String style = "background:#ffc;  display:block; margin-left: 15px; margin-top: 10px; padding:3px; width: 120px; height: 120px;font-family:'Reenie Beanie',arial,sans-serif; font-size:19px;line-height:1;-moz-box-shadow:5px 5px 7px rgba(33,33,33,1);-webkit-box-shadow: 5px 5px 7px rgba(33,33,33,.7);box-shadow: 5px 5px 7px rgba(33,33,33,.7); ";
        int rd = index + 1;
        style = rd % 2 == 0 ? style + "-o-transform:rotate(5deg); -webkit-transform:rotate(5deg); -moz-transform:rotate(5deg); position:relative;" : (rd % 3 == 0 ? style + "-o-transform:rotate(-3deg); -webkit-transform:rotate(-3deg); -moz-transform:rotate(-3deg);  position:relative; top: -5px; " : style + "-o-transform:rotate(2deg); -webkit-transform:rotate(2deg); -moz-transform:rotate(2deg); position:relative;");
        String fontStyle = "font-family:'Reenie Beanie',arial,sans-serif; font-size:20px; padding: 5px; overflow-x: hidden; overflow-y: hidden;";
        this.setElement(DOM.createElement((String)"dt"), target, index);
        El a = this.el().createChild("<div style=\"" + style + "\"><a href='#'></a></div>");
        this.iconEl = a.createChild("<h2>" + this.type + "</h2>");
        El txt = a.createChild("<div style=\"" + fontStyle + "\" align=\"center\"></div>");
        String toShow = "";
        if (this.text.length() / splitTextTo > 0) {
            int iterateTo = this.text.length() / splitTextTo < 4 ? this.text.length() / splitTextTo : 3;
            for (int i = 0; i < iterateTo; ++i) {
                toShow = toShow + this.text.substring(i * splitTextTo, (i + 1) * splitTextTo) + " ";
            }
            if (iterateTo < 4) {
                toShow = toShow + this.text.substring(this.text.length() / splitTextTo * splitTextTo, this.text.length());
            }
        } else {
            toShow = this.text;
        }
        if (txt != null) {
            txt.setInnerHtml(toShow);
        }
        this.el().updateZIndex(0);
        this.sinkEvents(1);
        if (this.icon != null) {
            this.setIcon(this.icon);
        }
    }
}

