/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.resourcemanagement.client.forms.genericresources;

import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.event.SelectionChangedListener;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Dialog;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.form.ComboBox;
import com.extjs.gxt.ui.client.widget.form.FieldSet;
import com.extjs.gxt.ui.client.widget.form.FormButtonBinding;
import com.extjs.gxt.ui.client.widget.form.FormPanel;
import com.extjs.gxt.ui.client.widget.form.TextArea;
import com.extjs.gxt.ui.client.widget.form.TextField;
import com.extjs.gxt.ui.client.widget.form.Validator;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.extjs.gxt.ui.client.widget.layout.FlowLayout;
import com.extjs.gxt.ui.client.widget.layout.FormData;
import com.extjs.gxt.ui.client.widget.layout.FormLayout;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.Map;
import org.gcube.portlets.admin.resourcemanagement.client.forms.genericresources.GenericResourceCMForm;
import org.gcube.portlets.admin.resourcemanagement.client.remote.ProxyRegistry;
import org.gcube.resourcemanagement.support.client.views.validators.SelectValidator;
import org.gcube.resourcemanagement.support.shared.plugins.GenericResourcePlugin;
import org.gcube.resourcemanagement.support.shared.types.datamodel.AtomicTreeNode;

public class GenericResourceCMForm
extends Dialog {
    private FormData formData = null;
    private FormPanel form = null;
    private FieldSet pluginFieldSet = null;
    private String selectedPlugin = null;
    private Map<String, GenericResourcePlugin> loadedPlugins = null;
    private TextField<String> resName = null;

    public GenericResourceCMForm() {
        this.setLayout((Layout)new FitLayout());
        this.setHeading("Generic Resource Creation (Plugin)");
        this.setModal(true);
        this.setWidth(700);
        this.setHeight(500);
        this.setResizable(false);
        this.getButtonBar().removeAll();
        this.setHideOnButtonClick(true);
    }

    protected final void onRender(Element parent, int index) {
        super.onRender(parent, index);
        this.formData = new FormData("-20");
        this.createForm();
        this.createPluginForm();
        this.add((Component)this.form);
        this.initButtons();
        this.recalculate();
        this.doLayout(true);
        this.form.mask("Loading plugins...");
        ProxyRegistry.getProxyInstance().getGenericResourcePlugins((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public final void closeDialog() {
        this.hide();
    }

    private void setPluginFields(GenericResourcePlugin plugin) {
        if (plugin.getParams().size() == 0) {
            return;
        }
        Component select = this.pluginFieldSet.getItem(0);
        this.pluginFieldSet.removeAll();
        this.pluginFieldSet.add((Widget)select);
        for (GenericResourcePlugin.Field field : plugin.getParams()) {
            if (field.getType() != GenericResourcePlugin.FieldType.string) continue;
            TextField toAdd = new TextField();
            toAdd.setFieldLabel(String.valueOf(field.getLabel()) + (field.isRequired() ? "*" : ""));
            toAdd.setName(field.getName());
            toAdd.setAllowBlank(!field.isRequired());
            toAdd.setValue((Object)field.getDefaultValue());
            this.pluginFieldSet.add((Widget)toAdd, (LayoutData)this.formData);
            this.pluginFieldSet.recalculate();
            this.doLayout(true);
        }
    }

    private void addPluginSelect(Map<String, GenericResourcePlugin> plugins) {
        ListStore store = new ListStore();
        for (String pluginName : plugins.keySet()) {
            store.add((ModelData)new AtomicTreeNode(pluginName));
        }
        ComboBox combo = new ComboBox();
        combo.setFieldLabel("Plugin");
        combo.addSelectionChangedListener((SelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        combo.setEmptyText("Select a plugin...");
        combo.setDisplayField("name");
        combo.setStore(store);
        combo.setTypeAhead(true);
        combo.setValidator((Validator)new SelectValidator(false));
        combo.setAllowBlank(false);
        combo.setForceSelection(true);
        combo.setTriggerAction(ComboBox.TriggerAction.ALL);
        combo.recalculate();
        this.pluginFieldSet.recalculate();
        this.pluginFieldSet.add((Widget)combo, (LayoutData)this.formData);
        this.doLayout(true);
        this.loadedPlugins = plugins;
    }

    private void createForm() {
        this.form = new FormPanel();
        this.form.setFrame(true);
        this.form.setAutoWidth(true);
        this.form.setHeaderVisible(false);
        this.form.getHeader().setStyleName("x-hide-panel-header");
        this.form.setLayout((Layout)new FlowLayout());
        this.form.setScrollMode(Style.Scroll.AUTO);
        FieldSet formHead = new FieldSet();
        formHead.setHeading("Basic parameters");
        formHead.setCollapsible(true);
        FormLayout layout = new FormLayout();
        layout.setLabelWidth(90);
        formHead.setLayout((Layout)layout);
        TextField resID = new TextField();
        resID.setFieldLabel("Resource ID");
        resID.setAllowBlank(false);
        resID.setEmptyText("<generated by Resource Manager>");
        resID.setEnabled(false);
        formHead.add((Widget)resID, (LayoutData)this.formData);
        this.resName = new TextField();
        this.resName.setFieldLabel("Resource Name");
        this.resName.setAllowBlank(false);
        this.resName.setValue((Object)"CMSRecord");
        this.resName.setEnabled(false);
        formHead.add((Widget)this.resName, (LayoutData)this.formData);
        ComboBox resType = new ComboBox();
        ListStore storePlugin = new ListStore();
        storePlugin.add((ModelData)new AtomicTreeNode("ActivationRecord"));
        storePlugin.add((ModelData)new AtomicTreeNode("VirtualCollection"));
        resType.setStore(storePlugin);
        resType.setFieldLabel("Secondary Type");
        resType.setValue((ModelData)((AtomicTreeNode)storePlugin.getAt(0)));
        resType.setDisplayField("name");
        resType.setAllowBlank(false);
        resType.setTypeAhead(true);
        resType.setTriggerAction(ComboBox.TriggerAction.ALL);
        resType.setForceSelection(true);
        resType.addSelectionChangedListener((SelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        formHead.add((Widget)resType, (LayoutData)this.formData);
        TextArea description = new TextArea();
        description.setFieldLabel("Description");
        description.setPreventScrollbars(false);
        formHead.add((Widget)description, (LayoutData)this.formData);
        this.form.add((Widget)formHead);
    }

    private void createPluginForm() {
        this.pluginFieldSet = new FieldSet();
        this.pluginFieldSet.setHeading("Plugin parameters");
        this.pluginFieldSet.setCollapsible(true);
        FormLayout layout = new FormLayout();
        layout.setLabelWidth(110);
        this.pluginFieldSet.setLayout((Layout)layout);
        this.form.add((Widget)this.pluginFieldSet);
    }

    public final void initButtons() {
        4 submitBtn = new /* Unavailable Anonymous Inner Class!! */;
        this.form.addButton((Button)submitBtn);
        this.form.addButton((Button)new /* Unavailable Anonymous Inner Class!! */);
        FormButtonBinding binding = new FormButtonBinding(this.form);
        binding.addButton((Button)submitBtn);
    }

    static /* synthetic */ void access$0(GenericResourceCMForm genericResourceCMForm, Map map) {
        genericResourceCMForm.addPluginSelect(map);
    }

    static /* synthetic */ FormPanel access$1(GenericResourceCMForm genericResourceCMForm) {
        return genericResourceCMForm.form;
    }

    static /* synthetic */ void access$2(GenericResourceCMForm genericResourceCMForm, String string) {
        genericResourceCMForm.selectedPlugin = string;
    }

    static /* synthetic */ Map access$3(GenericResourceCMForm genericResourceCMForm) {
        return genericResourceCMForm.loadedPlugins;
    }

    static /* synthetic */ void access$4(GenericResourceCMForm genericResourceCMForm, GenericResourcePlugin genericResourcePlugin) {
        genericResourceCMForm.setPluginFields(genericResourcePlugin);
    }

    static /* synthetic */ TextField access$5(GenericResourceCMForm genericResourceCMForm) {
        return genericResourceCMForm.resName;
    }

    static /* synthetic */ String access$6(GenericResourceCMForm genericResourceCMForm) {
        return genericResourceCMForm.selectedPlugin;
    }
}

