/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.dataminermanagerdeployer.server.poolmanager;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import org.gcube.portlets.admin.dataminermanagerdeployer.server.is.InformationSystemUtils;
import org.gcube.portlets.admin.dataminermanagerdeployer.server.util.ServiceCredentials;
import org.gcube.portlets.admin.dataminermanagerdeployer.shared.config.DMDeployConfig;
import org.gcube.portlets.admin.dataminermanagerdeployer.shared.exception.ServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataMinerPoolManager {
    private static Logger logger = LoggerFactory.getLogger(DataMinerPoolManager.class);
    private String serverUrl;
    private ServiceCredentials serviceCredentials;

    public DataMinerPoolManager(ServiceCredentials serviceCredentials) throws ServiceException {
        this.serviceCredentials = serviceCredentials;
        this.serverUrl = InformationSystemUtils.retrieveDataMinerPoolManager((String)serviceCredentials.getScope());
    }

    public String deployAlgorithm(DMDeployConfig dmDeployConfig) throws ServiceException {
        String operationId = this.sendRequest(dmDeployConfig);
        return operationId;
    }

    public String getDeployOperationLogs(String operationId) throws ServiceException {
        String logs = this.retrieveDeployOperationLogs(operationId);
        return logs;
    }

    public String getDeployOperationLogsLink(String operationId) throws ServiceException {
        String logsLink = this.retrieveDeployOperationLogsLink(operationId);
        return logsLink;
    }

    public String getDeployOperationStatus(String operationId) throws ServiceException {
        String deployStatus = this.retrieveDeployOperationStatus(operationId);
        return deployStatus;
    }

    private String sendRequest(DMDeployConfig dmDeployConfig) throws ServiceException {
        logger.info("Send request to DataMinerPoolManager: " + this.serverUrl);
        try {
            String requestUrl = this.serverUrl + "/algorithm/" + dmDeployConfig.getDeployType() + "?gcube-token=" + this.serviceCredentials.getToken() + "&algorithmPackageURL=" + dmDeployConfig.getAlgorithmPackageURL() + "&algorithm_type=transducerers&category=" + dmDeployConfig.getAlgorithmCategory() + "&targetVRE=" + dmDeployConfig.getTargetVRE();
            logger.debug("DataMinerPoolManager request=" + requestUrl);
            URL urlObj = new URL(requestUrl);
            HttpURLConnection connection = (HttpURLConnection)urlObj.openConnection();
            connection.setRequestMethod("GET");
            InputStream is = connection.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            String line = null;
            StringBuffer operationId = new StringBuffer();
            logger.info("DataMinerPoolManager response: ");
            while ((line = reader.readLine()) != null) {
                logger.info(line);
                operationId.append(line);
            }
            return operationId.toString();
        }
        catch (MalformedURLException e) {
            logger.error("DataMinerPoolManager URL seems to be invalid: " + e.getLocalizedMessage(), (Throwable)e);
            throw new ServiceException("DataMinerPoolManager URL seems to be invalid: " + e.getLocalizedMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error("DataMinerPoolManager error occured in request: " + e.getLocalizedMessage(), (Throwable)e);
            throw new ServiceException("DataMinerPoolManager error occured in request: " + e.getLocalizedMessage(), (Throwable)e);
        }
        catch (Throwable e) {
            logger.error("DataMinerPoolManager error occured: " + e.getLocalizedMessage(), e);
            throw new ServiceException("DataMinerPoolManager error occured: " + e.getLocalizedMessage(), e);
        }
    }

    private String retrieveDeployOperationStatus(String operationId) throws ServiceException {
        logger.info("Send monitor request to DataMinerPoolManager: " + this.serverUrl);
        try {
            String requestUrl = this.serverUrl + "/monitor?gcube-token=" + this.serviceCredentials.getToken() + "&logUrl=" + operationId;
            logger.debug("DataMinerPoolManager monitor request=" + requestUrl);
            URL urlObj = new URL(requestUrl);
            HttpURLConnection connection = (HttpURLConnection)urlObj.openConnection();
            connection.setRequestMethod("GET");
            InputStream is = connection.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            String line = null;
            StringBuffer operationStatus = new StringBuffer();
            logger.info("DataMinerPoolManager response: ");
            while ((line = reader.readLine()) != null) {
                logger.info(line);
                operationStatus.append(line);
            }
            return operationStatus.toString();
        }
        catch (MalformedURLException e) {
            logger.error("DataMinerPoolManager monitor URL seems to be invalid: " + e.getLocalizedMessage(), (Throwable)e);
            throw new ServiceException("DataMinerPoolManager monitor URL seems to be invalid: " + e.getLocalizedMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error("DataMinerPoolManager error occured in monitor request: " + e.getLocalizedMessage(), (Throwable)e);
            throw new ServiceException("DataMinerPoolManager error occured in monitor request: " + e.getLocalizedMessage(), (Throwable)e);
        }
        catch (Throwable e) {
            logger.error("DataMinerPoolManager monitor error occured: " + e.getLocalizedMessage(), e);
            throw new ServiceException("DataMinerPoolManager monitor error occured: " + e.getLocalizedMessage(), e);
        }
    }

    private String retrieveDeployOperationLogs(String operationId) throws ServiceException {
        logger.info("Send logs info request to DataMinerPoolManager: " + this.serverUrl);
        try {
            String requestUrl = this.serverUrl + "/log?gcube-token=" + this.serviceCredentials.getToken() + "&logUrl=" + operationId;
            logger.debug("DataMinerPoolManager logs request=" + requestUrl);
            URL urlObj = new URL(requestUrl);
            HttpURLConnection connection = (HttpURLConnection)urlObj.openConnection();
            connection.setRequestMethod("GET");
            InputStream is = connection.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            String line = null;
            StringBuffer operationStatus = new StringBuffer();
            logger.info("DataMinerPoolManager response: ");
            while ((line = reader.readLine()) != null) {
                logger.info(line);
                operationStatus.append(line);
            }
            return operationStatus.toString();
        }
        catch (MalformedURLException e) {
            logger.error("DataMinerPoolManager problem retrieving operation logs URL seems to be invalid: " + e.getLocalizedMessage(), (Throwable)e);
            throw new ServiceException("DataMinerPoolManager problem retrieving operation logs URL seems to be invalid: " + e.getLocalizedMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error("DataMinerPoolManager problem retrieving operation logs: " + e.getLocalizedMessage(), (Throwable)e);
            throw new ServiceException("DataMinerPoolManager problem retrieving operation logs: " + e.getLocalizedMessage(), (Throwable)e);
        }
        catch (Throwable e) {
            logger.error("DataMinerPoolManager error occured retrieving operation logs: " + e.getLocalizedMessage(), e);
            throw new ServiceException("DataMinerPoolManager error occured retrieving operation logs: " + e.getLocalizedMessage(), e);
        }
    }

    private String retrieveDeployOperationLogsLink(String operationId) throws ServiceException {
        logger.info("Retrieve deploy operation logs link for: [operationId=" + operationId + ", server=" + this.serverUrl + "]");
        String requestUrl = this.serverUrl + "/log?gcube-token=" + this.serviceCredentials.getToken() + "&logUrl=" + operationId;
        logger.debug("DataMinerPoolManager monitor request=" + requestUrl);
        return requestUrl;
    }
}

