/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.accountingmanager.server.amservice.response;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.SortedMap;
import org.gcube.accounting.analytics.Info;
import org.gcube.accounting.analytics.NumberedFilter;
import org.gcube.portlets.admin.accountingmanager.server.amservice.response.SeriesResponseBuilder;
import org.gcube.portlets.admin.accountingmanager.shared.data.FilterValue;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.SeriesPortlet;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.SeriesResponse;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.portlet.SeriesPortletData;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.portlet.SeriesPortletDataTop;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.portlet.SeriesPortletDefinition;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.portlet.SeriesPortletTop;
import org.gcube.portlets.admin.accountingmanager.shared.exception.ServiceException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeriesResponse4PortletTop
extends SeriesResponseBuilder {
    protected static Logger logger = LoggerFactory.getLogger(SeriesResponse4PortletTop.class);
    private Boolean showOthers;
    private Integer topNumber;
    private SortedMap<NumberedFilter, SortedMap<Calendar, Info>> topSM;

    public SeriesResponse4PortletTop(Boolean showOthers, Integer topNumber, SortedMap<NumberedFilter, SortedMap<Calendar, Info>> topSM) {
        this.showOthers = showOthers;
        this.topNumber = topNumber;
        this.topSM = topSM;
    }

    public void buildSeriesResponse() throws ServiceException {
        try {
            if (this.topSM == null || this.topSM.isEmpty()) {
                logger.error("Error creating series for portlet accounting: No data available!");
                throw new ServiceException("No data available!");
            }
            ArrayList<SeriesPortletDataTop> seriesPortletDataTopList = new ArrayList<SeriesPortletDataTop>();
            for (NumberedFilter topValue : this.topSM.keySet()) {
                ArrayList<SeriesPortletData> series = new ArrayList<SeriesPortletData>();
                SortedMap infos = (SortedMap)this.topSM.get(topValue);
                for (Info info : infos.values()) {
                    JSONObject jso = info.getValue();
                    Long operationCount = jso.getLong("operationCount");
                    series.add(new SeriesPortletData(info.getCalendar().getTime(), operationCount));
                }
                SeriesPortletDataTop seriesPortletDataTop = new SeriesPortletDataTop(new FilterValue(topValue.getValue()), series);
                seriesPortletDataTopList.add(seriesPortletDataTop);
            }
            SeriesPortletTop seriesPortletTop = new SeriesPortletTop(this.showOthers, this.topNumber, seriesPortletDataTopList);
            SeriesPortlet seriesPortlet = new SeriesPortlet((SeriesPortletDefinition)seriesPortletTop);
            this.seriesResponseSpec.setSr((SeriesResponse)seriesPortlet);
        }
        catch (Throwable e) {
            logger.error("Error creating series for portlet accounting top chart: " + e.getLocalizedMessage());
            e.printStackTrace();
            throw new ServiceException("Error creating series for portlet accounting top chart: " + e.getLocalizedMessage());
        }
    }
}

