/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.accountingmanager.client;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.SimpleEventBus;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.i18n.client.LocaleInfo;
import com.google.gwt.user.client.Cookies;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.datepicker.client.CalendarUtil;
import com.sencha.gxt.widget.core.client.container.BorderLayoutContainer;
import java.util.Date;
import org.gcube.portal.clientcontext.client.GCubeClientContext;
import org.gcube.portlets.admin.accountingmanager.client.AccountingManagerController;
import org.gcube.portlets.admin.accountingmanager.client.event.AccountingMenuEvent;
import org.gcube.portlets.admin.accountingmanager.client.event.EnableTabsEvent;
import org.gcube.portlets.admin.accountingmanager.client.event.ExportRequestEvent;
import org.gcube.portlets.admin.accountingmanager.client.event.FiltersChangeEvent;
import org.gcube.portlets.admin.accountingmanager.client.event.SessionExpiredEvent;
import org.gcube.portlets.admin.accountingmanager.client.event.StateChangeEvent;
import org.gcube.portlets.admin.accountingmanager.client.event.UIStateEvent;
import org.gcube.portlets.admin.accountingmanager.client.monitor.AccountingMonitor;
import org.gcube.portlets.admin.accountingmanager.client.monitor.MonitorRequest;
import org.gcube.portlets.admin.accountingmanager.client.monitor.MonitorRequestEvent;
import org.gcube.portlets.admin.accountingmanager.client.rpc.AccountingManagerServiceAsync;
import org.gcube.portlets.admin.accountingmanager.client.state.AccountingClientState;
import org.gcube.portlets.admin.accountingmanager.client.state.AccountingClientStateData;
import org.gcube.portlets.admin.accountingmanager.client.type.SessionExpiredType;
import org.gcube.portlets.admin.accountingmanager.client.type.StateChangeType;
import org.gcube.portlets.admin.accountingmanager.client.type.UIStateType;
import org.gcube.portlets.admin.accountingmanager.client.util.UtilsGXT3;
import org.gcube.portlets.admin.accountingmanager.shared.data.AccountingFilterBasic;
import org.gcube.portlets.admin.accountingmanager.shared.data.AccountingFilterDefinition;
import org.gcube.portlets.admin.accountingmanager.shared.data.AccountingPeriod;
import org.gcube.portlets.admin.accountingmanager.shared.data.AccountingPeriodMode;
import org.gcube.portlets.admin.accountingmanager.shared.data.AccountingType;
import org.gcube.portlets.admin.accountingmanager.shared.data.query.SeriesRequest;
import org.gcube.portlets.admin.accountingmanager.shared.session.UserInfo;
import org.gcube.portlets.admin.accountingmanager.shared.tabs.EnableTab;
import org.gcube.portlets.admin.accountingmanager.shared.tabs.EnableTabs;
import org.gcube.portlets.admin.accountingmanager.shared.workspace.ItemDescription;

public class AccountingManagerController {
    private SimpleEventBus eventBus = new SimpleEventBus();
    private UserInfo userInfo;
    private Boolean rootScope;
    private AccountingClientState accountingState = new AccountingClientState();
    private AccountingType accountingType;
    private BorderLayoutContainer mainPanel;
    private AccountingMonitor accountingMonitor;
    private EnableTabs enableTabs;

    public AccountingManagerController() {
        this.init();
    }

    private void init() {
        this.callHello();
        this.bindToEvents();
    }

    private void sessionExpiredShow() {
        Log.error((String)"Session expired");
    }

    public EventBus getEventBus() {
        return this.eventBus;
    }

    public void setMainPanelLayout(BorderLayoutContainer mainPanel) {
        this.mainPanel = mainPanel;
    }

    private void callHello() {
        AccountingManagerServiceAsync.INSTANCE.hello((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void isRootScope() {
        AccountingManagerServiceAsync.INSTANCE.isRootScope((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void retrieveEnableTabs() {
        AccountingManagerServiceAsync.INSTANCE.getEnableTabs((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void doEnableTabs(EnableTabs enableTabs) {
        if (enableTabs == null || enableTabs.getTabs() == null || enableTabs.getTabs().isEmpty()) {
            UtilsGXT3.alert((String)"Attention", (String)"You don't have permissions to see Accounting Information in this scope!");
        } else {
            this.enableTabs = enableTabs;
            EnableTabsEvent event = new EnableTabsEvent(enableTabs);
            this.eventBus.fireEvent((GwtEvent)event);
        }
    }

    private void sessionExpiredShowDelayed() {
        4 timeoutTimer = new /* Unavailable Anonymous Inner Class!! */;
        int TIMEOUT = 3;
        timeoutTimer.schedule(TIMEOUT * 1000);
    }

    private void checkLocale() {
        String[] locales;
        for (String locale : locales = LocaleInfo.getAvailableLocaleNames()) {
            Log.debug((String)("Locale avaible:" + locale));
        }
        String currentLocaleCookie = Cookies.getCookie((String)LocaleInfo.getLocaleCookieName());
        Log.debug((String)("AMLangCookie:" + currentLocaleCookie));
        LocaleInfo currentLocaleInfo = LocaleInfo.getCurrentLocale();
        Log.debug((String)("Current Locale:" + currentLocaleInfo.getLocaleName()));
    }

    protected void changeLanguage(String localeName) {
        Date now = new Date();
        long nowLong = now.getTime();
        now.setTime(nowLong += 1814400000L);
        String cookieLang = Cookies.getCookie((String)"AMLangCookie");
        if (cookieLang != null) {
            Cookies.removeCookie((String)"AMLangCookie");
        }
        Cookies.setCookie((String)"AMLangCookie", (String)localeName, (Date)now);
        Window.Location.reload();
    }

    public void restoreUISession() {
        this.checkLocale();
        this.showDefault();
    }

    private void bindToEvents() {
        this.eventBus.addHandler(SessionExpiredEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.eventBus.addHandler(AccountingMenuEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.eventBus.addHandler(FiltersChangeEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.eventBus.addHandler(ExportRequestEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.eventBus.fireEvent((GwtEvent)new UIStateEvent(UIStateType.START));
    }

    private void doMenuCommand(AccountingMenuEvent event) {
        AccountingClientStateData accountingStateData = null;
        if (event == null || event.getAccountingType() == null) {
            return;
        }
        switch (19.$SwitchMap$org$gcube$portlets$admin$accountingmanager$shared$data$AccountingType[event.getAccountingType().ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                Log.debug((String)("AccountingType: " + event.getAccountingType()));
                accountingStateData = this.accountingState.getState(event.getAccountingType());
                if (accountingStateData == null) {
                    this.createDefaultChart(event.getAccountingType());
                    break;
                }
                this.accountingType = event.getAccountingType();
                StateChangeEvent stateChangeEvent = new StateChangeEvent(StateChangeType.Restore, accountingStateData);
                this.eventBus.fireEvent((GwtEvent)stateChangeEvent);
                break;
            }
        }
    }

    public void showDefault() {
        if (this.enableTabs != null && this.enableTabs.getTabs() != null && this.enableTabs.getTabs().size() > 0 && this.enableTabs.getTabs().get(0) != null) {
            this.createDefaultChart(((EnableTab)this.enableTabs.getTabs().get(0)).getAccountingType());
        }
    }

    private void createDefaultChart(AccountingType accountingType) {
        this.accountingMonitor = new AccountingMonitor();
        Date now = new Date();
        DateTimeFormat dtf = DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.YEAR_MONTH_DAY);
        String currentDate = dtf.format(now);
        Date date = dtf.parse(currentDate);
        Date lastMonth = new Date(date.getTime());
        CalendarUtil.addMonthsToDate((Date)lastMonth, (int)-1);
        SeriesRequest seriesRequest = new SeriesRequest(new AccountingPeriod(dtf.format(lastMonth), dtf.format(date), AccountingPeriodMode.DAILY), (AccountingFilterDefinition)new AccountingFilterBasic());
        Log.debug((String)("DefaultSeriesRequest: " + seriesRequest));
        Log.debug((String)("LastMoth= " + dtf.format(lastMonth) + " , date=" + dtf.format(date)));
        this.accountingType = accountingType;
        AccountingClientStateData accountingStateData = new AccountingClientStateData(accountingType, seriesRequest, null, null, null, this.rootScope);
        this.accountingState.setState(accountingType, accountingStateData);
        this.retrieveFilterKey();
    }

    private void retrieveFilterKey() {
        AccountingManagerServiceAsync.INSTANCE.getFilterKeys(this.accountingType, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void retrieveContext() {
        AccountingManagerServiceAsync.INSTANCE.getContext((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void callDefaultSeriesRequest() {
        AccountingManagerServiceAsync.INSTANCE.getSeriesInCache(this.accountingType, this.accountingState.getState(this.accountingType).getSeriesRequest(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void callDefaultSeriesRequestNoCache() {
        AccountingManagerServiceAsync.INSTANCE.getSeries(this.accountingType, this.accountingState.getState(this.accountingType).getSeriesRequest(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void defaultOperationMonitor(String operationId) {
        MonitorRequest monitorRequest = new MonitorRequest();
        13 handler = new /* Unavailable Anonymous Inner Class!! */;
        monitorRequest.addHandler((MonitorRequestEvent.MonitorRequestEventHandler)handler);
        monitorRequest.start();
    }

    private void doFiltersChangeCommand(FiltersChangeEvent event) {
        if (event == null || event.getFiltersChangeType() == null) {
            return;
        }
        switch (19.$SwitchMap$org$gcube$portlets$admin$accountingmanager$client$type$FiltersChangeType[event.getFiltersChangeType().ordinal()]) {
            case 1: {
                SeriesRequest seriesRequest = event.getSeriesRequest();
                AccountingClientStateData accountingStateData = this.accountingState.getState(this.accountingType);
                if (accountingStateData == null) break;
                this.accountingMonitor = new AccountingMonitor();
                accountingStateData.setSeriesRequest(seriesRequest);
                this.accountingState.setState(this.accountingType, accountingStateData);
                this.callSeriesRequest();
                break;
            }
        }
    }

    private void callSeriesRequest() {
        Log.debug((String)("Call getSeries on server, params: " + this.accountingType + ", " + this.accountingState.getState(this.accountingType).getSeriesRequest()));
        AccountingManagerServiceAsync.INSTANCE.getSeriesInCache(this.accountingType, this.accountingState.getState(this.accountingType).getSeriesRequest(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void callSeriesRequestNoCache() {
        AccountingManagerServiceAsync.INSTANCE.getSeries(this.accountingType, this.accountingState.getState(this.accountingType).getSeriesRequest(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void operationMonitor(String operationId) {
        MonitorRequest monitorRequest = new MonitorRequest();
        16 handler = new /* Unavailable Anonymous Inner Class!! */;
        monitorRequest.addHandler((MonitorRequestEvent.MonitorRequestEventHandler)handler);
        monitorRequest.start();
    }

    private void doSaveDataOnWorkspace(ExportRequestEvent event) {
        this.accountingMonitor = new AccountingMonitor();
        Log.debug((String)("Call saveCSVOnWorkspace on server, params: " + event.getAccountingType()));
        AccountingManagerServiceAsync.INSTANCE.saveCSVOnWorkspace(event.getAccountingType(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void doDownloadCSVFromWorkspace(ItemDescription itemDescription) {
        Log.debug((String)("DownloadCSV from server: " + itemDescription));
        AccountingManagerServiceAsync.INSTANCE.getPublicLink(itemDescription, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void doExportRequest(ExportRequestEvent event) {
        StringBuilder actionUrl = new StringBuilder();
        actionUrl.append(GWT.getModuleBaseURL());
        actionUrl.append("ExportServlet?ExportServletType=" + event.getExportType().name() + "&" + "AccountingType" + "=" + event.getAccountingType().name() + "&" + "CURR_GROUP_ID" + "=" + GCubeClientContext.getCurrentContextId());
        Log.debug((String)("Retrieved link: " + actionUrl));
        Window.open((String)actionUrl.toString(), (String)event.getAccountingType().toString(), (String)"");
    }

    private void doSessionExpiredCommand(SessionExpiredEvent event) {
        Log.debug((String)("Session Expired Event: " + event.getSessionExpiredType()));
        this.sessionExpiredShow();
    }

    private void asyncCodeLoadingFailed(Throwable reason) {
        Log.error((String)"Async code loading failed", (Throwable)reason);
        this.eventBus.fireEvent((GwtEvent)new SessionExpiredEvent(SessionExpiredType.EXPIREDONSERVER));
    }

    static /* synthetic */ void access$000(AccountingManagerController x0) {
        x0.sessionExpiredShowDelayed();
    }

    static /* synthetic */ UserInfo access$102(AccountingManagerController x0, UserInfo x1) {
        x0.userInfo = x1;
        return x0.userInfo;
    }

    static /* synthetic */ UserInfo access$100(AccountingManagerController x0) {
        return x0.userInfo;
    }

    static /* synthetic */ void access$200(AccountingManagerController x0) {
        x0.isRootScope();
    }

    static /* synthetic */ Boolean access$302(AccountingManagerController x0, Boolean x1) {
        x0.rootScope = x1;
        return x0.rootScope;
    }

    static /* synthetic */ void access$400(AccountingManagerController x0) {
        x0.retrieveEnableTabs();
    }

    static /* synthetic */ void access$500(AccountingManagerController x0, EnableTabs x1) {
        x0.doEnableTabs(x1);
    }

    static /* synthetic */ void access$600(AccountingManagerController x0) {
        x0.sessionExpiredShow();
    }

    static /* synthetic */ void access$700(AccountingManagerController x0, SessionExpiredEvent x1) {
        x0.doSessionExpiredCommand(x1);
    }

    static /* synthetic */ void access$800(AccountingManagerController x0, AccountingMenuEvent x1) {
        x0.doMenuCommand(x1);
    }

    static /* synthetic */ void access$900(AccountingManagerController x0, FiltersChangeEvent x1) {
        x0.doFiltersChangeCommand(x1);
    }

    static /* synthetic */ void access$1000(AccountingManagerController x0, ExportRequestEvent x1) {
        x0.doExportRequest(x1);
    }

    static /* synthetic */ AccountingMonitor access$1100(AccountingManagerController x0) {
        return x0.accountingMonitor;
    }

    static /* synthetic */ SimpleEventBus access$1200(AccountingManagerController x0) {
        return x0.eventBus;
    }

    static /* synthetic */ AccountingType access$1300(AccountingManagerController x0) {
        return x0.accountingType;
    }

    static /* synthetic */ AccountingClientState access$1400(AccountingManagerController x0) {
        return x0.accountingState;
    }

    static /* synthetic */ void access$1500(AccountingManagerController x0) {
        x0.retrieveContext();
    }

    static /* synthetic */ void access$1600(AccountingManagerController x0) {
        x0.callDefaultSeriesRequest();
    }

    static /* synthetic */ void access$1700(AccountingManagerController x0) {
        x0.callDefaultSeriesRequestNoCache();
    }

    static /* synthetic */ void access$1800(AccountingManagerController x0, String x1) {
        x0.defaultOperationMonitor(x1);
    }

    static /* synthetic */ void access$1900(AccountingManagerController x0) {
        x0.callSeriesRequestNoCache();
    }

    static /* synthetic */ void access$2000(AccountingManagerController x0, String x1) {
        x0.operationMonitor(x1);
    }

    static /* synthetic */ void access$2100(AccountingManagerController x0, ItemDescription x1) {
        x0.doDownloadCSVFromWorkspace(x1);
    }
}

