/**
 * 
 */
package org.gcube.portlets.admin.accountingmanager.server;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpSession;

import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.portal.custom.scopemanager.scopehelper.ScopeHelper;
import org.gcube.portlets.admin.accountingmanager.server.state.AccountingState;
import org.gcube.portlets.admin.accountingmanager.server.state.AccountingStateData;
import org.gcube.portlets.admin.accountingmanager.shared.Constants;
import org.gcube.portlets.admin.accountingmanager.shared.data.AccountingType;
import org.gcube.portlets.admin.accountingmanager.shared.data.Context;
import org.gcube.portlets.admin.accountingmanager.shared.exception.ServiceException;
import org.gcube.portlets.admin.accountingmanager.shared.exception.SessionExpiredException;
import org.gcube.vomanagement.usermanagement.GroupManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayGroupManager;
import org.gcube.vomanagement.usermanagement.model.GCubeGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 
 * @author "Giancarlo Panichi" <a
 *         href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a>
 * 
 */
public class SessionUtil {

	private static Logger logger = LoggerFactory.getLogger(SessionUtil.class);

	public static ASLSession getASLSession(HttpSession httpSession)
			throws ServiceException {
		String username = (String) httpSession
				.getAttribute(ScopeHelper.USERNAME_ATTRIBUTE);
		ASLSession portalContext;
		if (username == null) {
			if (Constants.DEBUG_MODE) {
				logger.info("no user found in session, use test user");

				// Remove comment for Test
				username = org.gcube.portlets.admin.accountingmanager.shared.Constants.DEFAULT_USER;
				String scope = Constants.DEFAULT_SCOPE;

				httpSession.setAttribute(ScopeHelper.USERNAME_ATTRIBUTE,
						username);
				portalContext = SessionManager.getInstance().getASLSession(
						httpSession.getId(), username);
				portalContext.setScope(scope);
			} else {
				logger.info("No user found in session");
				throw new SessionExpiredException("Session Expired!");

			}
		} else {
			portalContext = SessionManager.getInstance().getASLSession(
					httpSession.getId(), username);

		}

		logger.info("SessionUtil: aslSession " + portalContext.getUsername()
				+ " " + portalContext.getScope());

		return portalContext;
	}

	public static String getToken(ASLSession aslSession)
			throws ServiceException {
		String token = null;
		if (Constants.DEBUG_MODE) {
			token = Constants.DEFAULT_TOKEN;
		} else {
			token = aslSession.getSecurityToken();
		}
		logger.info("received token: " + token);
		return token;

	}

	public static void setAccountingStateData(HttpSession httpSession,
			AccountingType accountingType,
			AccountingStateData accountingStateData) {
		AccountingState accountingState = (AccountingState) httpSession
				.getAttribute(Constants.SESSION_ACCOUNTING_STATE);

		if (accountingState == null) {
			accountingState = new AccountingState();
			accountingState.setState(accountingType, accountingStateData);
			httpSession.setAttribute(Constants.SESSION_ACCOUNTING_STATE,
					accountingState);
		} else {
			accountingState.setState(accountingType, accountingStateData);
		}

		return;
	}

	public static AccountingStateData getAccountingStateData(
			HttpSession httpSession, AccountingType accountingType) {
		AccountingState accountingState = (AccountingState) httpSession
				.getAttribute(Constants.SESSION_ACCOUNTING_STATE);
		if (accountingState == null) {
			return null;
		} else {
			return accountingState.getState(accountingType);
		}
	}

	public static Context getContext(ASLSession aslSession)
			throws ServiceException {

		try {
			logger.info("Current context is " + aslSession.getScope());
			ArrayList<String> contexts = new ArrayList<>();

			if (Constants.DEBUG_MODE) {
				contexts.add(aslSession.getScope());
				for(int i=0; i<50 ; i++){
					contexts.add("/d4science.research-infrastructures.eu/gCubeApps/PerformanceEvaluationInAquaculture"+i);
				}
			} else {
				contexts.add(aslSession.getScope());
				GroupManager gm = new LiferayGroupManager();
				long currentGroupId = gm
						.getGroupIdFromInfrastructureScope(aslSession
								.getScope());
				GCubeGroup currentGroup = gm.getGroup(currentGroupId);

				// three cases
				if (gm.isVRE(currentGroupId)) {

					// do nothing

				} else if (gm.isVO(currentGroupId)) {

					// iterate over its vres
					List<GCubeGroup> children = currentGroup.getChildren();
					for (GCubeGroup gCubeGroup : children) {
						contexts.add(gm.getInfrastructureScope(gCubeGroup
								.getGroupId()));
					}

				} else {

					// is root
					List<GCubeGroup> children = currentGroup.getChildren();
					for (GCubeGroup gCubeGroup : children) {
						contexts.add(gm.getInfrastructureScope(gCubeGroup
								.getGroupId()));

						// get the vo children
						List<GCubeGroup> childrenVO = gCubeGroup.getChildren();
						for (GCubeGroup voChildren : childrenVO) {
							contexts.add(gm.getInfrastructureScope(voChildren
									.getGroupId()));
						}
					}

				}
			}
			// add the current scope too
			Context context = new Context(contexts);

			return context;

		} catch (Exception e) {
			logger.error("Error retrieving context!", e);
			throw new ServiceException("Error retrieving context!", e);
		}

	}

}
