/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.accountingmanager.server;

import java.util.ArrayList;
import javax.servlet.http.HttpSession;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.portlets.admin.accountingmanager.server.state.AccountingState;
import org.gcube.portlets.admin.accountingmanager.server.state.AccountingStateData;
import org.gcube.portlets.admin.accountingmanager.shared.data.AccountingType;
import org.gcube.portlets.admin.accountingmanager.shared.data.Context;
import org.gcube.portlets.admin.accountingmanager.shared.exception.ServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionUtil {
    private static Logger logger = LoggerFactory.getLogger(SessionUtil.class);

    public static ASLSession getASLSession(HttpSession httpSession) throws ServiceException {
        ASLSession portalContext;
        String username = (String)httpSession.getAttribute("username");
        if (username == null) {
            logger.info("no user found in session, use test user");
            username = "giancarlo.panichi";
            String scope = "/gcube/devNext/NextNext";
            httpSession.setAttribute("username", (Object)username);
            portalContext = SessionManager.getInstance().getASLSession(httpSession.getId(), username);
            portalContext.setScope(scope);
        } else {
            portalContext = SessionManager.getInstance().getASLSession(httpSession.getId(), username);
        }
        logger.info("SessionUtil: aslSession " + portalContext.getUsername() + " " + portalContext.getScope());
        return portalContext;
    }

    public static String getToken(ASLSession aslSession) throws ServiceException {
        String token = null;
        token = "ae1208f0-210d-47c9-9b24-d3f2dfcce05f-98187548";
        logger.info("received token: " + token);
        return token;
    }

    public static void setAccountingStateData(HttpSession httpSession, AccountingType accountingType, AccountingStateData accountingStateData) {
        AccountingState accountingState = (AccountingState)httpSession.getAttribute("ACCOUNTING_STATE");
        if (accountingState == null) {
            accountingState = new AccountingState();
            accountingState.setState(accountingType, accountingStateData);
            httpSession.setAttribute("ACCOUNTING_STATE", (Object)accountingState);
        } else {
            accountingState.setState(accountingType, accountingStateData);
        }
    }

    public static AccountingStateData getAccountingStateData(HttpSession httpSession, AccountingType accountingType) {
        AccountingState accountingState = (AccountingState)httpSession.getAttribute("ACCOUNTING_STATE");
        if (accountingState == null) {
            return null;
        }
        return accountingState.getState(accountingType);
    }

    public static Context getContext(ASLSession aslSession) throws ServiceException {
        try {
            logger.info("Current context is " + aslSession.getScope());
            ArrayList<String> contexts = new ArrayList<String>();
            contexts.add(aslSession.getScope());
            for (int i = 0; i < 50; ++i) {
                contexts.add("/d4science.research-infrastructures.eu/gCubeApps/PerformanceEvaluationInAquaculture" + i);
            }
            Context context = new Context(contexts);
            return context;
        }
        catch (Exception e) {
            logger.error("Error retrieving context!", (Throwable)e);
            throw new ServiceException("Error retrieving context!", (Throwable)e);
        }
    }
}

