/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.accountingmanager.client.maindata.charts.storage;

import com.allen_sauer.gwt.log.client.Log;
import com.github.highcharts4gwt.client.view.widget.HighchartsLayoutPanel;
import com.github.highcharts4gwt.model.array.api.ArrayNumber;
import com.github.highcharts4gwt.model.array.api.ArrayString;
import com.github.highcharts4gwt.model.factory.api.HighchartsOptionFactory;
import com.github.highcharts4gwt.model.factory.jso.JsoHighchartsOptionFactory;
import com.github.highcharts4gwt.model.highcharts.option.api.ChartOptions;
import com.github.highcharts4gwt.model.highcharts.option.api.SeriesColumn;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import com.sencha.gxt.cell.core.client.ButtonCell;
import com.sencha.gxt.core.client.util.Margins;
import com.sencha.gxt.widget.core.client.button.TextButton;
import com.sencha.gxt.widget.core.client.container.BoxLayoutContainer;
import com.sencha.gxt.widget.core.client.container.MarginData;
import com.sencha.gxt.widget.core.client.container.SimpleContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import com.sencha.gxt.widget.core.client.menu.Menu;
import com.sencha.gxt.widget.core.client.menu.MenuItem;
import com.sencha.gxt.widget.core.client.toolbar.ToolBar;
import java.util.ArrayList;
import java.util.Date;
import org.gcube.portlets.admin.accountingmanager.client.event.ExportRequestEvent;
import org.gcube.portlets.admin.accountingmanager.client.maindata.charts.storage.StorageChartTopPanel;
import org.gcube.portlets.admin.accountingmanager.client.maindata.charts.utils.ByteUnitMeasure;
import org.gcube.portlets.admin.accountingmanager.client.maindata.charts.utils.ChartTimeMeasure;
import org.gcube.portlets.admin.accountingmanager.client.maindata.charts.utils.StorageChartMeasure;
import org.gcube.portlets.admin.accountingmanager.client.resource.AccountingManagerResources;
import org.gcube.portlets.admin.accountingmanager.client.state.AccountingClientStateData;
import org.gcube.portlets.admin.accountingmanager.shared.data.AccountingPeriod;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.SeriesStorage;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.storage.SeriesStorageData;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.storage.SeriesStorageDataTop;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.storage.SeriesStorageTop;
import org.gcube.portlets.admin.accountingmanager.shared.export.ExportType;

public class StorageChartTopPanel
extends SimpleContainer {
    private static final String DATA_VOLUME_UNIT = "Data Volume Unit";
    private DateTimeFormat dtf = DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.YEAR_MONTH_DAY);
    private EventBus eventBus;
    private AccountingClientStateData accountingStateData;
    private HighchartsLayoutPanel highchartsLayoutPanel;
    private MenuItem downloadCSVItem;
    private MenuItem downloadXMLItem;
    private MenuItem downloadJSONItem;
    private MenuItem downloadPNGItem;
    private MenuItem downloadJPGItem;
    private MenuItem downloadPDFItem;
    private MenuItem downloadSVGItem;
    private MenuItem dataVolumeItem;
    private MenuItem operationCountItem;
    private MenuItem kBItem;
    private MenuItem MBItem;
    private MenuItem GBItem;
    private MenuItem TBItem;
    private long unitMeasure = ByteUnitMeasure.getMegaByteDimForStorage();
    private String unitMeasureLabel = "MB";
    private TextButton unitButton;
    private ChartOptions options;
    private StorageChartMeasure measure = StorageChartMeasure.DataVolume;
    private TextButton measureButton;
    private VerticalLayoutContainer vert;

    public StorageChartTopPanel(EventBus eventBus, AccountingClientStateData accountingStateData) {
        this.eventBus = eventBus;
        this.accountingStateData = accountingStateData;
        this.forceLayoutOnResize = true;
        this.create();
    }

    private void create() {
        ToolBar toolBar = new ToolBar();
        toolBar.setSpacing(2);
        TextButton downloadButton = new TextButton("Download", AccountingManagerResources.INSTANCE.accountingDownload24());
        downloadButton.setIconAlign(ButtonCell.IconAlign.RIGHT);
        downloadButton.setArrowAlign(ButtonCell.ButtonArrowAlign.RIGHT);
        downloadButton.setMenu(this.createDownloadMenu());
        this.measureButton = new TextButton(StorageChartMeasure.DataVolume.getLabel(), AccountingManagerResources.INSTANCE.accountingByte24());
        this.measureButton.setIconAlign(ButtonCell.IconAlign.RIGHT);
        this.measureButton.setArrowAlign(ButtonCell.ButtonArrowAlign.RIGHT);
        this.measureButton.setMenu(this.createMeasureMenu());
        this.unitButton = new TextButton(DATA_VOLUME_UNIT, AccountingManagerResources.INSTANCE.accountingUnitMB24());
        this.unitButton.setIconAlign(ButtonCell.IconAlign.RIGHT);
        this.unitButton.setArrowAlign(ButtonCell.ButtonArrowAlign.RIGHT);
        this.unitButton.setMenu(this.createUnitMenu());
        toolBar.add((IsWidget)downloadButton, new BoxLayoutContainer.BoxLayoutData(new Margins(0)));
        toolBar.add((IsWidget)this.measureButton, new BoxLayoutContainer.BoxLayoutData(new Margins(0)));
        toolBar.add((IsWidget)this.unitButton, new BoxLayoutContainer.BoxLayoutData(new Margins(0)));
        this.createChart();
        this.highchartsLayoutPanel = new HighchartsLayoutPanel();
        this.highchartsLayoutPanel.renderChart(this.options);
        this.vert = new VerticalLayoutContainer();
        this.vert.add((IsWidget)toolBar, new VerticalLayoutContainer.VerticalLayoutData(1.0, -1.0, new Margins(0)));
        this.vert.add((IsWidget)this.highchartsLayoutPanel, new VerticalLayoutContainer.VerticalLayoutData(1.0, 1.0, new Margins(0)));
        this.add((Widget)this.vert, new MarginData(0));
    }

    private void updateChart() {
        this.createChart();
        this.highchartsLayoutPanel.renderChart(this.options);
        this.forceLayout();
    }

    private Menu createDownloadMenu() {
        Menu menuDownload = new Menu();
        this.downloadCSVItem = new MenuItem("Download CSV", AccountingManagerResources.INSTANCE.accountingFileCSV24());
        this.downloadCSVItem.setHeight(30);
        this.downloadXMLItem = new MenuItem("Download XML", AccountingManagerResources.INSTANCE.accountingFileXML24());
        this.downloadXMLItem.setHeight(30);
        this.downloadJSONItem = new MenuItem("Download JSON", AccountingManagerResources.INSTANCE.accountingFileJSON24());
        this.downloadJSONItem.setHeight(30);
        this.downloadPNGItem = new MenuItem("Download PNG Image", AccountingManagerResources.INSTANCE.accountingFilePNG24());
        this.downloadPNGItem.setHeight(30);
        this.downloadJPGItem = new MenuItem("Download JPG Image", AccountingManagerResources.INSTANCE.accountingFileJPG24());
        this.downloadJPGItem.setHeight(30);
        this.downloadPDFItem = new MenuItem("Download PDF Document", AccountingManagerResources.INSTANCE.accountingFilePDF24());
        this.downloadPDFItem.setHeight(30);
        this.downloadSVGItem = new MenuItem("Download SVG Vector Image", AccountingManagerResources.INSTANCE.accountingFileSVG24());
        this.downloadSVGItem.setHeight(30);
        this.downloadCSVItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.downloadXMLItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.downloadJSONItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.downloadPNGItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.downloadJPGItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.downloadPDFItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.downloadSVGItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        menuDownload.add((Widget)this.downloadCSVItem);
        menuDownload.add((Widget)this.downloadXMLItem);
        menuDownload.add((Widget)this.downloadJSONItem);
        menuDownload.add((Widget)this.downloadPNGItem);
        menuDownload.add((Widget)this.downloadJPGItem);
        menuDownload.add((Widget)this.downloadPDFItem);
        menuDownload.add((Widget)this.downloadSVGItem);
        return menuDownload;
    }

    private Menu createMeasureMenu() {
        Menu menuMeasure = new Menu();
        this.dataVolumeItem = new MenuItem(StorageChartMeasure.DataVolume.getLabel());
        this.dataVolumeItem.setHeight(30);
        this.operationCountItem = new MenuItem(StorageChartMeasure.OperationCount.getLabel());
        this.operationCountItem.setHeight(30);
        this.dataVolumeItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.operationCountItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        menuMeasure.add((Widget)this.dataVolumeItem);
        menuMeasure.add((Widget)this.operationCountItem);
        return menuMeasure;
    }

    private Menu createUnitMenu() {
        Menu menuUnit = new Menu();
        this.kBItem = new MenuItem("KiloByte", AccountingManagerResources.INSTANCE.accountingUnitkB24());
        this.kBItem.setHeight(30);
        this.MBItem = new MenuItem("MegaByte", AccountingManagerResources.INSTANCE.accountingUnitMB24());
        this.MBItem.setHeight(30);
        this.GBItem = new MenuItem("GigaByte", AccountingManagerResources.INSTANCE.accountingUnitGB24());
        this.GBItem.setHeight(30);
        this.TBItem = new MenuItem("TeraByte", AccountingManagerResources.INSTANCE.accountingUnitTB24());
        this.TBItem.setHeight(30);
        this.kBItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.MBItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.GBItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.TBItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        menuUnit.add((Widget)this.kBItem);
        menuUnit.add((Widget)this.MBItem);
        menuUnit.add((Widget)this.GBItem);
        menuUnit.add((Widget)this.TBItem);
        return menuUnit;
    }

    private void onDownloadCSV() {
        ExportRequestEvent event = new ExportRequestEvent(ExportType.CSV, this.accountingStateData.getAccountingType());
        this.eventBus.fireEvent((GwtEvent)event);
    }

    private void onDownloadXML() {
        ExportRequestEvent event = new ExportRequestEvent(ExportType.XML, this.accountingStateData.getAccountingType());
        this.eventBus.fireEvent((GwtEvent)event);
    }

    private void onDownloadJSON() {
        ExportRequestEvent event = new ExportRequestEvent(ExportType.JSON, this.accountingStateData.getAccountingType());
        this.eventBus.fireEvent((GwtEvent)event);
    }

    public static native void onDownloadPNG(String var0);

    public static native void onDownloadJPG(String var0);

    public static native void onDownloadPDF(String var0);

    public static native void onDownloadSVG(String var0);

    private void createChart() {
        SeriesStorage seriesStorage = (SeriesStorage)this.accountingStateData.getSeriesResponse();
        if (!(seriesStorage.getSeriesStorageDefinition() instanceof SeriesStorageTop)) {
            Log.debug((String)"Invalid SeriesStorageTop!");
            return;
        }
        SeriesStorageTop seriesStorageTop = (SeriesStorageTop)seriesStorage.getSeriesStorageDefinition();
        double minRange = ChartTimeMeasure.calculateMinRange((AccountingPeriod)this.accountingStateData.getSeriesRequest().getAccountingPeriod());
        double interval = ChartTimeMeasure.calculateInterval((AccountingPeriod)this.accountingStateData.getSeriesRequest().getAccountingPeriod());
        Date dateStart = this.dtf.parse(this.accountingStateData.getSeriesRequest().getAccountingPeriod().getStartDate());
        dateStart.setTime(dateStart.getTime() + ChartTimeMeasure.timeZoneOffset() * 60000L);
        Log.debug((String)("BuildChart DateStart: " + DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.DATE_TIME_FULL).format(dateStart)));
        JsoHighchartsOptionFactory highchartsFactory = new JsoHighchartsOptionFactory();
        this.options = highchartsFactory.createChartOptions();
        this.options.chart().zoomType("xy");
        this.options.exporting().buttons().contextButton().enabled(false);
        this.options.exporting().filename("AccountingStorageTop");
        this.options.title().text("Accounting Storage Top");
        ArrayString colors = this.options.colors();
        this.options.xAxis().type("datetime").minRange(minRange);
        this.options.setFieldAsJsonObject("yAxis", this.retrieveYAxis(colors));
        this.options.plotOptions().setFieldAsJsonObject("column", "{ \"stacking\": \"normal\",\"dataLabels\": {     \"enabled\": \"true\",    \"color\": \"white\",     \"style\": {        \"textShadow\": \"0 0 3px black\"    } } }");
        ArrayList seriesColumn = new ArrayList();
        if (seriesStorageTop.getShowOthers().booleanValue()) {
            this.createSeriesColumnShowOthers(seriesStorageTop, interval, dateStart, (HighchartsOptionFactory)highchartsFactory, colors, seriesColumn);
        } else {
            this.createSeriesColumnSimple(seriesStorageTop, interval, dateStart, (HighchartsOptionFactory)highchartsFactory, colors, seriesColumn);
        }
        for (SeriesColumn serie : seriesColumn) {
            this.options.series().addToEnd((Object)serie);
        }
        this.options.chart().showAxes(true);
        this.options.legend().enabled(true);
    }

    private void createSeriesColumnShowOthers(SeriesStorageTop seriesStorageTop, double interval, Date dateStart, HighchartsOptionFactory highchartsFactory, ArrayString colors, ArrayList<SeriesColumn> seriesColumn) {
        SeriesColumn seriesColumnData;
        int i;
        Log.debug((String)"Series ShowOthers");
        for (i = 0; i < seriesStorageTop.getSeriesStorageDataTopList().size() && i < seriesStorageTop.getTopNumber(); ++i) {
            seriesColumnData = highchartsFactory.createSeriesColumn();
            seriesColumnData.name(((SeriesStorageDataTop)seriesStorageTop.getSeriesStorageDataTopList().get(i)).getFilterValue().getValue());
            seriesColumnData.color(colors.get(i));
            seriesColumnData.type("column");
            ArrayNumber data = seriesColumnData.dataAsArrayNumber();
            block13: for (SeriesStorageData seriesStorageData : ((SeriesStorageDataTop)seriesStorageTop.getSeriesStorageDataTopList().get(i)).getSeries()) {
                switch (14.$SwitchMap$org$gcube$portlets$admin$accountingmanager$client$maindata$charts$utils$StorageChartMeasure[this.measure.ordinal()]) {
                    case 1: {
                        data.push((double)(seriesStorageData.getDataVolume() / this.unitMeasure));
                        continue block13;
                    }
                    case 2: {
                        data.push((double)seriesStorageData.getOperationCount().longValue());
                        continue block13;
                    }
                }
                data.push((double)seriesStorageData.getDataVolume().longValue());
            }
            seriesColumnData.pointInterval(interval).pointStart((double)dateStart.getTime());
            seriesColumn.add(seriesColumnData);
        }
        if (i < seriesStorageTop.getSeriesStorageDataTopList().size()) {
            seriesColumnData = highchartsFactory.createSeriesColumn();
            seriesColumnData.name("Others");
            seriesColumnData.color(colors.get(i));
            seriesColumnData.type("column");
            ArrayList<Long> othersData = new ArrayList<Long>();
            for (int j = i; j < seriesStorageTop.getSeriesStorageDataTopList().size(); ++j) {
                block15: for (int k = 0; k < ((SeriesStorageDataTop)seriesStorageTop.getSeriesStorageDataTopList().get(j)).getSeries().size(); ++k) {
                    SeriesStorageData seriesStorageData = (SeriesStorageData)((SeriesStorageDataTop)seriesStorageTop.getSeriesStorageDataTopList().get(j)).getSeries().get(k);
                    if (j == i) {
                        switch (14.$SwitchMap$org$gcube$portlets$admin$accountingmanager$client$maindata$charts$utils$StorageChartMeasure[this.measure.ordinal()]) {
                            case 1: {
                                othersData.add(seriesStorageData.getDataVolume() / this.unitMeasure);
                                break;
                            }
                            case 2: {
                                othersData.add(seriesStorageData.getOperationCount());
                                break;
                            }
                            default: {
                                othersData.add(seriesStorageData.getDataVolume() / this.unitMeasure);
                                break;
                            }
                        }
                        continue;
                    }
                    switch (14.$SwitchMap$org$gcube$portlets$admin$accountingmanager$client$maindata$charts$utils$StorageChartMeasure[this.measure.ordinal()]) {
                        case 1: {
                            Long value = seriesStorageData.getDataVolume() / this.unitMeasure + (Long)othersData.get(k);
                            othersData.set(k, value);
                            continue block15;
                        }
                        case 2: {
                            Long value = seriesStorageData.getOperationCount() + (Long)othersData.get(k);
                            othersData.set(k, value);
                            continue block15;
                        }
                        default: {
                            Long value = seriesStorageData.getDataVolume() / this.unitMeasure + (Long)othersData.get(k);
                            othersData.set(k, value);
                        }
                    }
                }
            }
            ArrayNumber data = seriesColumnData.dataAsArrayNumber();
            for (Long value : othersData) {
                data.push((double)value.longValue());
            }
            seriesColumnData.pointInterval(interval).pointStart((double)dateStart.getTime());
            seriesColumn.add(seriesColumnData);
        }
    }

    private void createSeriesColumnSimple(SeriesStorageTop seriesStorageTop, double interval, Date dateStart, HighchartsOptionFactory highchartsFactory, ArrayString colors, ArrayList<SeriesColumn> seriesColumn) {
        Log.debug((String)"Series Simple");
        for (int i = 0; i < seriesStorageTop.getSeriesStorageDataTopList().size(); ++i) {
            SeriesColumn seriesColumnData = highchartsFactory.createSeriesColumn();
            seriesColumnData.name(((SeriesStorageDataTop)seriesStorageTop.getSeriesStorageDataTopList().get(i)).getFilterValue().getValue());
            seriesColumnData.color(colors.get(i));
            seriesColumnData.type("column");
            ArrayNumber data = seriesColumnData.dataAsArrayNumber();
            block5: for (SeriesStorageData seriesStorageData : ((SeriesStorageDataTop)seriesStorageTop.getSeriesStorageDataTopList().get(i)).getSeries()) {
                switch (14.$SwitchMap$org$gcube$portlets$admin$accountingmanager$client$maindata$charts$utils$StorageChartMeasure[this.measure.ordinal()]) {
                    case 1: {
                        data.push((double)(seriesStorageData.getDataVolume() / this.unitMeasure));
                        continue block5;
                    }
                    case 2: {
                        data.push((double)seriesStorageData.getOperationCount().longValue());
                        continue block5;
                    }
                }
                data.push((double)seriesStorageData.getDataVolume().longValue());
            }
            seriesColumnData.pointInterval(interval).pointStart((double)dateStart.getTime());
            seriesColumn.add(seriesColumnData);
        }
    }

    private String retrieveYAxis(ArrayString colors) {
        switch (14.$SwitchMap$org$gcube$portlets$admin$accountingmanager$client$maindata$charts$utils$StorageChartMeasure[this.measure.ordinal()]) {
            case 1: {
                return "[{ \"id\": \"" + StorageChartMeasure.DataVolume.name() + "\"," + " \"labels\": {" + "    \"format\": \"{value} " + this.unitMeasureLabel + "\"," + "    \"style\": {" + "       \"color\": \"" + colors.get(1) + "\"" + "     }" + " }," + " \"stackLabels\": {" + " \"enabled\": \"true\"," + " \"style\": {" + "     \"fontWeight\": \"bold\"," + "    \"color\": \"gray\"" + "   } " + "   }," + " \"title\": { " + "    \"text\": \"" + StorageChartMeasure.DataVolume.getLabel() + "\"," + "    \"style\": {" + "       \"color\": \"" + colors.get(1) + "\"" + "    }" + " }" + "}]";
            }
            case 2: {
                return "[{ \"id\": \"" + StorageChartMeasure.OperationCount.name() + "\"," + " \"labels\": { " + "    \"format\": \"{value}\"," + "    \"style\": { " + "      \"color\": \"" + colors.get(1) + "\"" + "    }" + " }," + " \"stackLabels\": {" + " \"enabled\": \"true\"," + " \"style\": {" + "     \"fontWeight\": \"bold\"," + "    \"color\": \"gray\"" + "   } " + "   }," + " \"title\": { " + "    \"text\": \"" + StorageChartMeasure.OperationCount.getLabel() + "\"," + "    \"style\": {" + "       \"color\": \"" + colors.get(1) + "\"" + "    }" + " }" + "}]";
            }
        }
        return "[{ \"id\": \"" + StorageChartMeasure.DataVolume.name() + "\"," + " \"labels\": {" + "    \"format\": \"{value} " + this.unitMeasureLabel + "\"," + "    \"style\": {" + "       \"color\": \"" + colors.get(1) + "\"" + "     }" + " }," + " \"stackLabels\": {" + " \"enabled\": \"true\"," + " \"style\": {" + "     \"fontWeight\": \"bold\"," + "    \"color\": \"gray\"" + "   } " + "   }," + " \"title\": { " + "    \"text\": \"" + StorageChartMeasure.DataVolume.getLabel() + "\"," + "    \"style\": {" + "       \"color\": \"" + colors.get(1) + "\"" + "    }" + " }" + "}]";
    }

    static /* synthetic */ void access$000(StorageChartTopPanel x0) {
        x0.onDownloadCSV();
    }

    static /* synthetic */ void access$100(StorageChartTopPanel x0) {
        x0.onDownloadXML();
    }

    static /* synthetic */ void access$200(StorageChartTopPanel x0) {
        x0.onDownloadJSON();
    }

    static /* synthetic */ HighchartsLayoutPanel access$300(StorageChartTopPanel x0) {
        return x0.highchartsLayoutPanel;
    }

    static /* synthetic */ TextButton access$400(StorageChartTopPanel x0) {
        return x0.measureButton;
    }

    static /* synthetic */ StorageChartMeasure access$502(StorageChartTopPanel x0, StorageChartMeasure x1) {
        x0.measure = x1;
        return x0.measure;
    }

    static /* synthetic */ TextButton access$600(StorageChartTopPanel x0) {
        return x0.unitButton;
    }

    static /* synthetic */ void access$700(StorageChartTopPanel x0) {
        x0.updateChart();
    }

    static /* synthetic */ long access$802(StorageChartTopPanel x0, long x1) {
        x0.unitMeasure = x1;
        return x0.unitMeasure;
    }

    static /* synthetic */ String access$902(StorageChartTopPanel x0, String x1) {
        x0.unitMeasureLabel = x1;
        return x0.unitMeasureLabel;
    }
}

