/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.accountingmanager.server.is;

import org.gcube.portlets.admin.accountingmanager.server.is.InformationSystemUtils;
import org.gcube.portlets.admin.accountingmanager.server.is.ThreadPoolJAXB;
import org.gcube.portlets.admin.accountingmanager.server.util.ThreadPoolInfo;
import org.gcube.portlets.admin.accountingmanager.shared.exception.ServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildThreadPoolInfo {
    private static Logger logger = LoggerFactory.getLogger(BuildThreadPoolInfo.class);

    public static ThreadPoolInfo build(String scope) throws ServiceException {
        ThreadPoolInfo threadPoolInfo = null;
        ThreadPoolJAXB threadPoolJAXB = null;
        try {
            threadPoolJAXB = InformationSystemUtils.retrieveThreadPoolTimeout((String)scope);
        }
        catch (ServiceException e) {
            logger.debug(e.getLocalizedMessage());
        }
        logger.debug("ThreadPool: " + threadPoolJAXB);
        if (threadPoolJAXB != null && threadPoolJAXB.getTimeout() != null && !threadPoolJAXB.getTimeout().isEmpty()) {
            long timeout = 0L;
            try {
                timeout = Long.parseLong(threadPoolJAXB.getTimeout());
            }
            catch (NumberFormatException e) {
                logger.error("AccountingManager invalid timeout set in threadpool resource", (Throwable)e);
            }
            if (timeout <= 0L) {
                logger.info("AccountingManager use default configuration for threadpool [scope=" + scope + "]");
                threadPoolInfo = new ThreadPoolInfo(1800000L);
            } else {
                logger.info("AccountingManager use timeout=" + timeout + " for threadpool [scope=" + scope + "]");
                threadPoolInfo = new ThreadPoolInfo(timeout);
            }
        } else {
            logger.info("AccountingManager use default configuration for threadpool [scope=" + scope + "]");
            threadPoolInfo = new ThreadPoolInfo(1800000L);
        }
        logger.debug("ThreadPoolInfo: " + threadPoolInfo);
        return threadPoolInfo;
    }
}

