/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.accountingmanager.server.amservice.response;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.SortedMap;
import org.gcube.accounting.analytics.Filter;
import org.gcube.accounting.analytics.Info;
import org.gcube.portlets.admin.accountingmanager.server.amservice.response.SeriesResponseBuilder;
import org.gcube.portlets.admin.accountingmanager.shared.data.Context;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.SeriesJob;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.SeriesResponse;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.job.SeriesJobContext;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.job.SeriesJobData;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.job.SeriesJobDataContext;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.job.SeriesJobDefinition;
import org.gcube.portlets.admin.accountingmanager.shared.exception.ServiceException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeriesResponse4JobContext
extends SeriesResponseBuilder {
    protected static Logger logger = LoggerFactory.getLogger(SeriesResponse4JobContext.class);
    private Context context;
    private SortedMap<Filter, SortedMap<Calendar, Info>> contextSM;

    public SeriesResponse4JobContext(Context context, SortedMap<Filter, SortedMap<Calendar, Info>> contextSM) {
        this.context = context;
        this.contextSM = contextSM;
    }

    public void buildSeriesResponse() throws ServiceException {
        try {
            if (this.contextSM == null || this.contextSM.isEmpty()) {
                logger.error("Error creating series for job accounting: No data available!");
                throw new ServiceException("No data available!");
            }
            ArrayList<SeriesJobDataContext> seriesJobDataContextList = new ArrayList<SeriesJobDataContext>();
            for (Filter contextValue : this.contextSM.keySet()) {
                ArrayList<SeriesJobData> series = new ArrayList<SeriesJobData>();
                SortedMap infos = (SortedMap)this.contextSM.get(contextValue);
                for (Info info : infos.values()) {
                    JSONObject jso = info.getValue();
                    Long duration = jso.getLong("duration");
                    Long operationCount = jso.getLong("operationCount");
                    Long maxInvocationTime = jso.getLong("maxInvocationTime");
                    Long minInvocationTime = jso.getLong("minInvocationTime");
                    series.add(new SeriesJobData(info.getCalendar().getTime(), operationCount, duration, maxInvocationTime, minInvocationTime));
                }
                SeriesJobDataContext seriesJobDataContext = new SeriesJobDataContext(contextValue.getValue(), series);
                seriesJobDataContextList.add(seriesJobDataContext);
            }
            SeriesJobContext seriesJobContext = new SeriesJobContext(this.context, seriesJobDataContextList);
            SeriesJob seriesService = new SeriesJob((SeriesJobDefinition)seriesJobContext);
            this.seriesResponseSpec.setSr((SeriesResponse)seriesService);
        }
        catch (Throwable e) {
            logger.error("Error creating series for job accounting context chart: " + e.getLocalizedMessage());
            e.printStackTrace();
            throw new ServiceException("Error creating series for job accounting context chart: " + e.getLocalizedMessage());
        }
    }
}

