/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.accountingmanager.client.maindata.charts.space;

import com.allen_sauer.gwt.log.client.Log;
import com.github.highcharts4gwt.client.view.widget.HighchartsLayoutPanel;
import com.github.highcharts4gwt.model.array.api.Array;
import com.github.highcharts4gwt.model.array.api.ArrayNumber;
import com.github.highcharts4gwt.model.array.api.ArrayString;
import com.github.highcharts4gwt.model.factory.api.HighchartsOptionFactory;
import com.github.highcharts4gwt.model.factory.jso.JsoHighchartsOptionFactory;
import com.github.highcharts4gwt.model.highcharts.option.api.ChartOptions;
import com.github.highcharts4gwt.model.highcharts.option.api.SeriesColumn;
import com.github.highcharts4gwt.model.highcharts.option.api.seriescolumn.Data;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import com.sencha.gxt.cell.core.client.ButtonCell;
import com.sencha.gxt.core.client.util.Margins;
import com.sencha.gxt.widget.core.client.button.TextButton;
import com.sencha.gxt.widget.core.client.container.BoxLayoutContainer;
import com.sencha.gxt.widget.core.client.container.MarginData;
import com.sencha.gxt.widget.core.client.container.SimpleContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import com.sencha.gxt.widget.core.client.menu.Menu;
import com.sencha.gxt.widget.core.client.menu.MenuItem;
import com.sencha.gxt.widget.core.client.toolbar.ToolBar;
import java.util.ArrayList;
import java.util.Date;
import org.gcube.portlets.admin.accountingmanager.client.event.ExportRequestEvent;
import org.gcube.portlets.admin.accountingmanager.client.maindata.charts.space.SpaceChartSpacesPanel;
import org.gcube.portlets.admin.accountingmanager.client.maindata.charts.utils.ByteUnitMeasure;
import org.gcube.portlets.admin.accountingmanager.client.maindata.charts.utils.ChartDateTimeData;
import org.gcube.portlets.admin.accountingmanager.client.maindata.charts.utils.ChartTimeMeasure;
import org.gcube.portlets.admin.accountingmanager.client.maindata.charts.utils.SpaceChartMeasure;
import org.gcube.portlets.admin.accountingmanager.client.resource.AccountingManagerResources;
import org.gcube.portlets.admin.accountingmanager.client.state.AccountingClientStateData;
import org.gcube.portlets.admin.accountingmanager.shared.data.AccountingPeriod;
import org.gcube.portlets.admin.accountingmanager.shared.data.AccountingPeriodMode;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.SeriesSpace;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.space.SeriesSpaceData;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.space.SeriesSpaceDataSpaces;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.space.SeriesSpaceSpaces;
import org.gcube.portlets.admin.accountingmanager.shared.export.ExportType;

public class SpaceChartSpacesPanel
extends SimpleContainer {
    private static final String DATA_VOLUME_UNIT = "Data Volume Unit";
    private DateTimeFormat dtf = DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.YEAR_MONTH_DAY);
    private EventBus eventBus;
    private AccountingClientStateData accountingStateData;
    private HighchartsLayoutPanel highchartsLayoutPanel;
    private MenuItem downloadCSVItem;
    private MenuItem downloadXMLItem;
    private MenuItem downloadJSONItem;
    private MenuItem downloadPNGItem;
    private MenuItem downloadJPGItem;
    private MenuItem downloadPDFItem;
    private MenuItem downloadSVGItem;
    private MenuItem kBItem;
    private MenuItem MBItem;
    private MenuItem GBItem;
    private MenuItem TBItem;
    private long unitMeasure = ByteUnitMeasure.getMegaByteDimForStorage();
    private String unitMeasureLabel = "MB";
    private TextButton unitButton;
    private ChartOptions options;
    private SpaceChartMeasure measure = SpaceChartMeasure.DataVolume;
    private TextButton measureButton;
    private VerticalLayoutContainer vert;

    public SpaceChartSpacesPanel(EventBus eventBus, AccountingClientStateData accountingStateData) {
        this.eventBus = eventBus;
        this.accountingStateData = accountingStateData;
        this.forceLayoutOnResize = true;
        this.create();
    }

    private void create() {
        ToolBar toolBar = new ToolBar();
        toolBar.setSpacing(2);
        TextButton downloadButton = new TextButton("Download", AccountingManagerResources.INSTANCE.accountingDownload24());
        downloadButton.setIconAlign(ButtonCell.IconAlign.RIGHT);
        downloadButton.setArrowAlign(ButtonCell.ButtonArrowAlign.RIGHT);
        downloadButton.setMenu(this.createDownloadMenu());
        this.unitButton = new TextButton(DATA_VOLUME_UNIT, AccountingManagerResources.INSTANCE.accountingUnitMB24());
        this.unitButton.setIconAlign(ButtonCell.IconAlign.RIGHT);
        this.unitButton.setArrowAlign(ButtonCell.ButtonArrowAlign.RIGHT);
        this.unitButton.setMenu(this.createUnitMenu());
        toolBar.add((IsWidget)downloadButton, new BoxLayoutContainer.BoxLayoutData(new Margins(0)));
        toolBar.add((IsWidget)this.unitButton, new BoxLayoutContainer.BoxLayoutData(new Margins(0)));
        this.createChart();
        this.highchartsLayoutPanel = new HighchartsLayoutPanel();
        this.highchartsLayoutPanel.renderChart(this.options);
        this.vert = new VerticalLayoutContainer();
        this.vert.add((IsWidget)toolBar, new VerticalLayoutContainer.VerticalLayoutData(1.0, -1.0, new Margins(0)));
        this.vert.add((IsWidget)this.highchartsLayoutPanel, new VerticalLayoutContainer.VerticalLayoutData(1.0, 1.0, new Margins(0)));
        this.add((Widget)this.vert, new MarginData(0));
    }

    private void updateChart() {
        this.createChart();
        this.highchartsLayoutPanel.renderChart(this.options);
        this.forceLayout();
    }

    private Menu createDownloadMenu() {
        Menu menuDownload = new Menu();
        this.downloadCSVItem = new MenuItem("Download CSV", AccountingManagerResources.INSTANCE.accountingFileCSV24());
        this.downloadCSVItem.setHeight(30);
        this.downloadXMLItem = new MenuItem("Download XML", AccountingManagerResources.INSTANCE.accountingFileXML24());
        this.downloadXMLItem.setHeight(30);
        this.downloadJSONItem = new MenuItem("Download JSON", AccountingManagerResources.INSTANCE.accountingFileJSON24());
        this.downloadJSONItem.setHeight(30);
        this.downloadPNGItem = new MenuItem("Download PNG Image", AccountingManagerResources.INSTANCE.accountingFilePNG24());
        this.downloadPNGItem.setHeight(30);
        this.downloadJPGItem = new MenuItem("Download JPG Image", AccountingManagerResources.INSTANCE.accountingFileJPG24());
        this.downloadJPGItem.setHeight(30);
        this.downloadPDFItem = new MenuItem("Download PDF Document", AccountingManagerResources.INSTANCE.accountingFilePDF24());
        this.downloadPDFItem.setHeight(30);
        this.downloadSVGItem = new MenuItem("Download SVG Vector Image", AccountingManagerResources.INSTANCE.accountingFileSVG24());
        this.downloadSVGItem.setHeight(30);
        this.downloadCSVItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.downloadXMLItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.downloadJSONItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.downloadPNGItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.downloadJPGItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.downloadPDFItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.downloadSVGItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        menuDownload.add((Widget)this.downloadCSVItem);
        menuDownload.add((Widget)this.downloadXMLItem);
        menuDownload.add((Widget)this.downloadJSONItem);
        menuDownload.add((Widget)this.downloadPNGItem);
        menuDownload.add((Widget)this.downloadJPGItem);
        menuDownload.add((Widget)this.downloadPDFItem);
        menuDownload.add((Widget)this.downloadSVGItem);
        return menuDownload;
    }

    private Menu createUnitMenu() {
        Menu menuUnit = new Menu();
        this.kBItem = new MenuItem("KiloByte", AccountingManagerResources.INSTANCE.accountingUnitkB24());
        this.kBItem.setHeight(30);
        this.MBItem = new MenuItem("MegaByte", AccountingManagerResources.INSTANCE.accountingUnitMB24());
        this.MBItem.setHeight(30);
        this.GBItem = new MenuItem("GigaByte", AccountingManagerResources.INSTANCE.accountingUnitGB24());
        this.GBItem.setHeight(30);
        this.TBItem = new MenuItem("TeraByte", AccountingManagerResources.INSTANCE.accountingUnitTB24());
        this.TBItem.setHeight(30);
        this.kBItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.MBItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.GBItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.TBItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        menuUnit.add((Widget)this.kBItem);
        menuUnit.add((Widget)this.MBItem);
        menuUnit.add((Widget)this.GBItem);
        menuUnit.add((Widget)this.TBItem);
        return menuUnit;
    }

    private void onDownloadCSV() {
        ExportRequestEvent event = new ExportRequestEvent(ExportType.CSV, this.accountingStateData.getAccountingType());
        this.eventBus.fireEvent((GwtEvent)event);
    }

    private void onDownloadXML() {
        ExportRequestEvent event = new ExportRequestEvent(ExportType.XML, this.accountingStateData.getAccountingType());
        this.eventBus.fireEvent((GwtEvent)event);
    }

    private void onDownloadJSON() {
        ExportRequestEvent event = new ExportRequestEvent(ExportType.JSON, this.accountingStateData.getAccountingType());
        this.eventBus.fireEvent((GwtEvent)event);
    }

    public static native void onDownloadPNG(String var0);

    public static native void onDownloadJPG(String var0);

    public static native void onDownloadPDF(String var0);

    public static native void onDownloadSVG(String var0);

    private void createChart() {
        SeriesSpace seriesSpace = (SeriesSpace)this.accountingStateData.getSeriesResponse();
        if (!(seriesSpace.getSerieSpaceDefinition() instanceof SeriesSpaceSpaces)) {
            Log.debug((String)"Invalid SeriesSpaceCategories!");
            return;
        }
        SeriesSpaceSpaces seriesSpaceCategories = (SeriesSpaceSpaces)seriesSpace.getSerieSpaceDefinition();
        JsoHighchartsOptionFactory highchartsFactory = new JsoHighchartsOptionFactory();
        this.options = highchartsFactory.createChartOptions();
        this.options.chart().zoomType("xy");
        this.options.exporting().buttons().contextButton().enabled(false);
        this.options.exporting().filename("AccountingSpaceCategories");
        this.options.title().text("Accounting Space");
        ArrayString colors = this.options.colors();
        this.options.setFieldAsJsonObject("yAxis", this.retrieveYAxis(colors));
        this.options.plotOptions().setFieldAsJsonObject("column", "{ \"stacking\": \"normal\",\"dataLabels\": {     \"enabled\": \"true\",    \"color\": \"white\",     \"style\": {        \"textShadow\": \"0 0 3px black\"    } } }");
        ArrayList seriesColumn = new ArrayList();
        this.createSeriesColumnSimple(seriesSpaceCategories, (HighchartsOptionFactory)highchartsFactory, colors, seriesColumn);
        for (SeriesColumn serie : seriesColumn) {
            this.options.series().addToEnd((Object)serie);
        }
        this.options.chart().showAxes(true);
        this.options.legend().enabled(true);
    }

    private void createSeriesColumnShowOthers(SeriesSpaceSpaces seriesSpaceCategories, HighchartsOptionFactory highchartsFactory, ArrayString colors, ArrayList<SeriesColumn> seriesColumn) {
        Log.debug((String)"Series ShowOthers");
        if (this.accountingStateData.getSeriesRequest().getAccountingPeriod().getPeriod().compareTo((Enum)AccountingPeriodMode.DAILY) == 0 || this.accountingStateData.getSeriesRequest().getAccountingPeriod().getPeriod().compareTo((Enum)AccountingPeriodMode.HOURLY) == 0 || this.accountingStateData.getSeriesRequest().getAccountingPeriod().getPeriod().compareTo((Enum)AccountingPeriodMode.MINUTELY) == 0) {
            SeriesColumn seriesColumnData;
            int i;
            double minRange = ChartTimeMeasure.calculateMinRange((AccountingPeriod)this.accountingStateData.getSeriesRequest().getAccountingPeriod());
            double interval = ChartTimeMeasure.calculateInterval((AccountingPeriod)this.accountingStateData.getSeriesRequest().getAccountingPeriod());
            Date dateStart = this.dtf.parse(this.accountingStateData.getSeriesRequest().getAccountingPeriod().getStartDate());
            dateStart.setTime(dateStart.getTime() + ChartTimeMeasure.timeZoneOffset() * 60000L);
            Log.debug((String)("BuildChart DateStart: " + DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.DATE_TIME_FULL).format(dateStart)));
            this.options.xAxis().type("datetime");
            this.options.xAxis().minRange(minRange);
            this.options.tooltip().xDateFormat("Selected Data");
            for (i = 0; i < seriesSpaceCategories.getSeriesSpaceDataCategoriesList().size(); ++i) {
                seriesColumnData = highchartsFactory.createSeriesColumn();
                seriesColumnData.name(((SeriesSpaceDataSpaces)seriesSpaceCategories.getSeriesSpaceDataCategoriesList().get(i)).getSpace());
                seriesColumnData.color(colors.get(i));
                seriesColumnData.type("column");
                ArrayNumber data = seriesColumnData.dataAsArrayNumber();
                block19: for (SeriesSpaceData seriesSpaceData : ((SeriesSpaceDataSpaces)seriesSpaceCategories.getSeriesSpaceDataCategoriesList().get(i)).getSeries()) {
                    switch (12.$SwitchMap$org$gcube$portlets$admin$accountingmanager$client$maindata$charts$utils$SpaceChartMeasure[this.measure.ordinal()]) {
                        case 1: {
                            data.push((double)(seriesSpaceData.getDataVolume() / this.unitMeasure));
                            continue block19;
                        }
                    }
                    data.push((double)seriesSpaceData.getDataVolume().longValue());
                }
                seriesColumnData.pointInterval(interval).pointStart((double)dateStart.getTime());
                seriesColumn.add(seriesColumnData);
            }
            if (i < seriesSpaceCategories.getSeriesSpaceDataCategoriesList().size()) {
                seriesColumnData = highchartsFactory.createSeriesColumn();
                seriesColumnData.name("Others");
                seriesColumnData.color(colors.get(i));
                seriesColumnData.type("column");
                ArrayList<Long> othersData = new ArrayList<Long>();
                for (int j = i; j < seriesSpaceCategories.getSeriesSpaceDataCategoriesList().size(); ++j) {
                    block21: for (int k = 0; k < ((SeriesSpaceDataSpaces)seriesSpaceCategories.getSeriesSpaceDataCategoriesList().get(j)).getSeries().size(); ++k) {
                        SeriesSpaceData seriesSpaceData = (SeriesSpaceData)((SeriesSpaceDataSpaces)seriesSpaceCategories.getSeriesSpaceDataCategoriesList().get(j)).getSeries().get(k);
                        if (j == i) {
                            switch (12.$SwitchMap$org$gcube$portlets$admin$accountingmanager$client$maindata$charts$utils$SpaceChartMeasure[this.measure.ordinal()]) {
                                case 1: {
                                    othersData.add(seriesSpaceData.getDataVolume() / this.unitMeasure);
                                    break;
                                }
                                default: {
                                    othersData.add(seriesSpaceData.getDataVolume() / this.unitMeasure);
                                    break;
                                }
                            }
                            continue;
                        }
                        switch (12.$SwitchMap$org$gcube$portlets$admin$accountingmanager$client$maindata$charts$utils$SpaceChartMeasure[this.measure.ordinal()]) {
                            case 1: {
                                Long value = seriesSpaceData.getDataVolume() / this.unitMeasure + (Long)othersData.get(k);
                                othersData.set(k, value);
                                continue block21;
                            }
                            default: {
                                Long value = seriesSpaceData.getDataVolume() / this.unitMeasure + (Long)othersData.get(k);
                                othersData.set(k, value);
                            }
                        }
                    }
                }
                ArrayNumber data = seriesColumnData.dataAsArrayNumber();
                for (Long value : othersData) {
                    data.push((double)value.longValue());
                }
                seriesColumnData.pointInterval(interval).pointStart((double)dateStart.getTime());
                seriesColumn.add(seriesColumnData);
            }
        } else {
            SeriesColumn seriesColumnData;
            int i;
            this.options.xAxis().type("datetime");
            if (this.accountingStateData.getSeriesRequest().getAccountingPeriod().getPeriod().compareTo((Enum)AccountingPeriodMode.MONTHLY) == 0) {
                this.options.tooltip().xDateFormat("Selected Data");
            } else if (this.accountingStateData.getSeriesRequest().getAccountingPeriod().getPeriod().compareTo((Enum)AccountingPeriodMode.YEARLY) == 0) {
                this.options.tooltip().xDateFormat("Selected Data");
            } else {
                this.options.tooltip().xDateFormat("Selected Data");
            }
            for (i = 0; i < seriesSpaceCategories.getSeriesSpaceDataCategoriesList().size(); ++i) {
                seriesColumnData = highchartsFactory.createSeriesColumn();
                seriesColumnData.name(((SeriesSpaceDataSpaces)seriesSpaceCategories.getSeriesSpaceDataCategoriesList().get(i)).getSpace());
                seriesColumnData.color(colors.get(i));
                seriesColumnData.type("column");
                Array arrayData = seriesColumnData.dataAsArrayObject();
                block24: for (SeriesSpaceData seriesSpaceData : ((SeriesSpaceDataSpaces)seriesSpaceCategories.getSeriesSpaceDataCategoriesList().get(i)).getSeries()) {
                    long dateFrom1970 = seriesSpaceData.getDate().getTime();
                    Log.debug((String)("SeriersSpaceData: " + seriesSpaceData.getDate()));
                    Log.debug((String)("SeriersSpaceData: " + dateFrom1970));
                    Data data = highchartsFactory.createSeriesColumnData();
                    switch (12.$SwitchMap$org$gcube$portlets$admin$accountingmanager$client$maindata$charts$utils$SpaceChartMeasure[this.measure.ordinal()]) {
                        case 1: {
                            data.x((double)dateFrom1970);
                            data.y((double)(seriesSpaceData.getDataVolume() / this.unitMeasure));
                            arrayData.addToEnd((Object)data);
                            continue block24;
                        }
                    }
                    data.x((double)dateFrom1970);
                    data.y((double)(seriesSpaceData.getDataVolume() / this.unitMeasure));
                    arrayData.addToEnd((Object)data);
                }
                seriesColumn.add(seriesColumnData);
            }
            if (i < seriesSpaceCategories.getSeriesSpaceDataCategoriesList().size()) {
                seriesColumnData = highchartsFactory.createSeriesColumn();
                seriesColumnData.name("Others");
                seriesColumnData.color(colors.get(i));
                seriesColumnData.type("column");
                ArrayList<ChartDateTimeData> othersData = new ArrayList<ChartDateTimeData>();
                for (int j = i; j < seriesSpaceCategories.getSeriesSpaceDataCategoriesList().size(); ++j) {
                    block26: for (int k = 0; k < ((SeriesSpaceDataSpaces)seriesSpaceCategories.getSeriesSpaceDataCategoriesList().get(j)).getSeries().size(); ++k) {
                        ChartDateTimeData chartDateTimeData;
                        SeriesSpaceData seriesSpaceData = (SeriesSpaceData)((SeriesSpaceDataSpaces)seriesSpaceCategories.getSeriesSpaceDataCategoriesList().get(j)).getSeries().get(k);
                        if (j == i) {
                            switch (12.$SwitchMap$org$gcube$portlets$admin$accountingmanager$client$maindata$charts$utils$SpaceChartMeasure[this.measure.ordinal()]) {
                                case 1: {
                                    chartDateTimeData = new ChartDateTimeData(seriesSpaceData.getDate(), Long.valueOf(seriesSpaceData.getDataVolume() / this.unitMeasure));
                                    othersData.add(chartDateTimeData);
                                    break;
                                }
                                default: {
                                    chartDateTimeData = new ChartDateTimeData(seriesSpaceData.getDate(), Long.valueOf(seriesSpaceData.getDataVolume() / this.unitMeasure));
                                    othersData.add(chartDateTimeData);
                                    break;
                                }
                            }
                            continue;
                        }
                        switch (12.$SwitchMap$org$gcube$portlets$admin$accountingmanager$client$maindata$charts$utils$SpaceChartMeasure[this.measure.ordinal()]) {
                            case 1: {
                                chartDateTimeData = new ChartDateTimeData(seriesSpaceData.getDate(), Long.valueOf(seriesSpaceData.getDataVolume() / this.unitMeasure + ((ChartDateTimeData)othersData.get(k)).getValue()));
                                othersData.set(k, chartDateTimeData);
                                continue block26;
                            }
                            default: {
                                chartDateTimeData = new ChartDateTimeData(seriesSpaceData.getDate(), Long.valueOf(seriesSpaceData.getDataVolume() / this.unitMeasure + ((ChartDateTimeData)othersData.get(k)).getValue()));
                                othersData.set(k, chartDateTimeData);
                            }
                        }
                    }
                }
                Array arrayData = seriesColumnData.dataAsArrayObject();
                for (ChartDateTimeData chartDateTimeData : othersData) {
                    long dateFrom1970 = chartDateTimeData.getDate().getTime();
                    Log.debug((String)("SeriersOthersData: " + chartDateTimeData.getDate()));
                    Log.debug((String)("SeriersOthersData: " + dateFrom1970));
                    Data data = highchartsFactory.createSeriesColumnData();
                    data.x((double)dateFrom1970);
                    data.y((double)chartDateTimeData.getValue().longValue());
                    arrayData.addToEnd((Object)data);
                }
                seriesColumn.add(seriesColumnData);
            }
        }
    }

    private void createSeriesColumnSimple(SeriesSpaceSpaces seriesSpaceCategories, HighchartsOptionFactory highchartsFactory, ArrayString colors, ArrayList<SeriesColumn> seriesColumn) {
        Log.debug((String)"Series Simple");
        if (this.accountingStateData.getSeriesRequest().getAccountingPeriod().getPeriod().compareTo((Enum)AccountingPeriodMode.DAILY) == 0 || this.accountingStateData.getSeriesRequest().getAccountingPeriod().getPeriod().compareTo((Enum)AccountingPeriodMode.HOURLY) == 0 || this.accountingStateData.getSeriesRequest().getAccountingPeriod().getPeriod().compareTo((Enum)AccountingPeriodMode.MINUTELY) == 0) {
            double minRange = ChartTimeMeasure.calculateMinRange((AccountingPeriod)this.accountingStateData.getSeriesRequest().getAccountingPeriod());
            double interval = ChartTimeMeasure.calculateInterval((AccountingPeriod)this.accountingStateData.getSeriesRequest().getAccountingPeriod());
            Date dateStart = this.dtf.parse(this.accountingStateData.getSeriesRequest().getAccountingPeriod().getStartDate());
            dateStart.setTime(dateStart.getTime() + ChartTimeMeasure.timeZoneOffset() * 60000L);
            Log.debug((String)("BuildChart DateStart: " + DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.DATE_TIME_FULL).format(dateStart)));
            this.options.xAxis().type("datetime");
            this.options.xAxis().minRange(minRange);
            this.options.tooltip().xDateFormat("Selected Data");
            for (int i = 0; i < seriesSpaceCategories.getSeriesSpaceDataCategoriesList().size(); ++i) {
                SeriesColumn seriesColumnData = highchartsFactory.createSeriesColumn();
                seriesColumnData.name(((SeriesSpaceDataSpaces)seriesSpaceCategories.getSeriesSpaceDataCategoriesList().get(i)).getSpace());
                seriesColumnData.color(colors.get(i));
                seriesColumnData.type("column");
                ArrayNumber data = seriesColumnData.dataAsArrayNumber();
                block7: for (SeriesSpaceData seriesSpaceData : ((SeriesSpaceDataSpaces)seriesSpaceCategories.getSeriesSpaceDataCategoriesList().get(i)).getSeries()) {
                    switch (12.$SwitchMap$org$gcube$portlets$admin$accountingmanager$client$maindata$charts$utils$SpaceChartMeasure[this.measure.ordinal()]) {
                        case 1: {
                            data.push((double)(seriesSpaceData.getDataVolume() / this.unitMeasure));
                            continue block7;
                        }
                    }
                    data.push((double)seriesSpaceData.getDataVolume().longValue());
                }
                seriesColumnData.pointInterval(interval).pointStart((double)dateStart.getTime());
                seriesColumn.add(seriesColumnData);
            }
        } else {
            this.options.xAxis().type("datetime");
            if (this.accountingStateData.getSeriesRequest().getAccountingPeriod().getPeriod().compareTo((Enum)AccountingPeriodMode.MONTHLY) == 0) {
                this.options.tooltip().xDateFormat("Selected Data");
            } else if (this.accountingStateData.getSeriesRequest().getAccountingPeriod().getPeriod().compareTo((Enum)AccountingPeriodMode.YEARLY) == 0) {
                this.options.tooltip().xDateFormat("Selected Data");
            } else {
                this.options.tooltip().xDateFormat("Selected Data");
            }
            for (int i = 0; i < seriesSpaceCategories.getSeriesSpaceDataCategoriesList().size(); ++i) {
                SeriesColumn seriesColumnData = highchartsFactory.createSeriesColumn();
                seriesColumnData.name(((SeriesSpaceDataSpaces)seriesSpaceCategories.getSeriesSpaceDataCategoriesList().get(i)).getSpace());
                seriesColumnData.color(colors.get(i));
                seriesColumnData.type("column");
                Array arrayData = seriesColumnData.dataAsArrayObject();
                block9: for (SeriesSpaceData seriesSpaceData : ((SeriesSpaceDataSpaces)seriesSpaceCategories.getSeriesSpaceDataCategoriesList().get(i)).getSeries()) {
                    long dateFrom1970 = seriesSpaceData.getDate().getTime();
                    Log.debug((String)("SeriersSpaceData: " + seriesSpaceData.getDate()));
                    Log.debug((String)("SeriersStorageData: " + dateFrom1970));
                    Data data = highchartsFactory.createSeriesColumnData();
                    switch (12.$SwitchMap$org$gcube$portlets$admin$accountingmanager$client$maindata$charts$utils$SpaceChartMeasure[this.measure.ordinal()]) {
                        case 1: {
                            data.x((double)dateFrom1970);
                            data.y((double)(seriesSpaceData.getDataVolume() / this.unitMeasure));
                            arrayData.addToEnd((Object)data);
                            continue block9;
                        }
                    }
                    data.x((double)dateFrom1970);
                    data.y((double)(seriesSpaceData.getDataVolume() / this.unitMeasure));
                    arrayData.addToEnd((Object)data);
                }
                seriesColumn.add(seriesColumnData);
            }
        }
    }

    private String retrieveYAxis(ArrayString colors) {
        switch (12.$SwitchMap$org$gcube$portlets$admin$accountingmanager$client$maindata$charts$utils$SpaceChartMeasure[this.measure.ordinal()]) {
            case 1: {
                return "[{ \"id\": \"" + SpaceChartMeasure.DataVolume.name() + "\"," + " \"labels\": {" + "    \"format\": \"{value} " + this.unitMeasureLabel + "\"," + "    \"style\": {" + "       \"color\": \"" + colors.get(1) + "\"" + "     }" + " }," + " \"stackLabels\": {" + " \"enabled\": \"true\"," + " \"style\": {" + "     \"fontWeight\": \"bold\"," + "    \"color\": \"gray\"" + "   } " + "   }," + " \"title\": { " + "    \"text\": \"" + SpaceChartMeasure.DataVolume.getLabel() + "\"," + "    \"style\": {" + "       \"color\": \"" + colors.get(1) + "\"" + "    }" + " }" + "}]";
            }
        }
        return "[{ \"id\": \"" + SpaceChartMeasure.DataVolume.name() + "\"," + " \"labels\": {" + "    \"format\": \"{value} " + this.unitMeasureLabel + "\"," + "    \"style\": {" + "       \"color\": \"" + colors.get(1) + "\"" + "     }" + " }," + " \"stackLabels\": {" + " \"enabled\": \"true\"," + " \"style\": {" + "     \"fontWeight\": \"bold\"," + "    \"color\": \"gray\"" + "   } " + "   }," + " \"title\": { " + "    \"text\": \"" + SpaceChartMeasure.DataVolume.getLabel() + "\"," + "    \"style\": {" + "       \"color\": \"" + colors.get(1) + "\"" + "    }" + " }" + "}]";
    }

    static /* synthetic */ void access$000(SpaceChartSpacesPanel x0) {
        x0.onDownloadCSV();
    }

    static /* synthetic */ void access$100(SpaceChartSpacesPanel x0) {
        x0.onDownloadXML();
    }

    static /* synthetic */ void access$200(SpaceChartSpacesPanel x0) {
        x0.onDownloadJSON();
    }

    static /* synthetic */ HighchartsLayoutPanel access$300(SpaceChartSpacesPanel x0) {
        return x0.highchartsLayoutPanel;
    }

    static /* synthetic */ long access$402(SpaceChartSpacesPanel x0, long x1) {
        x0.unitMeasure = x1;
        return x0.unitMeasure;
    }

    static /* synthetic */ String access$502(SpaceChartSpacesPanel x0, String x1) {
        x0.unitMeasureLabel = x1;
        return x0.unitMeasureLabel;
    }

    static /* synthetic */ TextButton access$600(SpaceChartSpacesPanel x0) {
        return x0.unitButton;
    }

    static /* synthetic */ void access$700(SpaceChartSpacesPanel x0) {
        x0.updateChart();
    }
}

