/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.accountingmanager.server.amservice.query;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.gcube.accounting.aggregation.AggregatedStorageUsageRecord;
import org.gcube.accounting.analytics.Filter;
import org.gcube.accounting.analytics.TemporalConstraint;
import org.gcube.portlets.admin.accountingmanager.server.amservice.PeriodModeMap;
import org.gcube.portlets.admin.accountingmanager.server.amservice.query.AccountingQuery;
import org.gcube.portlets.admin.accountingmanager.server.amservice.query.AccountingQueryBuilder;
import org.gcube.portlets.admin.accountingmanager.shared.data.AccountingFilter;
import org.gcube.portlets.admin.accountingmanager.shared.data.AccountingPeriodMode;
import org.gcube.portlets.admin.accountingmanager.shared.data.query.SeriesRequest;
import org.gcube.portlets.admin.accountingmanager.shared.exception.AccountingManagerServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountingQuery4Storage
extends AccountingQueryBuilder {
    protected static Logger logger = LoggerFactory.getLogger(AccountingQuery4Storage.class);
    private SeriesRequest seriesRequest;

    public AccountingQuery4Storage(SeriesRequest seriesRequest) {
        this.seriesRequest = seriesRequest;
    }

    public void buildOpEx() throws AccountingManagerServiceException {
        Calendar startCalendar = GregorianCalendar.getInstance(TemporalConstraint.DEFAULT_TIME_ZONE);
        try {
            startCalendar.setTime(this.sdf.parse(this.seriesRequest.getAccountingPeriod().getStartDate()));
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw new AccountingManagerServiceException("Start Date not valid!");
        }
        Calendar endCalendar = GregorianCalendar.getInstance(TemporalConstraint.DEFAULT_TIME_ZONE);
        try {
            endCalendar.setTime(this.sdf.parse(this.seriesRequest.getAccountingPeriod().getEndDate()));
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw new AccountingManagerServiceException("End Date not valid!");
        }
        endCalendar.set(11, 23);
        endCalendar.set(12, 59);
        endCalendar.set(13, 59);
        endCalendar.set(14, 999);
        TemporalConstraint temporalConstraint = new TemporalConstraint(startCalendar.getTimeInMillis(), endCalendar.getTimeInMillis(), PeriodModeMap.getMode((AccountingPeriodMode)this.seriesRequest.getAccountingPeriod().getPeriod()));
        ArrayList accountingFilters = this.seriesRequest.getFilters();
        ArrayList<Filter> filters = null;
        if (accountingFilters != null) {
            filters = new ArrayList<Filter>();
            for (AccountingFilter accountigFilters : accountingFilters) {
                Filter filter = new Filter(accountigFilters.getFilterKey().getKey(), accountigFilters.getFilterValue());
                filters.add(filter);
            }
        }
        AccountingQuery invocation = new AccountingQuery(AggregatedStorageUsageRecord.class, temporalConstraint, filters);
        this.accountingQuerySpec.setOp(invocation);
    }
}

