package org.gcube.portlets.admin.accountingmanager.server.amservice.response;

import java.util.ArrayList;
import java.util.List;

import org.gcube.accounting.aggregation.AggregatedStorageUsageRecord;
import org.gcube.accounting.analytics.Info;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.SeriesStorage;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.SeriesStorageData;
import org.gcube.portlets.admin.accountingmanager.shared.exception.AccountingManagerServiceException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Series Response 4 Storage
 * 
 * @author "Giancarlo Panichi" email: <a
 *         href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a>
 * 
 */
public class SeriesResponse4Storage extends SeriesResponseBuilder {
	protected static Logger logger = LoggerFactory
			.getLogger(SeriesResponse4Storage.class);
	private List<Info> infos;

	public SeriesResponse4Storage(List<Info> infos) {
		this.infos = infos;
	}

	@Override
	public void buildSeriesResponse() throws AccountingManagerServiceException {
		try {
			if(infos.size()<=0){
				logger.error("Error creating series for storage accounting: No data available!");
				throw new AccountingManagerServiceException("No data available!");
			}
			
			ArrayList<SeriesStorageData> series=new ArrayList<SeriesStorageData>();
			for (Info info : infos) {
				JSONObject jso = info.getValue();
				Long dataVolume = jso.getLong(AggregatedStorageUsageRecord.DATA_VOLUME);
				Long operationCount = jso
						.getLong(AggregatedStorageUsageRecord.OPERATION_COUNT);
				series.add(new SeriesStorageData(info.getCalendar().getTime(), dataVolume, operationCount));
			
			}

			SeriesStorage seriesStorage = new SeriesStorage(series);

			seriesResponseSpec.setSr(seriesStorage);
		} catch (Throwable e) {
			logger.error("Error creating series for storage accounting: "+e.getLocalizedMessage());
			e.printStackTrace();
			throw new AccountingManagerServiceException("Error creating series for storage accounting: "+e.getLocalizedMessage());
		}
	}
}
