<%@ include file="/init.jsp" %>

<%@ page import="java.util.List" %>
<%@ page import="org.gcube.portlets.admin.configuration.RPTTokenConfiguration" %>

<%
List<String> userContexts = (List<String>) request.getAttribute("userContexts");
List<String> vreContexts = (List<String>) request.getAttribute("vreContexts");
RPTTokenConfiguration configuration = (RPTTokenConfiguration) request.getAttribute("configuration");

if (userContexts == null) userContexts = new java.util.ArrayList<>();
if (vreContexts == null) vreContexts = new java.util.ArrayList<>();
%>

<portlet:resourceURL var="tokenExchangeURL" />

<div class="rpt-token-portlet">
	<div class="portlet-header">
		<h3><liferay-ui:message key="personal.token.title" /></h3>
		<p class="text-muted"><liferay-ui:message key="personal.token.description" /></p>
	</div>

	<div class="token-form-container">
		<div class="form-group">
			<label for="<portlet:namespace />contextSelect" class="control-label">
				<liferay-ui:message key="select.context" />:
			</label>
			<select id="<portlet:namespace />contextSelect" class="form-control" onchange="<%= renderResponse.getNamespace() %>resetResults()">
				<option value=""><liferay-ui:message key="select.context.placeholder" /></option>
				<% if (!vreContexts.isEmpty()) { %>
					<optgroup label="<liferay-ui:message key="vre.contexts" />">
						<% for (String context : vreContexts) { %>
							<option value="<%= context %>"><%= context %></option>
						<% } %>
					</optgroup>
				<% } %>
				<% if (!userContexts.isEmpty()) { %>
					<optgroup label="<liferay-ui:message key="user.contexts" />">
						<% for (String context : userContexts) { %>
							<option value="<%= context %>"><%= context %></option>
						<% } %>
					</optgroup>
				<% } %>
			</select>
		</div>

		<div class="form-group">
			<button id="<portlet:namespace />getTokenBtn" 
					class="btn btn-primary" 
					onclick="<%= renderResponse.getNamespace() %>getToken()" 
					disabled>
				<svg class="lexicon-icon lexicon-icon-key" focusable="false" role="presentation">
					<use href="#key"></use>
				</svg>
				<liferay-ui:message key="get.token" />
			</button>
			<button id="<portlet:namespace />resetBtn" 
					class="btn btn-secondary ml-2" 
					onclick="<%= renderResponse.getNamespace() %>resetResults()">
				<svg class="lexicon-icon lexicon-icon-reload" focusable="false" role="presentation">
					<use href="#reload"></use>
				</svg>
				<liferay-ui:message key="reset" />
			</button>
		</div>
	</div>

	<div id="<portlet:namespace />loadingDiv" class="loading-container" style="display: none;">
		<div class="spinner-border text-primary" role="status">
			<span class="sr-only"><liferay-ui:message key="loading" />...</span>
		</div>
		<p class="mt-2"><liferay-ui:message key="exchanging.token" />...</p>
	</div>

	<div id="<portlet:namespace />errorDiv" class="alert alert-danger" style="display: none;">
		<h5><i class="icon-warning-sign"></i> <liferay-ui:message key="error" /></h5>
		<p id="<portlet:namespace />errorMessage"></p>
	</div>

	<div id="<portlet:namespace />resultsDiv" class="token-results" style="display: none;">
		<div class="card">
			<div class="card-header">
				<h5><i class="icon-ok-sign text-success"></i> <liferay-ui:message key="token.exchange.success" /></h5>
			</div>
			<div class="card-body">
				<div class="row">
					<div class="col-md-6">
						<h6><liferay-ui:message key="access.token" />:</h6>
						<div class="token-display">
							<textarea id="<portlet:namespace />accessToken" class="form-control token-textarea" readonly></textarea>
							<button class="btn btn-sm btn-outline-secondary mt-1" onclick="<portlet:namespace />;copyToClipboard('<portlet:namespace />accessToken')">
								<i class="icon-copy"></i> <liferay-ui:message key="copy" />
							</button>
						</div>
						<small class="text-muted">
							<liferay-ui:message key="expires.in" />: <span id="<portlet:namespace />accessTokenExpiry"></span>
						</small>
					</div>
					<div class="col-md-6">
						<h6><liferay-ui:message key="refresh.token" />:</h6>
						<div class="token-display">
							<textarea id="<portlet:namespace />refreshToken" class="form-control token-textarea" readonly></textarea>
							<button class="btn btn-sm btn-outline-secondary mt-1" onclick="<portlet:namespace />;copyToClipboard('<portlet:namespace />refreshToken')">
								<i class="icon-copy"></i> <liferay-ui:message key="copy" />
							</button>
						</div>
						<small class="text-muted">
							<liferay-ui:message key="expires.in" />: <span id="<portlet:namespace />refreshTokenExpiry"></span>
						</small>
					</div>
				</div>

				<div class="usage-examples mt-4">
					<h6><liferay-ui:message key="usage.examples" />:</h6>
					<div class="accordion" id="<portlet:namespace />usageAccordion">
						<div class="card">
							<div class="card-header" id="<portlet:namespace />curlHeading">
								<h6 class="mb-0">
									<button class="btn btn-link" type="button" data-toggle="collapse" 
											data-target="#<portlet:namespace />curlCollapse" aria-expanded="true">
										cURL Example
									</button>
								</h6>
							</div>
							<div id="<portlet:namespace />curlCollapse" class="collapse" 
								 data-parent="#<portlet:namespace />usageAccordion">
								<div class="card-body">
									<pre id="<portlet:namespace />curlExample" class="bg-light p-2"></pre>
									<button class="btn btn-sm btn-outline-secondary" 
											onclick="<portlet:namespace />;copyToClipboard('<portlet:namespace />curlExample')">
										<i class="icon-copy"></i> <liferay-ui:message key="copy" />
									</button>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>

<%
// Generate namespace once for JavaScript usage
String portletNamespace = renderResponse.getNamespace();
%>

<script>
// Store namespace in a JavaScript variable to avoid JSP tag mixing
var portletNamespace = '<%= portletNamespace %>';

// Create namespaced functions using dynamic assignment to avoid JSP parsing issues
window[portletNamespace + 'getToken'] = function() {
	var contextSelect = document.getElementById(portletNamespace + 'contextSelect');
	var selectedContext = contextSelect.value;
	
	if (!selectedContext) {
		alert('<liferay-ui:message key="please.select.context" />');
		return;
	}
	
	window[portletNamespace + 'showLoading']();
	window[portletNamespace + 'resetResults']();
	
	// Use modern fetch API instead of deprecated AUI.io
	var formData = new FormData();
	formData.append('context', selectedContext);
	
	fetch('<%= tokenExchangeURL %>', {
		method: 'POST',
		body: formData,
		headers: {
			'X-Requested-With': 'XMLHttpRequest'
		}
	})
	.then(function(response) {
		window[portletNamespace + 'hideLoading']();
		if (!response.ok) {
			throw new Error('Network response was not ok');
		}
		return response.json();
	})
	.then(function(data) {
		if (data.success) {
			window[portletNamespace + 'setResults'](data);
		} else {
			window[portletNamespace + 'showError'](data.error || 'Unknown error occurred');
		}
	})
	.catch(function(error) {
		window[portletNamespace + 'hideLoading']();
		window[portletNamespace + 'showError']('Network error occurred: ' + error.message);
	});
};

window[portletNamespace + 'resetResults'] = function() {
	document.getElementById(portletNamespace + 'resultsDiv').style.display = 'none';
	document.getElementById(portletNamespace + 'errorDiv').style.display = 'none';
	document.getElementById(portletNamespace + 'loadingDiv').style.display = 'none';
	
	// Enable/disable get token button based on selection
	var contextSelect = document.getElementById(portletNamespace + 'contextSelect');
	var getTokenBtn = document.getElementById(portletNamespace + 'getTokenBtn');
	getTokenBtn.disabled = !contextSelect.value;
};

window[portletNamespace + 'showLoading'] = function() {
	document.getElementById(portletNamespace + 'loadingDiv').style.display = 'block';
	document.getElementById(portletNamespace + 'getTokenBtn').disabled = true;
};

window[portletNamespace + 'hideLoading'] = function() {
	document.getElementById(portletNamespace + 'loadingDiv').style.display = 'none';
	document.getElementById(portletNamespace + 'getTokenBtn').disabled = false;
};

window[portletNamespace + 'showError'] = function(message) {
	document.getElementById(portletNamespace + 'errorMessage').textContent = message;
	document.getElementById(portletNamespace + 'errorDiv').style.display = 'block';
};

window[portletNamespace + 'setResults'] = function(response) {
	// Set token values
	document.getElementById(portletNamespace + 'accessToken').value = response.access_token || '';
	document.getElementById(portletNamespace + 'refreshToken').value = response.refresh_token || '';
	
	// Set expiry information
	document.getElementById(portletNamespace + 'accessTokenExpiry').textContent = 
		window[portletNamespace + 'formatDuration'](response.expires_in);
	document.getElementById(portletNamespace + 'refreshTokenExpiry').textContent = 
		window[portletNamespace + 'formatDuration'](response.refresh_expires_in);
	
	// Set cURL example
	var curlExample = 'curl -H "Authorization: Bearer ' + (response.access_token || '') + '" \\\n' +
					  '     -X GET \\\n' +
					  '     "https://api.example.com/resource"';
	document.getElementById(portletNamespace + 'curlExample').textContent = curlExample;
	
	// Show results
	document.getElementById(portletNamespace + 'resultsDiv').style.display = 'block';
};

window[portletNamespace + 'formatDuration'] = function(seconds) {
	if (!seconds) return 'N/A';
	
	var hours = Math.floor(seconds / 3600);
	var minutes = Math.floor((seconds % 3600) / 60);
	var secs = seconds % 60;
	
	if (hours > 0) {
		return hours + 'h ' + minutes + 'm ' + secs + 's';
	} else if (minutes > 0) {
		return minutes + 'm ' + secs + 's';
	} else {
		return secs + 's';
	}
};

window[portletNamespace + 'copyToClipboard'] = function(elementId) {
	var element = document.getElementById(elementId);
	if (element) {
		element.select();
		element.setSelectionRange(0, 99999); // For mobile devices
		document.execCommand('copy');
		
		// Show feedback
		var originalText = element.nextElementSibling.innerHTML;
		element.nextElementSibling.innerHTML = '<i class="icon-ok"></i> Copied!';
		setTimeout(function() {
			element.nextElementSibling.innerHTML = originalText;
		}, 2000);
	}
};

// Initialize form on page load
document.addEventListener('DOMContentLoaded', function() {
	window[portletNamespace + 'resetResults']();
	
	// Enable get token button when context is selected
	document.getElementById(portletNamespace + 'contextSelect').addEventListener('change', function() {
		window[portletNamespace + 'resetResults']();
	});
});
</script>