/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.portlet;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCPortlet;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletException;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.servlet.http.HttpServletRequest;
import org.gcube.portlets.admin.configuration.RPTTokenConfiguration;
import org.gcube.portlets.admin.service.OIDCTokenService;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"org.gcube.portlets.admin.configuration.RPTTokenConfiguration"}, property={"com.liferay.portlet.display-category=category.d4science", "com.liferay.portlet.header-portlet-css=/css/main.css", "com.liferay.portlet.instanceable=true", "javax.portlet.display-name=Personal Token", "javax.portlet.init-param.template-path=/", "javax.portlet.init-param.view-template=/view.jsp", "javax.portlet.init-param.config-template=/config.jsp", "javax.portlet.name=org_gcube_portlets_admin_RPTTokenPortlet", "javax.portlet.resource-bundle=content.Language", "javax.portlet.security-role-ref=power-user,user,administrator", "javax.portlet.supports.mime-type=text/html", "javax.portlet.portlet-mode=text/html;view,config", "javax.portlet.expiration-cache=0"}, service={Portlet.class})
public class RPTTokenPortlet
extends MVCPortlet {
    private static final Log _log = LogFactoryUtil.getLog(RPTTokenPortlet.class);
    private volatile RPTTokenConfiguration _configuration;
    @Reference
    private OIDCTokenService _oidcTokenService;
    @Reference
    private UserLocalService _userLocalService;
    @Reference
    private Portal _portal;

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws IOException, PortletException {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        if (cmd.equals("update")) {
            try {
                PortletPreferences preferences = actionRequest.getPreferences();
                String exchangeClientId = ParamUtil.getString((PortletRequest)actionRequest, (String)"exchangeClientId");
                String exchangeClientSecret = ParamUtil.getString((PortletRequest)actionRequest, (String)"exchangeClientSecret");
                String defaultTokenUrl = ParamUtil.getString((PortletRequest)actionRequest, (String)"defaultTokenUrl");
                boolean debugMode = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"debugMode");
                preferences.setValue("exchangeClientId", exchangeClientId);
                preferences.setValue("exchangeClientSecret", exchangeClientSecret);
                preferences.setValue("defaultTokenUrl", defaultTokenUrl);
                preferences.setValue("debugMode", String.valueOf(debugMode));
                preferences.store();
                if (_log.isInfoEnabled()) {
                    _log.info((Object)"RPT Token Portlet configuration updated successfully");
                }
            }
            catch (Exception e) {
                _log.error((Object)"Error updating portlet configuration", (Throwable)e);
                throw new PortletException("Error updating configuration", (Throwable)e);
            }
        }
        super.processAction(actionRequest, actionResponse);
    }

    public void render(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException, IOException {
        try {
            ThemeDisplay themeDisplay = (ThemeDisplay)renderRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            User user = themeDisplay.getUser();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Rendering RPT Token Portlet for user: " + user.getEmailAddress()));
            }
            String currentContext = this.getCurrentContext(renderRequest);
            ArrayList<String> userContexts = new ArrayList<String>();
            ArrayList<String> vreContexts = new ArrayList<String>();
            if (currentContext != null && !currentContext.isEmpty()) {
                userContexts.add(currentContext);
                if (currentContext.split("/").length == 4) {
                    vreContexts.add(currentContext);
                }
            }
            userContexts.add("/gcube/devsec/devVRE");
            vreContexts.add("/gcube/devsec/devVRE");
            renderRequest.setAttribute("userContexts", userContexts);
            renderRequest.setAttribute("vreContexts", vreContexts);
            renderRequest.setAttribute("configuration", (Object)this._configuration);
        }
        catch (Exception e) {
            _log.error((Object)"Error in render method", (Throwable)e);
        }
        super.render(renderRequest, renderResponse);
    }

    public void serveResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws IOException, PortletException {
        String context = ParamUtil.getString((PortletRequest)resourceRequest, (String)"context", null);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Token exchange requested for context: " + context));
        }
        resourceResponse.setContentType("application/json");
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        try {
            ThemeDisplay themeDisplay = (ThemeDisplay)resourceRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            User user = themeDisplay.getUser();
            if (user == null || user.isDefaultUser()) {
                jsonObject.put("success", false);
                jsonObject.put("error", "User not authenticated");
                resourceResponse.getWriter().println(jsonObject);
                return;
            }
            HttpServletRequest httpRequest = this._portal.getHttpServletRequest((PortletRequest)resourceRequest);
            String accessToken = this.getAccessTokenFromSession(httpRequest);
            if (accessToken == null || accessToken.isEmpty()) {
                jsonObject.put("success", false);
                jsonObject.put("error", "No access token available");
                resourceResponse.getWriter().println(jsonObject);
                return;
            }
            PortletPreferences preferences = resourceRequest.getPreferences();
            String clientId = preferences.getValue("exchangeClientId", "");
            String clientSecret = preferences.getValue("exchangeClientSecret", "");
            String tokenUrl = preferences.getValue("defaultTokenUrl", "https://accounts.d4science.org/auth/realms/d4science/protocol/openid-connect/token");
            if ((clientId.isEmpty() || clientSecret.isEmpty()) && this._configuration != null) {
                if (clientId.isEmpty()) {
                    clientId = this._configuration.exchangeClientId();
                }
                if (clientSecret.isEmpty()) {
                    clientSecret = this._configuration.exchangeClientSecret();
                }
                if (tokenUrl.equals("https://accounts.d4science.org/auth/realms/d4science/protocol/openid-connect/token")) {
                    tokenUrl = this._configuration.defaultTokenUrl();
                }
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Using OSGi configuration as fallback - ClientId: " + (clientId.isEmpty() ? "EMPTY" : "SET") + ", TokenUrl: " + tokenUrl));
                }
            } else if (_log.isDebugEnabled()) {
                _log.debug((Object)("Using portlet preferences - ClientId: " + (clientId.isEmpty() ? "EMPTY" : "SET") + ", TokenUrl: " + tokenUrl));
            }
            if (clientId.isEmpty() || clientSecret.isEmpty()) {
                jsonObject.put("success", false);
                jsonObject.put("error", "OIDC exchange credentials not configured. Configuration status: " + (this._configuration != null ? "loaded but empty" : "not loaded"));
                jsonObject.put("debug_info", "ClientId empty: " + clientId.isEmpty() + ", ClientSecret empty: " + clientSecret.isEmpty());
                resourceResponse.getWriter().println(jsonObject);
                return;
            }
            JSONObject exchangeResult = this._oidcTokenService.exchangeToken(tokenUrl, accessToken, context, clientId, clientSecret);
            resourceResponse.getWriter().println(exchangeResult);
        }
        catch (Exception e) {
            _log.error((Object)"Error during token exchange", (Throwable)e);
            jsonObject.put("success", false);
            jsonObject.put("error", "Token exchange failed");
            jsonObject.put("message", e.getMessage());
            resourceResponse.getWriter().println(jsonObject);
        }
        super.serveResource(resourceRequest, resourceResponse);
    }

    private String getCurrentContext(RenderRequest request) {
        try {
            ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            long groupId = themeDisplay.getScopeGroupId();
            return "/gcube/devsec/devVRE";
        }
        catch (Exception e) {
            _log.error((Object)"Error getting current context", (Throwable)e);
            return null;
        }
    }

    private String getAccessTokenFromSession(HttpServletRequest request) {
        return "placeholder_access_token";
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        try {
            this._configuration = (RPTTokenConfiguration)ConfigurableUtil.createConfigurable(RPTTokenConfiguration.class, properties);
            if (_log.isInfoEnabled()) {
                _log.info((Object)"RPT Token Portlet activated with configuration");
                if (this._configuration != null) {
                    _log.info((Object)("Configuration details - ClientId: " + (this._configuration.exchangeClientId().isEmpty() ? "EMPTY" : "SET") + ", TokenUrl: " + this._configuration.defaultTokenUrl() + ", Debug: " + this._configuration.debugMode()));
                } else {
                    _log.warn((Object)"Configuration is null after activation");
                }
            }
            if (_log.isDebugEnabled() && properties != null) {
                _log.debug((Object)("Activation properties: " + properties.toString()));
            }
        }
        catch (Exception e) {
            _log.error((Object)"Error during portlet activation", (Throwable)e);
        }
    }
}

