<%@ include file="/init.jsp" %>

<%@ page import="javax.portlet.PortletPreferences" %>

<%
PortletPreferences preferences = renderRequest.getPreferences();

String exchangeClientId = preferences.getValue("exchangeClientId", "rpt-token-client");
String exchangeClientSecret = preferences.getValue("exchangeClientSecret", "");
String defaultTokenUrl = preferences.getValue("defaultTokenUrl", "https://accounts.d4science.org/auth/realms/d4science/protocol/openid-connect/token");
boolean debugMode = Boolean.parseBoolean(preferences.getValue("debugMode", "false"));
%>

<portlet:actionURL var="configurationActionURL" />

<div class="portlet-configuration-body-content">
    <div class="container-fluid-1280">
        
        <!-- Success and Error Messages -->
        <liferay-ui:success key="configurationSaved" message="configuration.saved.successfully" />
        
        <liferay-ui:error key="exchangeClientIdRequired" message="exchange.client.id.required" />
        <liferay-ui:error key="exchangeClientSecretRequired" message="exchange.client.secret.required" />
        <liferay-ui:error key="defaultTokenUrlRequired" message="default.token.url.required" />
        <liferay-ui:error key="configurationError" message="configuration.save.error" />
        
        <aui:form action="<%= configurationActionURL %>" method="post" name="fm">
            <aui:input name="cmd" type="hidden" value="update" />
            <aui:input name="mvcPath" type="hidden" value="/config.jsp" />
            
            <div class="lfr-form-content">
                <div class="sheet">
                    <div class="panel-group panel-group-flush">
                        
                        <!-- OIDC Configuration Panel -->
                        <div class="panel panel-secondary">
                            <div class="panel-heading">
                                <div class="panel-title">
                                    <liferay-ui:message key="oidc.configuration" />
                                </div>
                            </div>
                            <div class="panel-body">
                                <aui:fieldset>
                                    <aui:input 
                                        label="exchange.client.id" 
                                        name="exchangeClientId" 
                                        type="text" 
                                        value="<%= exchangeClientId %>"
                                        helpMessage="oidc.client.id.help"
                                        autocomplete="username"
                                    />
                                    
                                    <aui:input 
                                        label="exchange.client.secret" 
                                        name="exchangeClientSecret" 
                                        type="password" 
                                        value="<%= exchangeClientSecret %>"
                                        helpMessage="oidc.client.secret.help"
                                        autocomplete="current-password"
                                    />
                                    
                                    <aui:input 
                                        label="default.token.url" 
                                        name="defaultTokenUrl" 
                                        type="text" 
                                        value="<%= defaultTokenUrl %>"
                                        helpMessage="token.url.help"
                                        autocomplete="url"
                                    />
                                </aui:fieldset>
                            </div>
                        </div>
                        
                        <!-- Debug Configuration Panel -->
                        <div class="panel panel-secondary">
                            <div class="panel-heading">
                                <div class="panel-title">
                                    <liferay-ui:message key="debug.configuration" />
                                </div>
                            </div>
                            <div class="panel-body">
                                <aui:fieldset>
                                    <aui:input 
                                        label="debug.mode" 
                                        name="debugMode" 
                                        type="checkbox" 
                                        value="<%= debugMode %>"
                                        helpMessage="debug.mode.help"
                                    />
                                </aui:fieldset>
                            </div>
                        </div>
                        
                    </div>
                </div>
            </div>
            
            <aui:button-row>
                <aui:button type="submit" />
            </aui:button-row>
        </aui:form>
    </div>
</div>

<aui:script>
    AUI().ready(function(A) {
        // Validation for required fields
        var form = A.one('#<portlet:namespace />fm');
        
        if (form) {
            form.on('submit', function(event) {
                var clientId = A.one('#<portlet:namespace />exchangeClientId');
                var clientSecret = A.one('#<portlet:namespace />exchangeClientSecret');
                var tokenUrl = A.one('#<portlet:namespace />defaultTokenUrl');
                
                var isValid = true;
                var errorMessage = '';
                
                if (!clientId || !clientId.val().trim()) {
                    errorMessage += '<liferay-ui:message key="client.id.required" />\n';
                    isValid = false;
                }
                
                if (!clientSecret || !clientSecret.val().trim()) {
                    errorMessage += '<liferay-ui:message key="client.secret.required" />\n';
                    isValid = false;
                }
                
                if (!tokenUrl || !tokenUrl.val().trim()) {
                    errorMessage += '<liferay-ui:message key="token.url.required" />\n';
                    isValid = false;
                }
                
                // Basic URL validation
                if (tokenUrl && tokenUrl.val().trim() && !tokenUrl.val().match(/^https?:\/\/.+/)) {
                    errorMessage += '<liferay-ui:message key="token.url.invalid" />\n';
                    isValid = false;
                }
                
                if (!isValid) {
                    event.preventDefault();
                    alert(errorMessage);
                }
            });
        }
    });
</aui:script>