package org.gcube.portlets.admin.configuration;

import aQute.bnd.annotation.metatype.Meta;

/**
 * Configuration interface for RPT Token Portlet
 * 
 * @author netfarm-m2
 */
@Meta.OCD(
    id = "org.gcube.portlets.admin.configuration.RPTTokenConfiguration",
    localization = "content/Language",
    name = "RPT Token Configuration"
)
public interface RPTTokenConfiguration {

    @Meta.AD(
        deflt = "",
        description = "OIDC Token Exchange Client ID for D4Science",
        name = "Exchange Client ID",
        required = false
    )
    public String exchangeClientId();

    @Meta.AD(
        deflt = "",
        description = "OIDC Token Exchange Client Secret for D4Science",
        name = "Exchange Client Secret",
        required = false,
        type = Meta.Type.Password
    )
    public String exchangeClientSecret();

    @Meta.AD(
        deflt = "https://accounts.d4science.org/auth/realms/d4science/protocol/openid-connect/token",
        description = "Default OIDC Token URL",
        name = "Token URL",
        required = false
    )
    public String defaultTokenUrl();

    @Meta.AD(
        deflt = "true",
        description = "Enable debug logging",
        name = "Debug Mode",
        required = false
    )
    public boolean debugMode();
}