package org.gcube.portlet.user.my_vres.client.widgets;

import org.gcube.portlet.user.my_vres.client.MyVREsServiceAsync;
import org.gcube.portlet.user.my_vres.shared.VRE;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Image;

/**
 * 
 * @author Massimiliano Assante - ISTI CNR
 * @version 1.0 Jun 2012
 *
 */
public class ClickableVRE extends HTML {

	private final static int WIDTH = 115;
	private final static int HEIGHT = 120;

	private String name;
	private String imageUrl;
	private int imageWidth = 0;

	public static final String LOADING_IMAGE = GWT.getModuleBaseURL() + "../images/loading.gif";
	Image img = new Image(LOADING_IMAGE);

	public ClickableVRE() {
		super();
	}

	public ClickableVRE(final VRE vre, final MyVREsServiceAsync service) {
		super.setPixelSize(WIDTH, HEIGHT);
		setPixelSize(WIDTH, HEIGHT);
		imageWidth = WIDTH - 20;
		name = (vre.getName().length() > 23) ? vre.getName().substring(0, 23) : vre.getName();
		imageUrl = vre.getImageURL();
		this.setTitle("Enter this VRE");
		int imageHeight = 95;
		String html = "<div class=\"vreCaption\">" + name + "</div>";
		html +=  "<div  style=\"text-align:center\">" +
				"<img width=\"" + imageWidth + "\" height=\"" + imageHeight +"\" src=\"" +imageUrl + "\" />" +
				"</div>";
		setHTML(html);
		setStyleName("vreButton");

		addClickHandler(new ClickHandler() {
			public void onClick(ClickEvent event) {
				showLoading();	
				String scope = vre.getGroupName();
				service.loadLayout(scope,  vre.getFriendlyURL(), new AsyncCallback<Void>() {
					public void onFailure(Throwable arg0) {							
						Window.open( vre.getFriendlyURL(), "_self", "");
					}
					public void onSuccess(Void arg0) {
						Window.open( vre.getFriendlyURL(), "_self", "");
					}
				});

			}					
		}); 			
	}

	public void showLoading() {
		String html = "<table width=\"100%\" height=\"120px\"><tr height=\"120px\"><td align=\"center\"><img src=\"" + img.getUrl() + "\"></td></tr></table>";
		setHTML(html);
	}
}
