/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlet.user.my_vres.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Cookies;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import org.gcube.portlet.user.my_vres.client.MyVREsService;
import org.gcube.portlet.user.my_vres.client.MyVREsServiceAsync;
import org.gcube.portlet.user.my_vres.client.NoVresPanel;
import org.gcube.portlet.user.my_vres.client.widgets.BulletList;
import org.gcube.portlet.user.my_vres.client.widgets.ClickableVRE;
import org.gcube.portlet.user.my_vres.client.widgets.ListItem;
import org.gcube.portlet.user.my_vres.shared.UserBelonging;
import org.gcube.portlet.user.my_vres.shared.VO;
import org.gcube.portlet.user.my_vres.shared.VRE;

public class VresPanel
extends Composite {
    private final MyVREsServiceAsync myVREsService = (MyVREsServiceAsync)GWT.create(MyVREsService.class);
    private static String VO = "Virtual Organizations";
    private static String VRE = "Virtual Research Environments";
    public static final String COOKIE_NAME = "gCube-EnvironmentViewRestore";
    public static final int COOKIE_MONTHS_EXPIRY_TIME = 6;
    private HTML switcher = new HTML();
    private FlowPanel flowPanel;
    private VerticalPanel mainPanel = new VerticalPanel();
    private HorizontalPanel changeViewPanel = new HorizontalPanel();
    private HorizontalPanel imagesPanel = new HorizontalPanel();
    private Timer t = null;
    private ArrayList<VO> cachedVOs = null;
    private boolean isIconView = true;
    boolean hasVres = false;

    public VresPanel() {
        this.mainPanel.setWidth("100%");
        this.mainPanel.setStyleName("mainPanel");
        this.flowPanel = new FlowPanel();
        this.flowPanel.setWidth("100%");
        this.flowPanel.setStyleName("flowPanel");
        this.changeViewPanel.setWidth("95%");
        this.changeViewPanel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
        this.changeViewPanel.add((Widget)this.imagesPanel);
        this.initWidget((Widget)this.mainPanel);
        this.switcher.setStyleName("imageLink");
        this.imagesPanel.add((Widget)this.switcher);
        this.switcher.setStyleName("switcher");
        this.switcher.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.setLastStateUsingCookie();
    }

    private void loadVREs() {
        this.myVREsService.getInfrastructureVOs((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void showListView() {
        this.mainPanel.clear();
        this.mainPanel.add((Widget)this.changeViewPanel);
        HTML voTitle = new HTML(VO);
        voTitle.setStyleName("listPanel-title");
        BulletList voList = new BulletList();
        voList.setStyleName("list");
        boolean showVOs = false;
        for (VO vo : this.cachedVOs) {
            if (vo.isRoot() || vo.getUserBelonging() != UserBelonging.BELONGING) continue;
            voList.add((Widget)this.addVo(vo));
            showVOs = true;
        }
        if (showVOs) {
            this.mainPanel.add((Widget)voTitle);
            this.mainPanel.add((Widget)voList);
        }
        HTML vreTitle = new HTML(VRE);
        vreTitle.setStyleName("listPanel-title");
        BulletList vreList = new BulletList();
        vreList.setStyleName("list");
        boolean showVREs = false;
        ArrayList<VRE> sortedVREs = new ArrayList<VRE>();
        for (VO vo : this.cachedVOs) {
            for (VRE vre : vo.getVres()) {
                sortedVREs.add(vre);
                this.hasVres = true;
            }
        }
        Collections.sort(sortedVREs);
        for (VRE vre : sortedVREs) {
            vreList.add((Widget)this.addVRE(vre));
            showVREs = true;
        }
        if (showVREs) {
            this.mainPanel.add((Widget)vreTitle);
            this.mainPanel.add((Widget)vreList);
        }
        Cookies.setCookie((String)COOKIE_NAME, (String)"1", (Date)this.getExpiryDate());
        this.isIconView = false;
        this.setSwitcherText();
    }

    private void showIconView() {
        this.mainPanel.clear();
        this.flowPanel.clear();
        this.mainPanel.add((Widget)this.changeViewPanel);
        this.mainPanel.add((Widget)this.flowPanel);
        ArrayList<VRE> sortedVREs = new ArrayList<VRE>();
        for (VO vo : this.cachedVOs) {
            for (VRE vre : vo.getVres()) {
                sortedVREs.add(vre);
                this.hasVres = true;
            }
        }
        Collections.sort(sortedVREs);
        for (VRE vre : sortedVREs) {
            ClickableVRE vreButton = new ClickableVRE(vre, this.myVREsService);
            this.flowPanel.add((Widget)vreButton);
        }
        if (!this.hasVres) {
            this.mainPanel.add((Widget)new NoVresPanel());
            this.imagesPanel.clear();
        }
        Cookies.setCookie((String)COOKIE_NAME, (String)"0", (Date)this.getExpiryDate());
        this.isIconView = true;
        this.setSwitcherText();
    }

    private ListItem addVo(VO vo) {
        ListItem li = new ListItem();
        li.setStyleName("list-item item-vo ");
        li.setText(vo.getName());
        li.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        return li;
    }

    private ListItem addVRE(VRE vre) {
        ListItem li = new ListItem();
        li.setStyleName("list-item item-vre ");
        li.setText(vre.getName());
        li.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        return li;
    }

    private void showLoading(ListItem li) {
        li.setText("Loading .");
        this.t = new /* Unavailable Anonymous Inner Class!! */;
        this.t.schedule(250);
    }

    private void setSwitcherText() {
        if (this.isIconView) {
            this.switcher.setHTML("SHOW LIST");
        } else {
            this.switcher.setHTML("SHOW TILES");
        }
    }

    public Date getExpiryDate() {
        Date expiryDate = new Date();
        int month = expiryDate.getMonth();
        expiryDate.setMonth(month += 6);
        return expiryDate;
    }

    private void setLastStateUsingCookie() {
        Date expiryDate = this.getExpiryDate();
        if (Cookies.getCookie((String)COOKIE_NAME) == null) {
            Cookies.setCookie((String)COOKIE_NAME, (String)"0", (Date)expiryDate);
        } else {
            String lastIconsState = Cookies.getCookie((String)COOKIE_NAME);
            this.isIconView = lastIconsState.compareTo("1") != 0;
        }
        this.loadVREs();
    }

    static /* synthetic */ boolean access$0(VresPanel vresPanel) {
        return vresPanel.isIconView;
    }

    static /* synthetic */ void access$1(VresPanel vresPanel) {
        vresPanel.showListView();
    }

    static /* synthetic */ void access$2(VresPanel vresPanel) {
        vresPanel.showIconView();
    }

    static /* synthetic */ void access$3(VresPanel vresPanel, ArrayList arrayList) {
        vresPanel.cachedVOs = arrayList;
    }

    static /* synthetic */ FlowPanel access$4(VresPanel vresPanel) {
        return vresPanel.flowPanel;
    }

    static /* synthetic */ void access$5(VresPanel vresPanel, ListItem listItem) {
        vresPanel.showLoading(listItem);
    }

    static /* synthetic */ MyVREsServiceAsync access$6(VresPanel vresPanel) {
        return vresPanel.myVREsService;
    }

    static /* synthetic */ Timer access$7(VresPanel vresPanel) {
        return vresPanel.t;
    }
}

